/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.remote;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.CancellationException;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.remote.ModelControllerClientToModelControllerAdapter;
import org.jboss.as.protocol.Connection;
import org.jboss.dmr.ModelNode;

public class RemoteProxyController
implements ProxyController {
    private final ModelController delegate;
    private final PathAddress proxyNodeAddress;

    public static ProxyController create(InetAddress inetAddress, int port, PathAddress proxyNodeAddress) throws UnknownHostException {
        if (inetAddress == null) {
            throw new IllegalArgumentException("Null address");
        }
        if (proxyNodeAddress == null) {
            throw new IllegalArgumentException("Null proxy address");
        }
        return new RemoteProxyController(new ModelControllerClientToModelControllerAdapter(inetAddress, port), proxyNodeAddress);
    }

    public static ProxyController create(Connection connection, PathAddress proxyNodeAddress) {
        if (connection == null) {
            throw new IllegalArgumentException("Null connection");
        }
        return new RemoteProxyController(new ModelControllerClientToModelControllerAdapter(connection), proxyNodeAddress);
    }

    private RemoteProxyController(ModelController delegate, PathAddress proxyNodeAddress) {
        this.delegate = delegate;
        this.proxyNodeAddress = proxyNodeAddress;
    }

    @Override
    public OperationResult execute(Operation operation, ResultHandler handler) {
        return this.delegate.execute(operation, handler);
    }

    @Override
    public ModelNode execute(Operation operation) throws CancellationException {
        return this.delegate.execute(operation);
    }

    @Override
    public PathAddress getProxyNodeAddress() {
        return this.proxyNodeAddress;
    }
}

