/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.remote;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.controller.ControllerTransaction;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.TransactionalModelController;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.remote.ModelControllerOperationHandlerImpl;
import org.jboss.as.protocol.MessageHandler;
import org.jboss.as.protocol.ProtocolUtils;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.ManagementResponse;
import org.jboss.dmr.ModelNode;

public class TransactionalModelControllerOperationHandler
extends ModelControllerOperationHandlerImpl {
    private final TransactionalModelController transactionalModelController;
    private final ConcurrentMap<ModelNode, ControllerTransaction> transactions = new ConcurrentHashMap<ModelNode, ControllerTransaction>();
    public static final byte HANDLER_ID = 16;
    public static final byte EXECUTE_TRANSACTIONAL_REQUEST = 33;
    public static final byte EXECUTE_TRANSACTIONAL_RESPONSE = 34;
    public static final byte EXECUTE_TRANSACTIONAL_SYNCHRONOUS_REQUEST = 35;
    public static final byte EXECUTE_TRANSACTIONAL_SYNCHRONOUS_RESPONSE = 36;
    public static final byte TRANSACTION_COMMIT_REQUEST = 37;
    public static final byte TRANSACTION_COMMIT_RESPONSE = 38;
    public static final byte TRANSACTION_ROLLBACK_REQUEST = 39;
    public static final byte TRANSACTION_ROLLBACK_RESPONSE = 40;
    public static final byte TRANSACTION_ID = 48;

    public TransactionalModelControllerOperationHandler(TransactionalModelController modelController, MessageHandler initiatingHandler) {
        super(modelController, initiatingHandler);
        this.transactionalModelController = modelController;
    }

    @Override
    public byte getIdentifier() {
        return 16;
    }

    @Override
    public ManagementResponse operationFor(byte commandByte) {
        switch (commandByte) {
            case 33: {
                return new ExecuteTransactionalAsynchronousOperation();
            }
            case 35: {
                return new ExecuteTransactionalSynchronousOperation();
            }
            case 37: {
                return new CommitTransactionOperation();
            }
            case 39: {
                return new RollbackTransactionOperation();
            }
        }
        ManagementResponse rsp = super.operationFor(commandByte);
        return rsp;
    }

    private ModelNode readNode(InputStream in) throws IOException {
        ModelNode node = new ModelNode();
        node.readExternal(in);
        return node;
    }

    private final class IOExceptionHolder {
        IOException exception;

        private IOExceptionHolder() {
        }

        public IOException getException() {
            return this.exception;
        }

        public void setException(IOException exception) {
            this.exception = exception;
        }
    }

    private final class FailureHolder {
        ModelNode failure;

        private FailureHolder() {
        }

        public ModelNode getFailure() {
            return this.failure;
        }

        public void setFailure(ModelNode failure) {
            this.failure = failure;
        }
    }

    private class RollbackTransactionOperation
    extends ManagementResponse {
        private ModelNode txId;

        RollbackTransactionOperation() {
            super(TransactionalModelControllerOperationHandler.this.getInitiatingHandler());
        }

        protected final byte getResponseCode() {
            return 40;
        }

        protected final void readRequest(InputStream inputStream) throws IOException {
            ProtocolUtils.expectHeader((InputStream)inputStream, (int)48);
            this.txId = new ModelNode();
            this.txId.readExternal(inputStream);
        }

        protected void sendResponse(OutputStream outputStream) throws IOException {
            ControllerTransaction tx = (ControllerTransaction)TransactionalModelControllerOperationHandler.this.transactions.remove(this.txId);
            if (tx != null) {
                tx.setRollbackOnly();
                tx.commit();
            }
        }
    }

    private class CommitTransactionOperation
    extends ManagementResponse {
        private ModelNode txId;

        CommitTransactionOperation() {
            super(TransactionalModelControllerOperationHandler.this.getInitiatingHandler());
        }

        protected final byte getResponseCode() {
            return 38;
        }

        protected final void readRequest(InputStream inputStream) throws IOException {
            ProtocolUtils.expectHeader((InputStream)inputStream, (int)48);
            this.txId = new ModelNode();
            this.txId.readExternal(inputStream);
        }

        protected void sendResponse(OutputStream outputStream) throws IOException {
            ControllerTransaction tx = (ControllerTransaction)TransactionalModelControllerOperationHandler.this.transactions.remove(this.txId);
            if (tx != null) {
                tx.commit();
            }
        }
    }

    private class ExecuteTransactionalAsynchronousOperation
    extends ExecuteTransactionalOperation {
        final int asynchronousRequestId;

        private ExecuteTransactionalAsynchronousOperation() {
            this.asynchronousRequestId = TransactionalModelControllerOperationHandler.this.getNextAsynchronousRequestId();
        }

        protected final byte getResponseCode() {
            return 34;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sendResponse(final OutputStream outputStream) throws IOException {
            final CountDownLatch completeLatch = new CountDownLatch(1);
            final IOExceptionHolder exceptionHolder = new IOExceptionHolder();
            final FailureHolder failureHolder = new FailureHolder();
            final AtomicInteger status = new AtomicInteger(0);
            ControllerTransaction tx = this.getTransaction();
            Operation operation = this.builder.build();
            OperationResult result = TransactionalModelControllerOperationHandler.this.transactionalModelController.execute(operation, new ResultHandler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void handleResultFragment(String[] location, ModelNode fragment) {
                    try {
                        OutputStream outputStream2 = outputStream;
                        synchronized (outputStream2) {
                            outputStream.write(99);
                            outputStream.write(98);
                            StreamUtils.writeInt((OutputStream)outputStream, (int)location.length);
                            for (String loc : location) {
                                StreamUtils.writeUTFZBytes((OutputStream)outputStream, (String)loc);
                            }
                            outputStream.write(96);
                            fragment.writeExternal(outputStream);
                            outputStream.flush();
                        }
                    }
                    catch (IOException e) {
                        TransactionalModelControllerOperationHandler.this.clearAsynchronousOperation(ExecuteTransactionalAsynchronousOperation.this.asynchronousRequestId);
                        exceptionHolder.setException(e);
                        completeLatch.countDown();
                    }
                }

                @Override
                public void handleResultComplete() {
                    TransactionalModelControllerOperationHandler.this.clearAsynchronousOperation(ExecuteTransactionalAsynchronousOperation.this.asynchronousRequestId);
                    if (!status.compareAndSet(0, 1)) {
                        throw new RuntimeException("Result already set");
                    }
                    completeLatch.countDown();
                }

                @Override
                public void handleFailed(ModelNode failureDescription) {
                    TransactionalModelControllerOperationHandler.this.clearAsynchronousOperation(ExecuteTransactionalAsynchronousOperation.this.asynchronousRequestId);
                    if (!status.compareAndSet(0, 2)) {
                        throw new RuntimeException("Result already set");
                    }
                    failureHolder.setFailure(failureDescription);
                    completeLatch.countDown();
                }

                @Override
                public void handleCancellation() {
                    TransactionalModelControllerOperationHandler.this.clearAsynchronousOperation(ExecuteTransactionalAsynchronousOperation.this.asynchronousRequestId);
                    if (!status.compareAndSet(0, 3)) {
                        throw new RuntimeException("Result already set");
                    }
                    completeLatch.countDown();
                }
            }, tx);
            OutputStream outputStream2 = outputStream;
            synchronized (outputStream2) {
                outputStream.write(96);
                ModelNode compensating = result.getCompensatingOperation() != null ? result.getCompensatingOperation() : new ModelNode();
                compensating.writeExternal(outputStream);
                outputStream.flush();
            }
            if (completeLatch.getCount() != 0L) {
                TransactionalModelControllerOperationHandler.this.addAsynchronousOperation(this.asynchronousRequestId, result.getCancellable());
                outputStream2 = outputStream;
                synchronized (outputStream2) {
                    outputStream.write(102);
                    StreamUtils.writeInt((OutputStream)outputStream, (int)this.asynchronousRequestId);
                    outputStream.flush();
                }
                while (true) {
                    try {
                        completeLatch.await();
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    break;
                }
            }
            if (exceptionHolder.getException() != null) {
                throw exceptionHolder.getException();
            }
            switch (status.get()) {
                case 1: {
                    outputStream2 = outputStream;
                    synchronized (outputStream2) {
                        outputStream.write(100);
                        outputStream.flush();
                        break;
                    }
                }
                case 2: {
                    outputStream2 = outputStream;
                    synchronized (outputStream2) {
                        outputStream.write(103);
                        failureHolder.getFailure().writeExternal(outputStream);
                        outputStream.flush();
                        break;
                    }
                }
                case 3: {
                    outputStream2 = outputStream;
                    synchronized (outputStream2) {
                        outputStream.write(101);
                        outputStream.flush();
                        break;
                    }
                }
                default: {
                    throw new IOException("Unknown status type " + status.get());
                }
            }
        }
    }

    private class ExecuteTransactionalSynchronousOperation
    extends ExecuteTransactionalOperation {
        private ExecuteTransactionalSynchronousOperation() {
        }

        protected final byte getResponseCode() {
            return 36;
        }

        protected void sendResponse(OutputStream outputStream) throws IOException {
            ControllerTransaction tx = this.getTransaction();
            Operation operation = this.builder.build();
            ModelNode result = TransactionalModelControllerOperationHandler.this.transactionalModelController.execute(operation, tx);
            outputStream.write(96);
            result.writeExternal(outputStream);
        }
    }

    private abstract class ExecuteTransactionalOperation
    extends ManagementResponse {
        OperationBuilder builder;
        ModelNode txId;

        ExecuteTransactionalOperation() {
            super(TransactionalModelControllerOperationHandler.this.getInitiatingHandler());
        }

        protected void readRequest(InputStream inputStream) throws IOException {
            ProtocolUtils.expectHeader((InputStream)inputStream, (int)48);
            this.txId = new ModelNode();
            this.txId.readExternal(inputStream);
            ProtocolUtils.expectHeader((InputStream)inputStream, (int)96);
            this.builder = OperationBuilder.Factory.create((ModelNode)TransactionalModelControllerOperationHandler.this.readNode(inputStream));
            int cmd = inputStream.read();
            if (cmd == 105) {
                return;
            }
            if (cmd != 104) {
                throw new IllegalArgumentException("Expected 104 received " + cmd);
            }
            while (cmd == 104) {
                int length = StreamUtils.readInt((InputStream)inputStream);
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                for (int i = 0; i < length; ++i) {
                    int b = inputStream.read();
                    if (b == -1) {
                        throw new IllegalArgumentException("Unexpected end of file");
                    }
                    bout.write(b);
                }
                this.builder.addInputStream((InputStream)new ByteArrayInputStream(bout.toByteArray()));
                cmd = inputStream.read();
            }
        }

        protected ControllerTransaction getTransaction() {
            ControllerTransaction result = new ControllerTransaction(this.txId);
            ControllerTransaction existing = TransactionalModelControllerOperationHandler.this.transactions.putIfAbsent(this.txId, result);
            if (existing != null) {
                result = existing;
            }
            return result;
        }
    }
}

