/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.registry;

import org.jboss.as.controller.OperationStepHandler;

public final class AttributeAccess {
    private final AccessType access;
    private final Storage storage;
    private final OperationStepHandler readHandler;
    private final OperationStepHandler writeHandler;

    public AttributeAccess(AccessType access, Storage storage, OperationStepHandler readHandler, OperationStepHandler writeHandler) {
        assert (access != null) : "access is null";
        assert (storage != null) : "storage is null";
        this.access = access;
        this.readHandler = readHandler;
        this.writeHandler = writeHandler;
        this.storage = storage;
        if (access == AccessType.READ_WRITE && writeHandler == null) {
            throw new IllegalArgumentException("writeHandler is null");
        }
    }

    public AccessType getAccessType() {
        return this.access;
    }

    public Storage getStorageType() {
        return this.storage;
    }

    public OperationStepHandler getReadHandler() {
        return this.readHandler;
    }

    public OperationStepHandler getWriteHandler() {
        return this.writeHandler;
    }

    public static enum Storage {
        CONFIGURATION("configuration"),
        RUNTIME("runtime");

        private final String label;

        private Storage(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    public static enum AccessType {
        READ_ONLY("read-only"),
        READ_WRITE("read-write"),
        METRIC("metric");

        private final String label;

        private AccessType(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

