/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.List;
import java.util.concurrent.ExecutorService;
import org.jboss.as.controller.BootContext;
import org.jboss.as.controller.ContainerStateMonitor;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ModelControllerImpl;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SecurityActions;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public abstract class AbstractControllerService
implements Service<ModelController> {
    public static final String BOOT_STACK_SIZE_PROPERTY = "jboss.boot.thread.stack.size";
    public static final int DEFAULT_BOOT_STACK_SIZE = 0x200000;
    private final OperationContext.Type controllerType;
    private final DescriptionProvider rootDescriptionProvider;
    private final ControlledProcessState processState;
    private final OperationStepHandler prepareStep;
    private final InjectedValue<ExecutorService> injectedExecutorService = new InjectedValue();
    private final ExpressionResolver expressionResolver;
    private volatile ModelControllerImpl controller;
    private ConfigurationPersister configurationPersister;

    private static int getBootStackSize() {
        String prop = SecurityActions.getSystemProperty(BOOT_STACK_SIZE_PROPERTY);
        if (prop == null) {
            return 0x200000;
        }
        int base = 1;
        String multiple = prop;
        int lastIdx = prop.length() - 1;
        if (lastIdx > 0) {
            char last = prop.charAt(lastIdx);
            if ('k' == last || 'K' == last) {
                multiple = prop.substring(0, lastIdx);
                base = 1024;
            } else if ('m' == last || 'M' == last) {
                multiple = prop.substring(0, lastIdx);
                base = 0x100000;
            }
        }
        try {
            return Integer.parseInt(multiple) * base;
        }
        catch (NumberFormatException e) {
            ControllerLogger.ROOT_LOGGER.invalidSystemPropertyValue(prop, BOOT_STACK_SIZE_PROPERTY, 0x200000);
            return 0x200000;
        }
    }

    protected AbstractControllerService(OperationContext.Type controllerType, ControlledProcessState processState, DescriptionProvider rootDescriptionProvider, OperationStepHandler prepareStep) {
        this(controllerType, null, processState, rootDescriptionProvider, prepareStep, null);
    }

    protected AbstractControllerService(OperationContext.Type controllerType, ControlledProcessState processState, DescriptionProvider rootDescriptionProvider, OperationStepHandler prepareStep, ExpressionResolver expressionResolver) {
        this(controllerType, null, processState, rootDescriptionProvider, prepareStep, expressionResolver);
    }

    protected AbstractControllerService(OperationContext.Type controllerType, ConfigurationPersister configurationPersister, ControlledProcessState processState, DescriptionProvider rootDescriptionProvider, OperationStepHandler prepareStep, ExpressionResolver expressionResolver) {
        this.controllerType = controllerType;
        this.configurationPersister = configurationPersister;
        this.rootDescriptionProvider = rootDescriptionProvider;
        this.processState = processState;
        this.prepareStep = prepareStep;
        this.expressionResolver = expressionResolver != null ? expressionResolver : ExpressionResolver.DEFAULT;
    }

    public void start(StartContext context) throws StartException {
        if (this.configurationPersister == null) {
            throw ControllerMessages.MESSAGES.persisterNotInjected();
        }
        ServiceController serviceController = context.getController();
        final ServiceContainer container = serviceController.getServiceContainer();
        final ServiceTarget target = context.getChildTarget();
        ExecutorService executorService = (ExecutorService)this.injectedExecutorService.getOptionalValue();
        ModelControllerImpl controller = new ModelControllerImpl((ServiceRegistry)container, target, ManagementResourceRegistration.Factory.create(this.rootDescriptionProvider), new ContainerStateMonitor((ServiceRegistry)container, serviceController), this.configurationPersister, this.controllerType, this.prepareStep, this.processState, executorService, this.expressionResolver);
        this.initModel(controller.getRootResource(), controller.getRootRegistration());
        this.controller = controller;
        final long bootStackSize = AbstractControllerService.getBootStackSize();
        Thread bootThread = new Thread(null, new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        AbstractControllerService.this.boot(new BootContext(){

                            @Override
                            public ServiceTarget getServiceTarget() {
                                return target;
                            }
                        });
                    }
                    catch (ConfigurationPersistenceException e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        AbstractControllerService.this.processState.setRunning();
                    }
                }
                catch (Throwable t) {
                    container.shutdown();
                    if (t instanceof StackOverflowError) {
                        ControllerLogger.ROOT_LOGGER.errorBootingContainer(t, bootStackSize, AbstractControllerService.BOOT_STACK_SIZE_PROPERTY);
                    }
                    ControllerLogger.ROOT_LOGGER.errorBootingContainer(t);
                }
            }
        }, "Controller Boot Thread", bootStackSize);
        bootThread.start();
    }

    protected void boot(BootContext context) throws ConfigurationPersistenceException {
        this.boot(this.configurationPersister.load());
        this.finishBoot();
    }

    protected void boot(List<ModelNode> bootOperations) throws ConfigurationPersistenceException {
        this.controller.boot(bootOperations, OperationMessageHandler.logging, ModelController.OperationTransactionControl.COMMIT);
    }

    protected void finishBoot() throws ConfigurationPersistenceException {
        this.controller.finishBoot();
        this.configurationPersister.successfulBoot();
    }

    public void stop(StopContext context) {
        this.controller = null;
    }

    public ModelController getValue() throws IllegalStateException, IllegalArgumentException {
        ModelControllerImpl controller = this.controller;
        if (controller == null) {
            throw new IllegalStateException();
        }
        return controller;
    }

    public InjectedValue<ExecutorService> getExecutorServiceInjector() {
        return this.injectedExecutorService;
    }

    protected void setConfigurationPersister(ConfigurationPersister persister) {
        this.configurationPersister = persister;
    }

    protected abstract void initModel(Resource var1, ManagementResourceRegistration var2);
}

