/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.parsing;

import java.security.AccessController;
import java.security.PrivilegedAction;

class SecurityActions {
    SecurityActions() {
    }

    static ClassLoader setThreadContextClassLoader(Class cl) {
        if (System.getSecurityManager() == null) {
            return SetThreadContextClassLoaderAction.NON_PRIVILEGED.setThreadContextClassLoader(cl);
        }
        return SetThreadContextClassLoaderAction.PRIVILEGED.setThreadContextClassLoader(cl);
    }

    static void setThreadContextClassLoader(ClassLoader cl) {
        if (System.getSecurityManager() == null) {
            SetThreadContextClassLoaderAction.NON_PRIVILEGED.setThreadContextClassLoader(cl);
        } else {
            SetThreadContextClassLoaderAction.PRIVILEGED.setThreadContextClassLoader(cl);
        }
    }

    private static interface SetThreadContextClassLoaderAction {
        public static final SetThreadContextClassLoaderAction NON_PRIVILEGED = new SetThreadContextClassLoaderAction(){

            @Override
            public ClassLoader setThreadContextClassLoader(Class cl) {
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(cl.getClassLoader());
                return old;
            }

            @Override
            public void setThreadContextClassLoader(ClassLoader cl) {
                Thread.currentThread().setContextClassLoader(cl);
            }
        };
        public static final SetThreadContextClassLoaderAction PRIVILEGED = new SetThreadContextClassLoaderAction(){

            @Override
            public ClassLoader setThreadContextClassLoader(final Class cl) {
                return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        ClassLoader old = Thread.currentThread().getContextClassLoader();
                        Thread.currentThread().setContextClassLoader(cl.getClassLoader());
                        return old;
                    }
                });
            }

            @Override
            public void setThreadContextClassLoader(final ClassLoader cl) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        Thread.currentThread().setContextClassLoader(cl);
                        return null;
                    }
                });
            }
        };

        public ClassLoader setThreadContextClassLoader(Class var1);

        public void setThreadContextClassLoader(ClassLoader var1);
    }
}

