/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.NoSuchElementException;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public abstract class RestartParentResourceHandlerBase
implements OperationStepHandler {
    private final String parentKeyName;

    protected RestartParentResourceHandlerBase(String parentKeyName) {
        this.parentKeyName = parentKeyName;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.updateModel(context, operation);
        if (!context.isBooting() && this.requiresRuntime(context)) {
            context.addStep(new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    boolean reloadRequired;
                    PathAddress address = RestartParentResourceHandlerBase.this.getParentAddress(PathAddress.pathAddress(operation.require("address")));
                    ServiceName serviceName = RestartParentResourceHandlerBase.this.getParentServiceName(address);
                    ServiceController service = serviceName != null ? context.getServiceRegistry(false).getService(serviceName) : null;
                    ModelNode parentModel = null;
                    boolean servicesRestarted = false;
                    boolean bl = reloadRequired = service != null && !RestartParentResourceHandlerBase.this.isResourceServiceRestartAllowed(context, service);
                    if (reloadRequired) {
                        context.reloadRequired();
                    } else if (service != null && (parentModel = RestartParentResourceHandlerBase.this.getModel(context, address)) != null && context.markResourceRestarted(address, this)) {
                        RestartParentResourceHandlerBase.this.removeServices(context, serviceName, parentModel);
                        ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
                        RestartParentResourceHandlerBase.this.recreateParentService(context, address, parentModel, verificationHandler);
                        context.addStep(verificationHandler, OperationContext.Stage.VERIFY);
                        servicesRestarted = true;
                    }
                    final ModelNode invalidatedParentModel = servicesRestarted ? parentModel : null;
                    context.completeStep(new OperationContext.RollbackHandler(){

                        @Override
                        public void handleRollback(OperationContext context, ModelNode operation) {
                            if (reloadRequired) {
                                context.revertReloadRequired();
                            } else if (invalidatedParentModel != null) {
                                RestartParentResourceHandlerBase.this.recoverServices(context, operation, invalidatedParentModel);
                            }
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    protected boolean requiresRuntime(OperationContext context) {
        return context.getProcessType() != ProcessType.HOST_CONTROLLER;
    }

    protected boolean isResourceServiceRestartAllowed(OperationContext context, ServiceController<?> service) {
        return context.isResourceServiceRestartAllowed();
    }

    protected void removeServices(OperationContext context, ServiceName parentService, ModelNode parentModel) throws OperationFailedException {
        context.removeService(parentService);
    }

    protected abstract void updateModel(OperationContext var1, ModelNode var2) throws OperationFailedException;

    protected abstract void recreateParentService(OperationContext var1, PathAddress var2, ModelNode var3, ServiceVerificationHandler var4) throws OperationFailedException;

    protected abstract ServiceName getParentServiceName(PathAddress var1);

    protected PathAddress getParentAddress(PathAddress address) {
        return Util.getParentAddressByKey(address, this.parentKeyName);
    }

    private void recoverServices(OperationContext context, ModelNode operation, ModelNode invalidatedParentModel) {
        PathAddress address = this.getParentAddress(PathAddress.pathAddress(operation.require("address")));
        ServiceName serviceName = this.getParentServiceName(address);
        ModelNode parentModel = this.getOriginalModel(context, address);
        if (parentModel != null && context.revertResourceRestarted(address, this)) {
            try {
                this.removeServices(context, serviceName, invalidatedParentModel);
                this.recreateParentService(context, address, parentModel, null);
            }
            catch (OperationFailedException e) {
                throw ControllerMessages.MESSAGES.failedToRecoverServices(e);
            }
        }
    }

    private ModelNode getModel(OperationContext ctx, PathAddress address) {
        try {
            Resource resource = ctx.readResourceFromRoot(address);
            return Resource.Tools.readModel(resource);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    private ModelNode getOriginalModel(OperationContext ctx, PathAddress address) {
        try {
            Resource resource = ctx.getOriginalRootResource().navigate(address);
            return Resource.Tools.readModel(resource);
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }
}

