/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.transform;

import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.OperationTransformer;
import org.jboss.as.controller.transform.SubsystemTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.TransformationTarget;
import org.jboss.as.controller.transform.TransformerRegistry;
import org.jboss.as.controller.transform.Transformers;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public class TransformersImpl
implements Transformers {
    private static final Logger log = Logger.getLogger(TransformersImpl.class);
    private final TransformationTarget target;

    TransformersImpl(TransformationTarget target) {
        assert (target != null);
        this.target = target;
    }

    @Override
    public TransformationTarget getTarget() {
        return this.target;
    }

    @Override
    public ModelNode transformOperation(TransformationContext context, ModelNode operation) {
        String operationName;
        if (!this.target.isTransformationNeeded()) {
            return operation;
        }
        PathAddress address = PathAddress.pathAddress(operation.require("address"));
        OperationTransformer transformer = this.target.resolveTransformer(address, operationName = operation.require("operation").asString());
        if (transformer == null) {
            ControllerLogger.ROOT_LOGGER.tracef("operation %s does not need transformation", operation);
            return operation;
        }
        return transformer.transformOperation(context, address, operation);
    }

    @Override
    public Resource transformResource(TransformationContext context, Resource resource) {
        if (!this.target.isTransformationNeeded()) {
            return resource;
        }
        return this.resolveRecursive(resource, context.getResourceRegistration(PathAddress.EMPTY_ADDRESS), PathAddress.EMPTY_ADDRESS);
    }

    private Resource resolveRecursive(Resource resource, ImmutableManagementResourceRegistration registration, PathAddress address) {
        boolean isSubsystem;
        boolean bl = isSubsystem = address.size() > 0 && !"extension".equals(address.getElement(0).getKey()) && "subsystem".equals(address.getLastElement().getKey());
        if (isSubsystem) {
            String subsystemName = address.getLastElement().getValue();
            SubsystemTransformer transformer = this.target.getSubsystemTransformer(subsystemName);
            if (transformer != null) {
                log.debug((Object)("transforming subsystem: " + subsystemName + ", to model version: " + transformer.getMajorManagementVersion() + "." + transformer.getMinorManagementVersion()));
                ResourceDefinition rd = TransformerRegistry.loadSubsystemDefinition(subsystemName, transformer.getMajorManagementVersion(), transformer.getMinorManagementVersion());
                ManagementResourceRegistration targetDefinition = ManagementResourceRegistration.Factory.create(rd);
                ModelNode fullSubsystemModel = Resource.Tools.readModel(resource);
                ModelNode transformed = transformer.transformModel(null, fullSubsystemModel);
                return TransformerRegistry.modelToResource(targetDefinition, transformed);
            }
            return resource;
        }
        for (PathElement element : registration.getChildAddresses(PathAddress.EMPTY_ADDRESS)) {
            Resource res;
            if (element.isMultiTarget()) {
                String childType = element.getKey();
                for (Resource.ResourceEntry entry : resource.getChildren(childType)) {
                    ImmutableManagementResourceRegistration childRegistration;
                    Resource res2 = this.resolveRecursive(entry, childRegistration = registration.getSubModel(PathAddress.pathAddress(PathElement.pathElement(childType, entry.getName()))), address.append(entry.getPathElement()));
                    if (res2.equals(entry)) continue;
                    resource.removeChild(entry.getPathElement());
                    resource.registerChild(entry.getPathElement(), res2);
                }
                continue;
            }
            Resource child = resource.getChild(element);
            ImmutableManagementResourceRegistration childRegistration = registration.getSubModel(PathAddress.pathAddress(element));
            if (child == null || (res = this.resolveRecursive(child, childRegistration, address.append(element))).equals(child)) continue;
            resource.removeChild(element);
            resource.registerChild(element, res);
        }
        return resource;
    }

    static class DelegateTransformContext
    implements TransformationContext {
        private final OperationContext context;

        DelegateTransformContext(OperationContext context) {
            this.context = context;
        }

        @Override
        public ProcessType getProcessType() {
            return this.context.getProcessType();
        }

        @Override
        public RunningMode getRunningMode() {
            return this.context.getRunningMode();
        }

        @Override
        public ImmutableManagementResourceRegistration getResourceRegistration(PathAddress address) {
            return this.context.getResourceRegistration().getSubModel(address);
        }

        @Override
        public ImmutableManagementResourceRegistration getResourceRegistrationFromRoot(PathAddress address) {
            return this.context.getRootResourceRegistration().getSubModel(address);
        }

        @Override
        public Resource readResource(PathAddress address) {
            return this.context.readResource(address);
        }

        @Override
        public Resource readResourceFromRoot(PathAddress address) {
            return this.context.readResourceFromRoot(address);
        }
    }
}

