/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.demos;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlan;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.DuplicateDeploymentNameException;
import org.jboss.as.controller.client.helpers.standalone.InitialDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.as.protocol.old.StreamUtils;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.container.ResourceContainer;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;

public class DeploymentUtils
implements Closeable {
    public static final long DEFAULT_TIMEOUT = 15000L;
    private final List<AbstractDeployment> deployments = new ArrayList<AbstractDeployment>();
    private final ModelControllerClient client = ModelControllerClient.Factory.create((String)"localhost", (int)9999);
    private final ServerDeploymentManager manager = ServerDeploymentManager.Factory.create((ModelControllerClient)this.client);
    private long timeout = 15000L;

    public DeploymentUtils() throws UnknownHostException {
    }

    public DeploymentUtils(String archiveName, Package ... pkg) throws UnknownHostException {
        this();
        this.addDeployment(archiveName, pkg);
    }

    public DeploymentUtils(Archive<?> archive) throws UnknownHostException {
        this();
        this.deployments.add(new ArbitraryDeployment(archive, false));
    }

    public DeploymentUtils(String archiveName, boolean show, Package ... pkgs) throws UnknownHostException {
        this();
        this.addDeployment(archiveName, show, pkgs);
    }

    public synchronized void addDeployment(String archiveName, Package ... pkgs) {
        this.addDeployment(archiveName, false, pkgs);
    }

    public synchronized void addDeployment(String archiveName, boolean show, Package ... pkgs) {
        this.deployments.add(new Deployment(archiveName, pkgs, show));
    }

    public synchronized void addWarDeployment(String archiveName, Package ... pkgs) {
        this.addWarDeployment(archiveName, false, pkgs);
    }

    public synchronized void addWarDeployment(String archiveName, boolean show, Package ... pkgs) {
        this.deployments.add(new WarDeployment(archiveName, pkgs, show));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deploy() throws DuplicateDeploymentNameException, IOException, ExecutionException, InterruptedException, TimeoutException {
        InitialDeploymentPlanBuilder builder = this.manager.newDeploymentPlan();
        for (AbstractDeployment deployment : this.deployments) {
            builder = deployment.addDeployment(this.manager, (DeploymentPlanBuilder)builder);
        }
        try {
            this.manager.execute(builder.build()).get(this.timeout, TimeUnit.MILLISECONDS);
        }
        finally {
            this.markDeploymentsDeployed();
        }
    }

    private void markDeploymentsDeployed() {
        for (AbstractDeployment deployment : this.deployments) {
            deployment.deployed = true;
        }
    }

    public synchronized void undeploy() throws ExecutionException, InterruptedException, TimeoutException {
        InitialDeploymentPlanBuilder builder = this.manager.newDeploymentPlan();
        for (AbstractDeployment deployment : this.deployments) {
            builder = deployment.removeDeployment((DeploymentPlanBuilder)builder);
        }
        DeploymentPlan plan = builder.build();
        if (plan.getDeploymentActions().size() > 0) {
            this.manager.execute(builder.build()).get(this.timeout, TimeUnit.MILLISECONDS);
        }
    }

    public MBeanServerConnection getConnection() throws Exception {
        return JMXConnectorFactory.connect(new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:1090/jmxrmi"), new HashMap()).getMBeanServerConnection();
    }

    public String showJndi() throws Exception {
        return (String)this.getConnection().invoke(new ObjectName("jboss:type=JNDIView"), "list", new Object[]{true}, new String[]{"boolean"});
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public void close() throws IOException {
        StreamUtils.safeClose((Closeable)this.client);
    }

    private class ArbitraryDeployment
    extends AbstractDeployment {
        final File realArchive;

        public ArbitraryDeployment(Archive<?> archive, boolean show) {
            System.out.println(archive.toString(show));
            this.realArchive = this.createArchive(archive);
        }

        @Override
        protected File getRealArchive() {
            return this.realArchive;
        }
    }

    private class WarDeployment
    extends AbstractDeployment {
        final File realArchive;

        public WarDeployment(String archiveName, Package[] pkgs, boolean show) {
            ArchivePath metaInf = ArchivePaths.create((String)"META-INF");
            WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)archiveName);
            for (Package pkg : pkgs) {
                archive.addPackage(pkg);
            }
            File sourceMetaInf = this.getSourceMetaInfDir(archiveName);
            this.addFiles((ResourceContainer<?>)archive, sourceMetaInf, metaInf);
            File sourceWebInf = this.getSourceWebInfDir(archiveName);
            if (sourceWebInf != null) {
                this.addWebFiles(archive, sourceWebInf, ArchivePaths.create((String)"WEB-INF"));
            }
            System.out.println(archive.toString(show));
            this.realArchive = this.createArchive((Archive<?>)archive);
        }

        @Override
        protected File getRealArchive() {
            return this.realArchive;
        }
    }

    private class Deployment
    extends AbstractDeployment {
        final File realArchive;

        public Deployment(String archiveName, Package[] pkgs, boolean show) {
            ArchivePath metaInf = ArchivePaths.create((String)"META-INF");
            JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)archiveName);
            for (Package pkg : pkgs) {
                archive.addPackage(pkg);
            }
            File sourceMetaInf = this.getSourceMetaInfDir(archiveName);
            this.addFiles((ResourceContainer<?>)archive, sourceMetaInf, metaInf);
            System.out.println(archive.toString(show));
            this.realArchive = this.createArchive((Archive<?>)archive);
        }

        @Override
        protected File getRealArchive() {
            return this.realArchive;
        }
    }

    private abstract class AbstractDeployment {
        boolean deployed;
        String deployment;

        private AbstractDeployment() {
        }

        public synchronized DeploymentPlanBuilder addDeployment(ServerDeploymentManager manager, DeploymentPlanBuilder builder) throws DuplicateDeploymentNameException, IOException, ExecutionException, InterruptedException {
            this.deployment = this.getRealArchive().getName();
            System.out.println("Deploying " + this.deployment);
            return builder.add(this.deployment, this.getRealArchive()).deploy(this.deployment);
        }

        public synchronized DeploymentPlanBuilder removeDeployment(DeploymentPlanBuilder builder) {
            if (this.deployed) {
                System.out.println("Undeploying " + this.deployment);
                return builder.undeploy(this.deployment).remove(this.deployment);
            }
            return builder;
        }

        protected void addFiles(ResourceContainer<?> archive, File dir, ArchivePath dest) {
            for (String name : dir.list()) {
                File file = new File(dir, name);
                if (file.isDirectory()) {
                    this.addFiles(archive, file, ArchivePaths.create((ArchivePath)dest, (String)name));
                    continue;
                }
                archive.addAsResource(file, ArchivePaths.create((ArchivePath)dest, (String)name));
            }
        }

        protected void addWebFiles(WebArchive archive, File dir, ArchivePath dest) {
            for (String name : dir.list()) {
                File file = new File(dir, name);
                if (file.isDirectory()) {
                    this.addWebFiles(archive, file, ArchivePaths.create((ArchivePath)dest, (String)name));
                    continue;
                }
                archive.addAsWebResource(file, ArchivePaths.create((ArchivePath)dest, (String)name));
            }
        }

        protected File getSourceMetaInfDir(String archiveName) {
            String name = "archives/" + archiveName + "/META-INF/MANIFEST.MF";
            URL url = Thread.currentThread().getContextClassLoader().getResource(name);
            if (url == null) {
                throw new IllegalArgumentException("No resource called " + name);
            }
            try {
                File file = new File(url.toURI());
                return file.getParentFile();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Could not get file for " + url);
            }
        }

        protected File getSourceWebInfDir(String archiveName) {
            String name = "archives/" + archiveName + "/WEB-INF/";
            URL url = Thread.currentThread().getContextClassLoader().getResource(name);
            if (url == null) {
                return null;
            }
            try {
                return new File(url.toURI());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Could not get file for " + url);
            }
        }

        protected File getOutputDir() {
            File file = new File("target");
            if (!file.exists()) {
                throw new IllegalStateException("target/ does not exist");
            }
            if (!file.isDirectory()) {
                throw new IllegalStateException("target/ is not a directory");
            }
            if ((file = new File(file, "archives")).exists()) {
                if (!file.isDirectory()) {
                    throw new IllegalStateException("target/archives/ already exists and is not a directory");
                }
            } else {
                file.mkdir();
            }
            return file.getAbsoluteFile();
        }

        protected File createArchive(Archive<?> archive) {
            File realArchive = new File(this.getOutputDir(), archive.getName());
            ((ZipExporter)archive.as(ZipExporter.class)).exportTo(realArchive, true);
            return realArchive;
        }

        protected abstract File getRealArchive();
    }
}

