/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.demos.client.jms.runner;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.demos.DeploymentUtils;
import org.jboss.as.demos.fakejndi.FakeJndi;
import org.jboss.as.protocol.old.StreamUtils;
import org.jboss.dmr.ModelNode;

public class ExampleRunner {
    private static final String QUEUE_NAME = "createdTestQueue";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ModelNode op;
        QueueConnection conn = null;
        QueueSession session = null;
        ModelControllerClient client = ModelControllerClient.Factory.create((InetAddress)InetAddress.getByName("localhost"), (int)9999);
        DeploymentUtils utils = null;
        boolean actionsApplied = false;
        try {
            utils = new DeploymentUtils("fakejndi.sar", FakeJndi.class.getPackage());
            utils.deploy();
            op = new ModelNode();
            op.get("operation").set("add");
            op.get("address").add("subsystem", "messaging");
            op.get("address").add("jms-queue", QUEUE_NAME);
            op.get("entries").add(QUEUE_NAME);
            ExampleRunner.applyUpdate(op, client);
            actionsApplied = true;
            QueueConnectionFactory qcf = ExampleRunner.lookup(utils, "RemoteConnectionFactory", QueueConnectionFactory.class);
            Queue queue = ExampleRunner.lookup(utils, QUEUE_NAME, Queue.class);
            conn = qcf.createQueueConnection();
            conn.start();
            session = conn.createQueueSession(false, 1);
            QueueReceiver recv = session.createReceiver(queue);
            recv.setMessageListener(new MessageListener(){

                public void onMessage(Message message) {
                    TextMessage msg = (TextMessage)message;
                    try {
                        System.out.println("---->Received: " + msg.getText());
                    }
                    catch (JMSException e) {
                        e.printStackTrace();
                    }
                }
            });
            QueueSender sender = session.createSender(queue);
            for (int i = 0; i < 10; ++i) {
                String s = "Test" + i;
                System.out.println("----> Sending: " + s);
                TextMessage msg = session.createTextMessage(s);
                sender.send((Message)msg);
            }
            Thread.sleep(1000L);
        }
        finally {
            try {
                conn.stop();
            }
            catch (Exception ignore) {}
            try {
                session.close();
            }
            catch (Exception ignore) {}
            try {
                conn.close();
            }
            catch (Exception ignore) {}
            if (utils != null) {
                utils.undeploy();
            }
            StreamUtils.safeClose((Closeable)utils);
            if (actionsApplied) {
                op = new ModelNode();
                op.get("operation").set("remove");
                op.get("address").add("subsystem", "messaging");
                op.get("address").add("jms-queue", QUEUE_NAME);
                ExampleRunner.applyUpdate(op, client);
            }
            StreamUtils.safeClose((Closeable)client);
        }
    }

    static void applyUpdate(ModelNode update, ModelControllerClient client) throws IOException {
        ModelNode result = client.execute(update);
        if (result.hasDefined("outcome") && "success".equals(result.get("outcome").asString())) {
            if (result.hasDefined("result")) {
                System.out.println(result.get("result"));
            }
        } else {
            if (result.hasDefined("failure-description")) {
                throw new RuntimeException(result.get("failure-description").toString());
            }
            throw new RuntimeException("Operation not successful; outcome = " + result.get("outcome"));
        }
    }

    private static <T> T lookup(DeploymentUtils utils, String name, Class<T> expected) throws Exception {
        MBeanServerConnection mbeanServer = utils.getConnection();
        ObjectName objectName = new ObjectName("jboss:name=test,type=fakejndi");
        Object o = mbeanServer.invoke(objectName, "lookup", new Object[]{name}, new String[]{"java.lang.String"});
        return expected.cast(o);
    }
}

