/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.demos.domain.subsystem.runner;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.protocol.old.StreamUtils;
import org.jboss.dmr.ModelNode;

public class ExampleRunner {
    static final ModelNode SB_ADDR = new ModelNode();
    static final ModelNode WC_ADDR = new ModelNode();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ModelControllerClient client = ModelControllerClient.Factory.create((InetAddress)InetAddress.getByName("localhost"), (int)9999);
        try {
            new ExampleRunner().run(client);
        }
        finally {
            StreamUtils.safeClose((Closeable)client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void run(ModelControllerClient client) throws Exception {
        ModelNode bindingResult = this.createSocketBinding(client);
        this.checkSuccess(bindingResult);
        ModelNode connectorResult = this.createWebConnector(client);
        this.checkSuccess(connectorResult);
        try {
            BufferedInputStream in = null;
            try {
                URLConnection conn = new URL("http://localhost:8181/").openConnection();
                conn.setDoInput(true);
                conn.connect();
                in = new BufferedInputStream(conn.getInputStream());
                int i = ((InputStream)in).read();
                StringBuilder sb = new StringBuilder();
                while (i != -1) {
                    sb.append((char)i);
                    i = ((InputStream)in).read();
                }
            }
            catch (Exception ignore) {
                StreamUtils.safeClose(in);
                catch (Throwable throwable) {
                    StreamUtils.safeClose(in);
                    throw throwable;
                }
            }
            StreamUtils.safeClose((Closeable)in);
            ModelNode address = new ModelNode();
            address.add("host", "master");
            address.add("server", "server-one");
            address.add("subsystem", "web");
            address.add("connector", "new");
            ModelNode stats = new ModelNode();
            stats.get("operation").set("read-attribute");
            stats.get("address").set(address);
            stats.get("name").set("requestCount");
            ModelNode result = client.execute(stats);
            this.checkSuccess(result);
            System.out.println(result.get("result"));
        }
        finally {
            ModelNode remove1 = new ModelNode();
            remove1.get("operation").set("remove");
            remove1.get("address").set(WC_ADDR);
            ModelNode result1 = client.execute(remove1);
            this.checkSuccess(result1);
            ModelNode remove2 = new ModelNode();
            remove2.get("operation").set("remove");
            remove2.get("address").set(SB_ADDR);
            ModelNode result2 = client.execute(remove2);
            this.checkSuccess(result2);
        }
    }

    ModelNode createSocketBinding(ModelControllerClient client) throws Exception {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        operation.get("address").set(SB_ADDR);
        operation.get("name").set("new-http-binding");
        operation.get("port").set(8181);
        return client.execute(operation);
    }

    ModelNode createWebConnector(ModelControllerClient client) throws Exception {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        operation.get("address").set(WC_ADDR);
        operation.get("protocol").set("HTTP/1.1");
        operation.get("socket-binding").set("new-http-binding");
        operation.get("scheme").set("http");
        return client.execute(operation);
    }

    void checkSuccess(ModelNode result) {
        if (!"success".equals(result.get("outcome").asString())) {
            String msg = result.hasDefined("failure-description") ? result.get("failure-description").toString() : "Operation failed with no failure description provided";
            throw new IllegalStateException(msg);
        }
    }

    static {
        SB_ADDR.add("socket-binding-group", "standard-sockets");
        SB_ADDR.add("socket-binding", "new-http-binding");
        SB_ADDR.protect();
        WC_ADDR.add("profile", "default");
        WC_ADDR.add("subsystem", "web");
        WC_ADDR.add("connector", "new");
        WC_ADDR.protect();
    }
}

