/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.demos.managedbean.runner;

import java.io.Closeable;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.jboss.as.demos.DeploymentUtils;
import org.jboss.as.demos.managedbean.archive.SimpleManagedBean;
import org.jboss.as.demos.managedbean.mbean.TestMBean;
import org.jboss.as.protocol.old.StreamUtils;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public class ExampleRunner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        DeploymentUtils utils = null;
        try {
            EnterpriseArchive ear = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"managedbean-example.ear");
            JavaArchive sar = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"managedbean-mbean.sar");
            sar.addAsManifestResource("archives/managedbean-mbean.sar/META-INF/MANIFEST.MF", "MANIFEST.MF");
            sar.addAsManifestResource("archives/managedbean-mbean.sar/META-INF/jboss-service.xml", "jboss-service.xml");
            sar.addPackage(TestMBean.class.getPackage());
            ear.add((Archive)sar, "/", ZipExporter.class);
            JavaArchive jar = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"managedbean-example.jar");
            jar.addAsManifestResource("archives/managedbean-example.jar/META-INF/MANIFEST.MF", "MANIFEST.MF");
            jar.addAsManifestResource("archives/managedbean-example.jar/META-INF/services/org.jboss.msc.service.ServiceActivator", "services/org.jboss.msc.service.ServiceActivator");
            jar.addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
            jar.addPackage(SimpleManagedBean.class.getPackage());
            ear.add((Archive)jar, "/", ZipExporter.class);
            utils = new DeploymentUtils((Archive<?>)ear);
            utils.deploy();
            ObjectName objectName = new ObjectName("jboss:name=test,type=managedbean");
            MBeanServerConnection mbeanServer = utils.getConnection();
            System.out.println("Calling echo(\"Hello\")");
            Object o = mbeanServer.invoke(objectName, "echo", new Object[]{"Hello"}, new String[]{"java.lang.String"});
            System.out.println("echo returned " + o);
        }
        finally {
            utils.undeploy();
            StreamUtils.safeClose((Closeable)utils);
        }
    }
}

