/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.demos.webapp.archive;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.annotation.Resource;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.jboss.logging.Logger;

@WebServlet(name="SimpleServlet", urlPatterns={"/simple", "/other"})
public class SimpleServlet
extends HttpServlet {
    private static final long serialVersionUID = -2579304186167063651L;
    Logger log = Logger.getLogger((String)SimpleServlet.class.getName());
    private static volatile boolean initialized;
    @Resource(mappedName="java:jboss/datasources/ExampleDS")
    DataSource ds;
    @Resource(mappedName="java:/ConnectionFactory")
    QueueConnectionFactory cf;
    @Resource(mappedName="queue/test")
    Queue queue;
    QueueConnection conn;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String value = req.getParameter("value");
        this.log.info((Object)"Received request");
        PrintWriter writer = resp.getWriter();
        ((Writer)writer).write("Servlet Response\n");
        Object o = req.getAttribute("Filtered");
        ((Writer)writer).write("Filtered: " + (o != null) + "\n");
        ((Writer)writer).write("Entries in database:\n");
        Connection sqlConn = null;
        PreparedStatement stmt = null;
        try {
            this.log.info((Object)("Inserting '" + value + "' into database"));
            sqlConn = this.ds.getConnection();
            stmt = sqlConn.prepareCall("INSERT INTO WebAppTestTable (value) VALUES ('" + value + "')");
            stmt.executeUpdate();
            this.safeClose(stmt);
            this.safeClose(sqlConn);
        }
        catch (Exception e) {
            try {
                throw new ServletException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.safeClose(stmt);
                this.safeClose(sqlConn);
                throw throwable;
            }
        }
        ResultSet rs = null;
        try {
            sqlConn = this.ds.getConnection();
            stmt = sqlConn.prepareStatement("select * from WebAppTestTable");
            rs = stmt.executeQuery();
            while (rs.next()) {
                ((Writer)writer).write(rs.getInt(1));
                ((Writer)writer).write(" - ");
                ((Writer)writer).write(rs.getString(2) + "\n");
            }
            this.safeClose(rs);
            this.safeClose(stmt);
            this.safeClose(sqlConn);
        }
        catch (Exception e) {
            try {
                throw new ServletException((Throwable)e);
            }
            catch (Throwable throwable) {
                this.safeClose(rs);
                this.safeClose(stmt);
                this.safeClose(sqlConn);
                throw throwable;
            }
        }
        QueueSession session = null;
        try {
            session = this.conn.createQueueSession(false, 1);
            QueueSender sender = session.createSender(this.queue);
            TextMessage msg = session.createTextMessage(value);
            this.log.info((Object)("Sending '" + value + "' via queue"));
            sender.send((Message)msg);
        }
        catch (JMSException e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (Exception ignore) {}
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws ServletException {
        if (!initialized) {
            SimpleServlet simpleServlet = this;
            synchronized (simpleServlet) {
                if (initialized) {
                    return;
                }
                initialized = true;
                try {
                    InitialContext context = new InitialContext();
                    this.ds = (DataSource)context.lookup("java:jboss/datasources/ExampleDS");
                    this.cf = (QueueConnectionFactory)context.lookup("java:/ConnectionFactory");
                    this.queue = (Queue)context.lookup("queue/test");
                    this.conn = this.cf.createQueueConnection();
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
                Connection sqlConn = null;
                CallableStatement stmt = null;
                try {
                    sqlConn = this.ds.getConnection();
                    stmt = sqlConn.prepareCall("CREATE TABLE WebAppTestTable (id INTEGER IDENTITY, value VARCHAR(255))");
                    stmt.execute();
                    this.safeClose(stmt);
                    this.safeClose(sqlConn);
                }
                catch (Exception e) {
                    try {
                        throw new ServletException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        this.safeClose(stmt);
                        this.safeClose(sqlConn);
                        throw throwable;
                    }
                }
                this.log.info((Object)"Created table");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Connection sqlConn = null;
        CallableStatement stmt = null;
        try {
            sqlConn = this.ds.getConnection();
            this.log.info((Object)"Dropping table");
            stmt = sqlConn.prepareCall("DROP TABLE WebAppTestTable");
            stmt.execute();
            this.safeClose(stmt);
            this.safeClose(sqlConn);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.safeClose(stmt);
            this.safeClose(sqlConn);
        }
        try {
            this.conn.stop();
            this.conn.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    private void safeClose(Statement c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void safeClose(Connection c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void safeClose(ResultSet c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

