/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.demos.jms.client.runner;

import java.io.Closeable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.jboss.as.demos.DeploymentUtils;
import org.jboss.as.demos.fakejndi.FakeJndi;
import org.jboss.as.protocol.old.StreamUtils;

public class ExampleRunner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        QueueConnection conn = null;
        QueueSession session = null;
        DeploymentUtils utils = null;
        try {
            utils = new DeploymentUtils("fakejndi.sar", FakeJndi.class.getPackage());
            utils.deploy();
            QueueConnectionFactory qcf = ExampleRunner.lookup(utils, "RemoteConnectionFactory", QueueConnectionFactory.class);
            Queue queue = ExampleRunner.lookup(utils, "queue/test", Queue.class);
            System.out.println("Got qcf " + qcf);
            System.out.println("Got q " + queue);
            conn = qcf.createQueueConnection();
            conn.start();
            session = conn.createQueueSession(false, 1);
            QueueReceiver recv = session.createReceiver(queue);
            recv.setMessageListener(new MessageListener(){

                public void onMessage(Message message) {
                    TextMessage msg = (TextMessage)message;
                    try {
                        System.out.println("---->Received: " + msg.getText());
                    }
                    catch (JMSException e) {
                        e.printStackTrace();
                    }
                }
            });
            QueueSender sender = session.createSender(queue);
            for (int i = 0; i < 10; ++i) {
                String s = "Test" + i;
                System.out.println("----> Sending: " + s);
                TextMessage msg = session.createTextMessage(s);
                sender.send((Message)msg);
            }
            Thread.sleep(1000L);
        }
        finally {
            try {
                conn.stop();
            }
            catch (Exception ignore) {}
            try {
                session.close();
            }
            catch (Exception ignore) {}
            try {
                conn.close();
            }
            catch (Exception ignore) {}
            utils.undeploy();
            StreamUtils.safeClose((Closeable)utils);
        }
    }

    private static <T> T lookup(DeploymentUtils utils, String name, Class<T> expected) throws Exception {
        MBeanServerConnection mbeanServer = utils.getConnection();
        ObjectName objectName = new ObjectName("jboss:name=test,type=fakejndi");
        Object o = mbeanServer.invoke(objectName, "lookup", new Object[]{name}, new String[]{"java.lang.String"});
        return expected.cast(o);
    }
}

