/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.demos.jpa.runner;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class TestMBeanInvocationHandler
implements InvocationHandler {
    private final MBeanServerConnection mbeanServer;
    private final ObjectName name;
    private final String lookupName;

    public TestMBeanInvocationHandler(MBeanServerConnection server, String lookupName) {
        this(server, TestMBeanInvocationHandler.getDefaultObjectName(), lookupName);
    }

    public TestMBeanInvocationHandler(MBeanServerConnection server, ObjectName name, String lookupName) {
        this.mbeanServer = server;
        this.name = name;
        this.lookupName = lookupName;
    }

    private static ObjectName getDefaultObjectName() {
        try {
            return new ObjectName("jboss:name=jpa-test,type=service");
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object[] params = new Object[]{this.lookupName, method.getName(), method.getParameterTypes(), args};
        return this.mbeanServer.invoke(this.name, "invoke", params, new String[]{String.class.getName(), String.class.getName(), new Class[0].getClass().getName(), new Object[0].getClass().getName()});
    }
}

