/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.demos.rar.archive;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.jboss.as.demos.rar.archive.HelloWorldConnectionImpl;
import org.jboss.as.demos.rar.archive.HelloWorldManagedConnectionFactory;
import org.jboss.as.demos.rar.archive.HelloWorldManagedConnectionMetaData;

public class HelloWorldManagedConnection
implements ManagedConnection {
    private static Logger log = Logger.getLogger("HelloWorldManagedConnection");
    private final HelloWorldManagedConnectionFactory mcf;
    private PrintWriter logWriter;
    private final List<ConnectionEventListener> listeners;
    private Object connection;

    public HelloWorldManagedConnection(HelloWorldManagedConnectionFactory mcf) {
        this.mcf = mcf;
        this.logWriter = null;
        this.listeners = new ArrayList<ConnectionEventListener>(1);
        this.connection = null;
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        this.connection = new HelloWorldConnectionImpl(this.mcf);
        return this.connection;
    }

    public void associateConnection(Object connection) throws ResourceException {
        this.connection = connection;
    }

    public void cleanup() throws ResourceException {
    }

    public void destroy() throws ResourceException {
        this.connection = null;
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        this.listeners.add(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        this.listeners.remove(listener);
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.logWriter = out;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        throw new NotSupportedException("LocalTransaction not supported");
    }

    public XAResource getXAResource() throws ResourceException {
        throw new NotSupportedException("GetXAResource not supported");
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return new HelloWorldManagedConnectionMetaData();
    }
}

