/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.demos.web.connector.runner;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.demos.DeploymentUtils;
import org.jboss.as.demos.war.archive.SimpleServlet;
import org.jboss.as.protocol.old.StreamUtils;
import org.jboss.dmr.ModelNode;

public class ExampleRunner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        DeploymentUtils utils = null;
        try {
            utils = new DeploymentUtils();
            ModelControllerClient client = utils.getClient();
            utils.addWarDeployment("war-example.war", true, SimpleServlet.class.getPackage());
            utils.deploy();
            ExampleRunner.createTestConnector(client);
            URLConnection conn = null;
            BufferedInputStream in = null;
            try {
                URL url = new URL("http://localhost:8380/war-example/simple?input=Hello");
                System.out.println("Reading response from " + url + ":");
                conn = url.openConnection();
                conn.setDoInput(true);
                in = new BufferedInputStream(conn.getInputStream());
                int i = ((InputStream)in).read();
                while (i != -1) {
                    System.out.print((char)i);
                    i = ((InputStream)in).read();
                }
                System.out.println("");
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(in);
                throw throwable;
            }
            StreamUtils.safeClose((Closeable)in);
            ExampleRunner.removeTestConnector(client);
        }
        finally {
            utils.undeploy();
            StreamUtils.safeClose((Closeable)utils);
        }
    }

    static void createTestConnector(ModelControllerClient client) throws OperationFailedException, IOException {
        ArrayList<ModelNode> updates = new ArrayList<ModelNode>();
        ModelNode op = new ModelNode();
        op.get("operation").set("add");
        op.get("address").add("socket-binding-group", "standard-sockets");
        op.get("address").add("socket-binding", "http-test");
        op.get("port").set(8380);
        updates.add(op);
        op = new ModelNode();
        op.get("operation").set("add");
        op.get("address").add("subsystem", "web");
        op.get("address").add("connector", "testConnector");
        op.get("socket-binding").set("http-test");
        op.get("enabled").set(true);
        op.get("protocol").set("HTTP/1.1");
        op.get("scheme").set("http");
        updates.add(op);
        ExampleRunner.applyUpdates(updates, client);
    }

    static void removeTestConnector(ModelControllerClient client) throws OperationFailedException, IOException {
        ArrayList<ModelNode> updates = new ArrayList<ModelNode>();
        ModelNode op = new ModelNode();
        op.get("operation").set("remove");
        op.get("address").add("subsystem", "web");
        op.get("address").add("connector", "testConnector");
        updates.add(op);
        op = new ModelNode();
        op.get("operation").set("remove");
        op.get("address").add("socket-binding-group", "standard-sockets");
        op.get("address").add("socket-binding", "http-test");
        updates.add(op);
        ExampleRunner.applyUpdates(updates, client);
    }

    static void applyUpdates(List<ModelNode> updates, ModelControllerClient client) throws OperationFailedException, IOException {
        for (ModelNode update : updates) {
            ExampleRunner.applyUpdate(update, client);
        }
    }

    static void applyUpdate(ModelNode update, ModelControllerClient client) throws OperationFailedException, IOException {
        ModelNode result = client.execute(update);
        if (result.hasDefined("outcome") && "success".equals(result.get("outcome").asString())) {
            if (result.hasDefined("result")) {
                System.out.println(result.get("result"));
            }
        } else {
            if (result.hasDefined("failure-description")) {
                throw new RuntimeException(result.get("failure-description").toString());
            }
            throw new RuntimeException("Operation not successful; outcome = " + result.get("outcome"));
        }
    }
}

