/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.demos;

import java.io.IOException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;

public class DemoAuthentication {
    private static final DemoAuthentication INSTANCE = new DemoAuthentication();
    private final CallbackHandler CALLBACK_HANDLER = new DemoCallbackHandler();
    private final Authenticator AUTHENTICATOR = new DemoAuthenticator();
    private boolean promptShown = false;
    private String userName = null;
    private char[] password = null;

    private DemoAuthentication() {
    }

    public static CallbackHandler getCallbackHandler() {
        return DemoAuthentication.INSTANCE.CALLBACK_HANDLER;
    }

    public static Authenticator getAuthenticator() {
        return DemoAuthentication.INSTANCE.AUTHENTICATOR;
    }

    void prompt(String realm) {
        if (!this.promptShown) {
            this.promptShown = true;
            System.out.println("Authenticating against security realm: " + realm);
        }
    }

    String obtainUsername(String prompt) {
        if (this.userName == null) {
            this.userName = System.console().readLine(prompt, new Object[0]);
        }
        return this.userName;
    }

    char[] obtainPassword(String prompt) {
        if (this.password == null) {
            this.password = System.console().readPassword(prompt, new Object[0]);
        }
        return this.password;
    }

    class DemoAuthenticator
    extends Authenticator {
        DemoAuthenticator() {
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            DemoAuthentication.this.prompt(this.getRequestingPrompt());
            String userName = DemoAuthentication.this.obtainUsername("Username:");
            char[] password = DemoAuthentication.this.obtainPassword("Password:");
            return new PasswordAuthentication(userName, password);
        }
    }

    class DemoCallbackHandler
    implements CallbackHandler {
        DemoCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            if (callbacks.length == 1 && callbacks[0] instanceof NameCallback) {
                ((NameCallback)callbacks[0]).setName("anonymous demo user");
                return;
            }
            for (Callback current : callbacks) {
                if (current instanceof RealmCallback) {
                    RealmCallback rcb = (RealmCallback)current;
                    String defaultText = rcb.getDefaultText();
                    rcb.setText(defaultText);
                    DemoAuthentication.this.prompt(defaultText);
                    continue;
                }
                if (current instanceof RealmChoiceCallback) {
                    throw new UnsupportedCallbackException(current, "Realm choice not currently supported.");
                }
                if (current instanceof NameCallback) {
                    NameCallback ncb = (NameCallback)current;
                    String userName = DemoAuthentication.this.obtainUsername("Username:");
                    ncb.setName(userName);
                    continue;
                }
                if (current instanceof PasswordCallback) {
                    PasswordCallback pcb = (PasswordCallback)current;
                    char[] password = DemoAuthentication.this.obtainPassword("Password:");
                    pcb.setPassword(password);
                    continue;
                }
                throw new UnsupportedCallbackException(current);
            }
        }
    }
}

