/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.demos;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.client.helpers.domain.DuplicateDeploymentNameException;
import org.jboss.as.demos.DemoAuthentication;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public class DomainDeploymentUtils
implements Closeable {
    private final List<Deployment> deployments = new ArrayList<Deployment>();
    private final ModelControllerClient client;
    private boolean injectedClient = true;

    public DomainDeploymentUtils() throws UnknownHostException {
        this(ModelControllerClient.Factory.create((InetAddress)InetAddress.getByName("localhost"), (int)9999, (CallbackHandler)DemoAuthentication.getCallbackHandler()));
        this.injectedClient = false;
    }

    public DomainDeploymentUtils(ModelControllerClient client) throws UnknownHostException {
        this.client = client;
    }

    public DomainDeploymentUtils(String archiveName, Package pkg) throws UnknownHostException {
        this();
        this.addDeployment(archiveName, pkg);
    }

    public DomainDeploymentUtils(String archiveName, Package pkg, boolean show) throws UnknownHostException {
        this();
        this.addDeployment(archiveName, pkg, show);
    }

    public synchronized void addDeployment(String archiveName, Package pkg) {
        this.addDeployment(archiveName, pkg, false);
    }

    public synchronized void addDeployment(String archiveName, Package pkg, boolean show) {
        this.deployments.add(new Deployment(archiveName, pkg, show));
    }

    public synchronized void deploy() throws DuplicateDeploymentNameException, IOException, ExecutionException, InterruptedException {
        ModelNode op = new ModelNode();
        OperationBuilder builder = new OperationBuilder(op);
        op.get("operation").set("composite");
        op.get("address").setEmptyList();
        ModelNode steps = op.get("steps");
        for (Deployment deployment : this.deployments) {
            steps.add(deployment.addDeployment(builder));
        }
        op.get(new String[]{"operation-headers", "rollback-on-runtime-failure"}).set(DomainDeploymentUtils.getRolloutPlan());
        this.execute(builder.build());
    }

    public synchronized void undeploy() throws IOException {
        ModelNode op = new ModelNode();
        op.get("operation").set("composite");
        op.get("address").setEmptyList();
        ModelNode steps = op.get("steps");
        boolean execute = false;
        Set<String> deployed = this.getDeploymentNames();
        for (Deployment deployment : this.deployments) {
            if (!deployed.contains(deployment.archiveName)) continue;
            steps.add(deployment.removeDeployment());
            execute = true;
        }
        if (execute) {
            op.get(new String[]{"operation-headers", "rollback-on-runtime-failure"}).set(DomainDeploymentUtils.getRolloutPlan());
            this.client.execute(op);
        }
    }

    public MBeanServerConnection getServerOneConnection() throws Exception {
        return JMXConnectorFactory.connect(new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:1090/jmxrmi"), new HashMap()).getMBeanServerConnection();
    }

    public String showServerOneJndi() throws Exception {
        return (String)this.getServerOneConnection().invoke(new ObjectName("jboss:type=JNDIView"), "list", new Object[]{true}, new String[]{"boolean"});
    }

    public MBeanServerConnection getServerTwoConnection() throws Exception {
        return JMXConnectorFactory.connect(new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:1240/jmxrmi"), new HashMap()).getMBeanServerConnection();
    }

    public String showServerTwoJndi() throws Exception {
        return (String)this.getServerTwoConnection().invoke(new ObjectName("jboss:type=JNDIView"), "list", new Object[]{true}, new String[]{"boolean"});
    }

    @Override
    public void close() throws IOException {
        if (!this.injectedClient) {
            StreamUtils.safeClose((Closeable)this.client);
        }
    }

    private Set<String> getDeploymentNames() throws IOException {
        ModelNode op = new ModelNode();
        op.get("operation").set("read-children-names");
        op.get("child-type").set("deployment");
        ModelNode result = this.execute(op);
        HashSet<String> names = new HashSet<String>();
        if (!result.isDefined()) {
            return Collections.emptySet();
        }
        for (ModelNode deployment : result.asList()) {
            names.add(deployment.asString());
        }
        return names;
    }

    private ModelNode execute(ModelNode op) throws IOException {
        return this.execute(new OperationBuilder(op).build());
    }

    private ModelNode execute(Operation op) throws IOException {
        ModelNode result = this.client.execute(op);
        if (result.hasDefined("outcome") && "success".equals(result.get("outcome").asString())) {
            return result.get("result");
        }
        if (result.hasDefined("failure-description")) {
            System.out.println(op.getOperation());
            System.out.println(result);
            throw new RuntimeException(result.get("failure-description").toString());
        }
        if (result.hasDefined("domain-failure-description")) {
            System.out.println(op);
            System.out.println(result);
            throw new RuntimeException(result.get("domain-failure-description").toString());
        }
        if (result.hasDefined("host-failure-descriptions")) {
            System.out.println(result);
            throw new RuntimeException(result.get("host-failure-descriptions").toString());
        }
        System.out.println(result);
        throw new RuntimeException("Operation outcome is " + result.get("outcome").asString());
    }

    private static ModelNode getRolloutPlan() {
        ModelNode result = new ModelNode();
        ModelNode series = result.get("in-series");
        series.add().get(new String[]{"server-group", "main-server-group"});
        series.add().get(new String[]{"server-group", "other-server-group"});
        result.get("rollback-across-groups").set(true);
        return result;
    }

    private class Deployment {
        final String archiveName;
        final JavaArchive archive;
        final File realArchive;

        public Deployment(String archiveName, Package pkg, boolean show) {
            this.archiveName = archiveName;
            ArchivePath metaInf = ArchivePaths.create((String)"META-INF");
            this.archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)archiveName);
            this.archive.addPackage(pkg);
            File sourceMetaInf = this.getSourceMetaInfDir();
            this.addFiles(this.archive, sourceMetaInf, metaInf);
            System.out.println(this.archive.toString(show));
            this.realArchive = new File(this.getOutputDir(), this.archive.getName());
            ((ZipExporter)this.archive.as(ZipExporter.class)).exportTo(this.realArchive, true);
        }

        private void addFiles(JavaArchive archive, File dir, ArchivePath dest) {
            for (String name : dir.list()) {
                File file = new File(dir, name);
                if (file.isDirectory()) {
                    this.addFiles(archive, file, ArchivePaths.create((ArchivePath)dest, (String)name));
                    continue;
                }
                archive.addAsResource(file, ArchivePaths.create((ArchivePath)dest, (String)name));
            }
        }

        public synchronized ModelNode addDeployment(OperationBuilder context) throws IOException {
            System.out.println("Deploying " + this.realArchive.getName());
            Set deployments = DomainDeploymentUtils.this.getDeploymentNames();
            int index = context.getInputStreamCount();
            context.addInputStream((InputStream)new FileInputStream(this.realArchive));
            ModelNode result = new ModelNode();
            if (deployments.contains(this.archiveName)) {
                result.get("operation").set("full-replace-deployment");
                result.get("name").set(this.archiveName);
                result.get("content").get(0).get("input-stream-index").set(index);
            } else {
                result.get("operation").set("composite");
                ModelNode steps = result.get("steps");
                ModelNode add = steps.add();
                add.get("operation").set("add");
                add.get("address").add("deployment", this.archiveName);
                add.get("content").get(0).get("input-stream-index").set(index);
                ModelNode mainAdd = steps.add();
                mainAdd.get("operation").set("add");
                mainAdd.get("address").add("server-group", "main-server-group");
                mainAdd.get("address").add("deployment", this.archiveName);
                ModelNode mainDeploy = steps.add();
                mainDeploy.get("operation").set("deploy");
                mainDeploy.get("address").add("server-group", "main-server-group");
                mainDeploy.get("address").add("deployment", this.archiveName);
                ModelNode otherAdd = steps.add();
                otherAdd.get("operation").set("add");
                otherAdd.get("address").add("server-group", "other-server-group");
                otherAdd.get("address").add("deployment", this.archiveName);
                ModelNode otherDeploy = steps.add();
                otherDeploy.get("operation").set("deploy");
                otherDeploy.get("address").add("server-group", "other-server-group");
                otherDeploy.get("address").add("deployment", this.archiveName);
            }
            return result;
        }

        public synchronized ModelNode removeDeployment() {
            System.out.println("Undeploying " + this.realArchive.getName());
            ModelNode result = new ModelNode();
            result.get("operation").set("composite");
            ModelNode steps = result.get("steps");
            ModelNode mainUndeploy = steps.add();
            mainUndeploy.get("operation").set("undeploy");
            mainUndeploy.get("address").add("server-group", "main-server-group");
            mainUndeploy.get("address").add("deployment", this.archiveName);
            ModelNode mainRemove = steps.add();
            mainRemove.get("operation").set("remove");
            mainRemove.get("address").add("server-group", "main-server-group");
            mainRemove.get("address").add("deployment", this.archiveName);
            ModelNode otherUndeploy = steps.add();
            otherUndeploy.get("operation").set("undeploy");
            otherUndeploy.get("address").add("server-group", "other-server-group");
            otherUndeploy.get("address").add("deployment", this.archiveName);
            ModelNode otherRemove = steps.add();
            otherRemove.get("operation").set("remove");
            otherRemove.get("address").add("server-group", "other-server-group");
            otherRemove.get("address").add("deployment", this.archiveName);
            ModelNode domainRemove = steps.add();
            domainRemove.get("operation").set("remove");
            domainRemove.get("address").add("deployment", this.archiveName);
            return result;
        }

        private File getSourceMetaInfDir() {
            String name = "archives/" + this.archiveName + "/META-INF/MANIFEST.MF";
            URL url = Thread.currentThread().getContextClassLoader().getResource(name);
            if (url == null) {
                throw new IllegalArgumentException("No resource called " + name);
            }
            try {
                File file = new File(url.toURI());
                return file.getParentFile();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Could not get file for " + url);
            }
        }

        private File getOutputDir() {
            File file = new File("target");
            if (!file.exists()) {
                throw new IllegalStateException("target/ does not exist");
            }
            if (!file.isDirectory()) {
                throw new IllegalStateException("target/ is not a directory");
            }
            if ((file = new File(file, "archives")).exists()) {
                if (!file.isDirectory()) {
                    throw new IllegalStateException("target/archives/ already exists and is not a directory");
                }
            } else {
                file.mkdir();
            }
            return file.getAbsoluteFile();
        }
    }
}

