/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.demos.domain.configs.runner;

import java.io.Closeable;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.demos.DemoAuthentication;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.dmr.ModelNode;

public class ExampleRunner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ModelControllerClient client = ModelControllerClient.Factory.create((String)"localhost", (int)9999, (CallbackHandler)DemoAuthentication.getCallbackHandler());
        try {
            ModelNode domainOp = new ModelNode();
            domainOp.get("operation").set("read-resource");
            domainOp.get("address").setEmptyList();
            domainOp.get("recursive").set(true);
            domainOp.get("proxies").set(false);
            ModelNode result = client.execute(domainOp);
            if (!"success".equals(result.get("outcome").asString())) {
                throw new OperationFailedException(result.get("failure-description"));
            }
            System.out.println("-- domain configuration");
            ModelNode domainResult = result.get("result").clone();
            System.out.println(domainResult);
            System.out.println("--");
            ModelNode hostOp = new ModelNode();
            hostOp.get("operation").set("read-resource");
            hostOp.get("address").setEmptyList().add("host", "master");
            hostOp.get("recursive").set(true);
            hostOp.get("proxies").set(false);
            result = client.execute(hostOp);
            if (!"success".equals(result.get("outcome").asString())) {
                throw new OperationFailedException(result.get("failure-description"));
            }
            System.out.println("-- host configuration");
            ModelNode hostResult = result.get("result").clone();
            System.out.println(hostResult);
            System.out.println("--");
        }
        finally {
            StreamUtils.safeClose((Closeable)client);
        }
    }
}

