/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.demos.domain.interactive.runner;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.callback.CallbackHandler;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.client.helpers.domain.DeploymentActionsCompleteBuilder;
import org.jboss.as.controller.client.helpers.domain.DeploymentPlan;
import org.jboss.as.controller.client.helpers.domain.DeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.domain.DeploymentPlanResult;
import org.jboss.as.controller.client.helpers.domain.DomainClient;
import org.jboss.as.controller.client.helpers.domain.DomainDeploymentManager;
import org.jboss.as.controller.client.helpers.domain.InitialDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.domain.ServerGroupDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.domain.ServerIdentity;
import org.jboss.as.controller.client.helpers.domain.ServerStatus;
import org.jboss.as.controller.client.helpers.domain.UndeployDeploymentPlanBuilder;
import org.jboss.as.demos.DemoAuthentication;
import org.jboss.as.demos.DomainDeploymentUtils;
import org.jboss.as.demos.fakejndi.FakeJndi;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class ExampleRunner
implements Runnable {
    private static final PrintStream stdout = System.out;
    private static int addCount;
    private static final Map<String, MainMenu> mainMenuByCmd;
    private static final Map<String, DeploymentActionsMenu> deploymentActionMenuByCmd;
    private static final Map<String, DeploymentPlanMenu> deploymentPlanMenuByCmd;
    private final DomainClient client;
    private final Reader stdin;
    private String swingLAF;

    private ExampleRunner(InetAddress address, int port) {
        this.client = DomainClient.Factory.create((InetAddress)address, (int)port, (CallbackHandler)DemoAuthentication.getCallbackHandler());
        this.stdin = new InputStreamReader(System.in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            boolean quit = false;
            while (!(quit = this.mainMenu())) {
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        finally {
            stdout.println("Closing connection to domain controller");
            try {
                this.client.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        stdout.println("Done");
    }

    private boolean mainMenu() throws Exception {
        while (true) {
            this.writeMenu(MainMenu.ALL);
            String choice = this.readStdIn();
            MainMenu cmd = mainMenuByCmd.get(choice.toUpperCase());
            if (cmd == null) {
                stdout.println(choice + " is not a valid selection.\n");
                continue;
            }
            boolean quit = false;
            switch (cmd) {
                case DOMAIN_CFG: {
                    quit = this.dumpDomainConfig();
                    break;
                }
                case LIST_HCS: {
                    quit = this.listHostControllers();
                    break;
                }
                case HC_CFG: {
                    quit = this.dumpHostController();
                    break;
                }
                case LIST_SERVERS: {
                    quit = this.listServers();
                    break;
                }
                case SERVER_CFG: {
                    quit = this.dumpServer();
                    break;
                }
                case SERVER_STOP: {
                    quit = this.stopServer();
                    break;
                }
                case SERVER_START: {
                    quit = this.startServer();
                    break;
                }
                case SERVER_RESTART: {
                    quit = this.restartServer();
                    break;
                }
                case ADD_SERVER: {
                    quit = this.addServer();
                    break;
                }
                case REMOVE_SERVER: {
                    quit = this.removeServer();
                    break;
                }
                case DEPLOYMENTS: {
                    quit = this.runDeploymentPlan();
                    break;
                }
                case ADD_JMS_QUEUE: {
                    quit = this.addJmsQueue();
                    break;
                }
                case QUIT: {
                    quit = true;
                    break;
                }
                default: {
                    stdout.println("Command " + cmd.getCommand() + " is not supported");
                }
            }
            if (quit) break;
        }
        return true;
    }

    private void writeMenu(EnumSet<? extends MenuItem> menu) {
        stdout.println("\nEnter a selection from the following choices:");
        for (Enum enum_ : menu) {
            stdout.println(enum_.getPrompt());
        }
    }

    private Map<String, Object> writeMenuBody(List<?> choices) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int i = 0; i < choices.size(); ++i) {
            StringBuilder sb = new StringBuilder("[");
            sb.append(i + 1);
            sb.append(']');
            if (i < 9) {
                sb.append("   ");
            } else {
                sb.append("  ");
            }
            Object choice = choices.get(i);
            sb.append(choice);
            result.put(String.valueOf(i + 1), choice);
            stdout.println(sb.toString());
        }
        return result;
    }

    private boolean continuePrompt() throws IOException {
        stdout.println("\nHit Enter to continue or Q to quit:");
        String choice = this.readStdIn();
        return "Q".equals(choice.toUpperCase());
    }

    private boolean dumpDomainConfig() throws Exception {
        ModelNode op = new ModelNode();
        op.get("operation").set("read-config-as-xml");
        stdout.println(this.executeForResult(new OperationBuilder(op).build()).asString());
        return this.continuePrompt();
    }

    private boolean listHostControllers() throws Exception {
        stdout.println("\nReading the list of active host controller s:\n");
        List hostControllers = this.client.getHostControllerNames();
        for (String hc : hostControllers) {
            stdout.println(hc);
        }
        return this.continuePrompt();
    }

    private boolean dumpHostController() throws Exception {
        List hostControllers = this.client.getHostControllerNames();
        if (hostControllers.size() == 0) {
            stdout.println("No host controllers available");
        } else if (hostControllers.size() == 1) {
            this.writeHostController((String)hostControllers.get(0));
        } else {
            stdout.println("Choose a Host Controller:");
            Map<String, Object> choices = this.writeMenuBody(hostControllers);
            stdout.println("[C]   Cancel");
            String choice = this.readStdIn();
            if (!"C".equals(choice.toUpperCase())) {
                Object hc = choices.get(choice);
                if (hc != null) {
                    this.writeHostController(hc.toString());
                } else {
                    stdout.println(choice + " is not a valid selection");
                    return this.dumpHostController();
                }
            }
        }
        return this.continuePrompt();
    }

    private void writeHostController(String hc) throws Exception {
        ModelNode op = new ModelNode();
        op.get("operation").set("read-config-as-xml");
        op.get("address").add("host", hc);
        stdout.println(this.executeForResult(new OperationBuilder(op).build()).asString());
    }

    private boolean listServers() throws Exception {
        stdout.println("\nReading the list of configured servers:");
        for (Map.Entry server : this.client.getServerStatuses().entrySet()) {
            ServerIdentity id = (ServerIdentity)server.getKey();
            stdout.println("\nServer:\n");
            stdout.println("server name:         " + id.getServerName());
            stdout.println("host controller name: " + id.getHostName());
            stdout.println("server group name:   " + id.getServerGroupName());
            stdout.println("status:              " + server.getValue());
        }
        return this.continuePrompt();
    }

    private boolean dumpServer() throws Exception {
        ServerIdentity server = this.chooseServer(ServerStatus.STARTED, new ServerStatus[0]);
        if (server != null) {
            stdout.println("\nReading runtime configuration for " + server.getServerName() + "\n");
            ModelNode op = new ModelNode();
            op.get("operation").set("read-config-as-xml");
            ModelNode address = op.get("address");
            address.add("host", server.getHostName());
            address.add("server", server.getServerName());
            stdout.println(this.executeForResult(new OperationBuilder(op).build()).asString());
        }
        return this.continuePrompt();
    }

    private boolean stopServer() throws Exception {
        ServerIdentity server = this.chooseServer(ServerStatus.STARTED, new ServerStatus[0]);
        if (server != null) {
            System.out.println("\nStopping server " + server.getServerName() + "\n");
            ServerStatus status = this.client.stopServer(server.getHostName(), server.getServerName(), -1L, TimeUnit.SECONDS);
            System.out.println("Stop executed. Server status is " + status);
        }
        return this.continuePrompt();
    }

    private boolean startServer() throws Exception {
        ServerIdentity server = this.chooseServer(ServerStatus.STOPPED, ServerStatus.DISABLED);
        if (server != null) {
            System.out.println("\nStarting server " + server.getServerName() + "\n");
            ServerStatus status = this.client.startServer(server.getHostName(), server.getServerName());
            System.out.println("Start executed. Server status is " + status);
        }
        return this.continuePrompt();
    }

    private boolean restartServer() throws Exception {
        ServerIdentity server = this.chooseServer(ServerStatus.STARTED, new ServerStatus[0]);
        if (server != null) {
            System.out.println("\nRestarting server " + server.getServerName() + "\n");
            ServerStatus status = this.client.restartServer(server.getHostName(), server.getServerName(), -1L, TimeUnit.SECONDS);
            System.out.println("Restart executed. Server status is " + status);
        }
        return this.continuePrompt();
    }

    private boolean addServer() throws Exception {
        ++addCount;
        stdout.println("Enter the name of the new server, or [C] to cancel:");
        String serverName = this.readStdIn();
        if ("C".equals(serverName.toUpperCase())) {
            return this.continuePrompt();
        }
        String hostController = null;
        List hostControllers = this.client.getHostControllerNames();
        if (hostControllers.size() == 1) {
            hostController = (String)hostControllers.get(0);
        } else {
            do {
                stdout.println("Choose a Host Controller for the new Server:");
                Map<String, Object> choices = this.writeMenuBody(hostControllers);
                stdout.println("[C]   Cancel");
                String choice = this.readStdIn();
                if ("C".equals(choice.toUpperCase())) {
                    return this.continuePrompt();
                }
                Object obj = choices.get(choice);
                if (obj == null) {
                    stdout.println(choice + " is not a valid selection");
                    continue;
                }
                hostController = obj.toString();
            } while (hostController == null);
        }
        String serverGroup = null;
        List<String> serverGroups = this.getServerGroupNames();
        do {
            stdout.println("Choose a Server Group for the new Server:");
            Map<String, Object> choices = this.writeMenuBody(serverGroups);
            stdout.println("[C]   Cancel");
            String choice = this.readStdIn();
            if ("C".equals(choice.toUpperCase())) {
                return this.continuePrompt();
            }
            Object obj = choices.get(choice);
            if (obj == null) {
                stdout.println(choice + " is not a valid selection");
                continue;
            }
            serverGroup = obj.toString();
        } while (serverGroup == null);
        stdout.println("\nCreating new server: '" + serverName + "' on host controller '" + hostController + "' in server group: '" + serverGroup);
        ModelNode address = new ModelNode();
        address.add("host", hostController);
        address.add("server-config", serverName);
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        operation.get("address").set(address);
        operation.get("group").set(serverGroup);
        operation.get("socket-binding-group").set("standard-sockets");
        operation.get("socket-binding-port-offset").set(addCount * 500);
        ModelNode result = this.executeForResult(operation);
        return this.continuePrompt();
    }

    private List<String> getServerGroupNames() {
        TreeSet sorted = new TreeSet();
        ModelNode domainModel = this.getDomainModel();
        if (domainModel.hasDefined("server-group")) {
            sorted.addAll(domainModel.get("server-group").keys());
        }
        return new ArrayList<String>(sorted);
    }

    private ModelNode getDomainModel() {
        ModelNode op = new ModelNode();
        op.get("operation").set("read-resource");
        op.get("recursive").set(true);
        op.get("proxies").set(false);
        return this.executeForResult(new OperationBuilder(op).build());
    }

    private boolean removeServer() throws Exception {
        ServerIdentity server = this.chooseServer(ServerStatus.STOPPED, ServerStatus.DISABLED);
        if (server != null) {
            stdout.println("Removing server " + server.getServerName());
            ModelNode op = new ModelNode();
            op.get("operation").set("remove");
            ModelNode address = op.get("address");
            address.add("host", server.getHostName());
            address.add("server-config", server.getServerName());
            boolean success = true;
            try {
                this.executeForResult(new OperationBuilder(op).build());
            }
            catch (Exception e) {
                success = false;
            }
            stdout.println("Remove success: " + success);
        }
        return this.continuePrompt();
    }

    private ServerIdentity chooseServer(ServerStatus valid, ServerStatus ... alsoValid) throws IOException {
        ServerIdentity result = null;
        SortedMap<String, ServerIdentity> servers = this.getValidServers(valid, alsoValid);
        if (servers.size() == 0) {
            StringBuilder sb = new StringBuilder("No servers are in a valid state to perform this operation. Servers must have status ");
            sb.append(valid);
            if (alsoValid != null) {
                for (ServerStatus status : alsoValid) {
                    sb.append(", ");
                    sb.append(status);
                }
            }
            stdout.println(sb.toString());
        } else {
            stdout.println("Choose a Server:");
            Map<String, Object> choices = this.writeMenuBody(new ArrayList<String>(servers.keySet()));
            stdout.println("[C]   Cancel");
            String choice = this.readStdIn();
            if (!"C".equals(choice.toUpperCase())) {
                Object hc = choices.get(choice);
                if (hc != null) {
                    result = (ServerIdentity)servers.get(hc.toString());
                } else {
                    stdout.println(choice + " is not a valid selection");
                    result = this.chooseServer(valid, alsoValid);
                }
            }
        }
        return result;
    }

    private SortedMap<String, ServerIdentity> getValidServers(ServerStatus valid, ServerStatus ... alsoValid) {
        EnumSet<ServerStatus[]> validSet = EnumSet.of(valid, alsoValid);
        TreeMap<String, ServerIdentity> result = new TreeMap<String, ServerIdentity>();
        for (Map.Entry entry : this.client.getServerStatuses().entrySet()) {
            if (!validSet.contains(entry.getValue())) continue;
            result.put(((ServerIdentity)entry.getKey()).getServerName(), (ServerIdentity)entry.getKey());
        }
        return result;
    }

    private boolean runDeploymentPlan() throws Exception {
        DomainDeploymentManager deploymentManager = this.client.getDeploymentManager();
        InitialDeploymentPlanBuilder builder = deploymentManager.newDeploymentPlan();
        ModelNode model = this.getDomainModel();
        DeploymentActionsCompleteBuilder completionBuilder = null;
        String serverGroup = null;
        HashSet<String> includedGroups = new HashSet<String>();
        do {
            if ((completionBuilder = this.deploymentSetBuilder((DeploymentPlanBuilder)builder, model)) == null) continue;
            serverGroup = this.chooseServerGroup(model, includedGroups);
        } while (serverGroup == null && completionBuilder != null);
        if (completionBuilder != null) {
            includedGroups.add(serverGroup);
            ServerGroupDeploymentPlanBuilder groupPlanBuilder = completionBuilder.toServerGroup(serverGroup);
            DeploymentPlan plan = this.completeDeploymentPlan(groupPlanBuilder, model, includedGroups);
            if (plan != null) {
                Future future = deploymentManager.execute(plan);
                this.writeDeploymentPlanResult((DeploymentPlanResult)future.get());
            }
        }
        return this.continuePrompt();
    }

    private String chooseServerGroup(ModelNode model, Set<String> existingGroups) throws IOException {
        List<String> groups = this.getServerGroupNames();
        groups.removeAll(existingGroups);
        System.out.println(groups + " // " + existingGroups);
        String serverGroup = null;
        do {
            stdout.println("Choose a Server Group:");
            Map<String, Object> choices = this.writeMenuBody(groups);
            stdout.println("[C]   Cancel");
            String choice = this.readStdIn();
            if ("C".equals(choice.toUpperCase())) break;
            Object obj = choices.get(choice);
            if (obj == null) {
                stdout.println(choice + " is not a valid selection");
                continue;
            }
            serverGroup = obj.toString();
        } while (serverGroup == null);
        return serverGroup;
    }

    private DeploymentActionsCompleteBuilder deploymentSetBuilder(DeploymentPlanBuilder builder, ModelNode model) throws Exception {
        HashSet<String> addedContent = new HashSet<String>();
        HashSet<String> deployedContent = new HashSet<String>();
        HashSet<String> undeployedContent = new HashSet<String>();
        HashSet<String> removedContent = new HashSet<String>();
        block9: while (true) {
            boolean hasActions;
            this.writeMenu((hasActions = builder instanceof DeploymentActionsCompleteBuilder) ? DeploymentActionsMenu.ALL : DeploymentActionsMenu.INITIAL);
            String choice = this.readStdIn();
            DeploymentActionsMenu cmd = deploymentActionMenuByCmd.get(choice.toUpperCase());
            if (cmd == null) {
                stdout.println(choice + " is not a valid selection.\n");
                continue;
            }
            switch (cmd) {
                case ADD: 
                case ADD_AND_DEPLOY: 
                case ADD_AND_REPLACE: {
                    builder = this.addContent(builder, addedContent, deployedContent, undeployedContent, removedContent, model, cmd);
                    continue block9;
                }
                case DEPLOY: {
                    builder = this.deployContent(builder, addedContent, deployedContent, undeployedContent, removedContent, model);
                    continue block9;
                }
                case REPLACE: {
                    builder = this.replaceContent(builder, addedContent, deployedContent, undeployedContent, removedContent, model);
                    continue block9;
                }
                case UNDEPLOY: 
                case UNDEPLOY_AND_REMOVE: {
                    builder = this.undeployContent(builder, addedContent, deployedContent, undeployedContent, removedContent, model, cmd);
                    continue block9;
                }
                case REMOVE: {
                    builder = this.removeContent(builder, addedContent, deployedContent, undeployedContent, removedContent, model);
                    continue block9;
                }
                case APPLY: {
                    if (hasActions) {
                        return (DeploymentActionsCompleteBuilder)builder;
                    }
                    stdout.println(choice + " is not a valid selection.\n");
                    continue block9;
                }
                case CANCEL: {
                    return null;
                }
            }
            stdout.println("Command " + cmd.getCommand() + " is not supported");
        }
    }

    private DeploymentPlanBuilder addContent(DeploymentPlanBuilder builder, Set<String> addedContent, Set<String> deployedContent, Set<String> undeployedContent, Set<String> removedContent, ModelNode model, DeploymentActionsMenu cmd) throws Exception {
        File content = this.chooseFile();
        if (content == null) {
            return builder;
        }
        String contentName = content.getName();
        if (cmd != DeploymentActionsMenu.ADD_AND_REPLACE && (addedContent.contains(contentName) || model.get("deployment").hasDefined(contentName))) {
            stdout.println("ERROR: A deployment with name " + contentName + " already exists in the domain.");
            stdout.println("To replace it with content of the same name, choose:");
            stdout.println(DeploymentActionsMenu.ADD_AND_REPLACE.getPrompt());
            return this.deploymentPlanCancelPrompt() ? null : builder;
        }
        switch (cmd) {
            case ADD: {
                builder = builder.add(contentName, content);
                break;
            }
            case ADD_AND_DEPLOY: {
                builder = builder.add(contentName, content).andDeploy();
                deployedContent.add(contentName);
                break;
            }
            case ADD_AND_REPLACE: {
                builder = builder.replace(contentName, content);
                ModelNode existing = model.get(new String[]{"deployment", contentName});
                if (!deployedContent.contains(contentName) && (!existing.isDefined() || !existing.get("enabled").asBoolean(true) || undeployedContent.contains(contentName))) break;
                deployedContent.add(contentName);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid command " + cmd);
            }
        }
        addedContent.add(contentName);
        undeployedContent.remove(contentName);
        removedContent.remove(contentName);
        return builder;
    }

    private DeploymentPlanBuilder deployContent(DeploymentPlanBuilder builder, Set<String> addedContent, Set<String> deployedContent, Set<String> undeployedContent, Set<String> removedContent, ModelNode domainModel) throws IOException {
        String deployment = this.chooseUndeployedContent("Choose the content to deploy:", addedContent, deployedContent, undeployedContent, removedContent, domainModel);
        if (deployment != null) {
            deployedContent.add(deployment);
            undeployedContent.remove(deployment);
            return builder.deploy(deployment);
        }
        return builder;
    }

    private String chooseUndeployedContent(String message, Set<String> addedContent, Set<String> deployedContent, Set<String> undeployedContent, Set<String> removedContent, ModelNode domainModel) throws IOException {
        TreeSet<String> deployments = new TreeSet<String>(addedContent);
        if (domainModel.hasDefined("server-group")) {
            for (Property serverGroupProp : domainModel.get("server-group").asPropertyList()) {
                ModelNode serverGroup = serverGroupProp.getValue();
                if (!serverGroup.hasDefined("deployment")) continue;
                for (Property deploymentProp : serverGroup.get("deployment").asPropertyList()) {
                    ModelNode deployment = deploymentProp.getValue();
                    if (!deployment.hasDefined("enabled") || deployment.get("enabled").asBoolean()) continue;
                    deployments.add(deploymentProp.getName());
                }
            }
        }
        deployments.removeAll(deployedContent);
        deployments.addAll(undeployedContent);
        deployments.removeAll(removedContent);
        String deployment = this.chooseDeployment(deployments, message);
        return deployment;
    }

    private String chooseDeployment(TreeSet<String> deployments, String message) throws IOException {
        String deployment = null;
        do {
            stdout.println("Choose a deployment:");
            Map<String, Object> choices = this.writeMenuBody(new ArrayList<String>(deployments));
            stdout.println("[C]   Cancel");
            String choice = this.readStdIn();
            if ("C".equals(choice.toUpperCase())) break;
            Object dep = choices.get(choice);
            if (dep != null) {
                deployment = dep.toString();
                continue;
            }
            stdout.println(choice + " is not a valid selection");
        } while (deployment == null);
        return deployment;
    }

    private DeploymentPlanBuilder replaceContent(DeploymentPlanBuilder builder, Set<String> addedContent, Set<String> deployedContent, Set<String> undeployedContent, Set<String> removedContent, ModelNode domainModel) throws IOException {
        String toReplace;
        String toDeploy = this.chooseUndeployedContent("Choose the replacement deployment:", removedContent, removedContent, removedContent, removedContent, domainModel);
        if (toDeploy != null && (toReplace = this.chooseDeployedContent("Choose the deployment to be replaced:", deployedContent, undeployedContent, domainModel)) != null) {
            return builder.replace(toDeploy, toReplace);
        }
        return builder;
    }

    private String chooseDeployedContent(String message, Set<String> deployedContent, Set<String> undeployedContent, ModelNode domainModel) throws IOException {
        TreeSet<String> deployments = new TreeSet<String>(deployedContent);
        if (domainModel.hasDefined("server-group")) {
            for (Property serverGroupProp : domainModel.get("server-group").asPropertyList()) {
                ModelNode serverGroup = serverGroupProp.getValue();
                if (!serverGroup.hasDefined("deployment")) continue;
                for (Property deploymentProp : serverGroup.get("deployment").asPropertyList()) {
                    ModelNode deployment = deploymentProp.getValue();
                    if (deployment.hasDefined("enabled") && !deployment.get("enabled").asBoolean()) continue;
                    deployments.add(deploymentProp.getName());
                }
            }
        }
        deployments.removeAll(undeployedContent);
        String deployment = this.chooseDeployment(deployments, message);
        return deployment;
    }

    private DeploymentPlanBuilder undeployContent(DeploymentPlanBuilder builder, Set<String> addedContent, Set<String> deployedContent, Set<String> undeployedContent, Set<String> removedContent, ModelNode domainModel, DeploymentActionsMenu cmd) throws IOException {
        String toUndeploy = this.chooseDeployedContent("Choose the deployment to undeploy:", deployedContent, undeployedContent, domainModel);
        if (toUndeploy != null) {
            UndeployDeploymentPlanBuilder udpb = builder.undeploy(toUndeploy);
            builder = udpb;
            if (cmd == DeploymentActionsMenu.UNDEPLOY_AND_REMOVE) {
                builder = udpb.andRemoveUndeployed();
                removedContent.add(toUndeploy);
                addedContent.remove(toUndeploy);
            }
            undeployedContent.add(toUndeploy);
            deployedContent.remove(toUndeploy);
        }
        return builder;
    }

    private DeploymentPlanBuilder removeContent(DeploymentPlanBuilder builder, Set<String> addedContent, Set<String> deployedContent, Set<String> undeployedContent, Set<String> removedContent, ModelNode domainModel) throws IOException {
        String deployment = this.chooseUndeployedContent("Choose the content to remove:", addedContent, deployedContent, undeployedContent, removedContent, domainModel);
        if (deployment != null) {
            removedContent.add(deployment);
            addedContent.remove(deployment);
            return builder.remove(deployment);
        }
        return builder;
    }

    private boolean deploymentPlanCancelPrompt() throws IOException {
        stdout.println("\nHit Enter to continue or C to cancel this deployment plan:");
        String choice = this.readStdIn();
        return "C".equals(choice.toUpperCase());
    }

    private DeploymentPlan completeDeploymentPlan(ServerGroupDeploymentPlanBuilder groupPlanBuilder, ModelNode model, Set<String> includedGroups) throws IOException {
        block7: while (true) {
            this.writeMenu(DeploymentPlanMenu.ALL);
            String choice = this.readStdIn();
            DeploymentPlanMenu cmd = deploymentPlanMenuByCmd.get(choice.toUpperCase());
            if (cmd == null) {
                stdout.println(choice + " is not a valid selection.\n");
                continue;
            }
            switch (cmd) {
                case ROLLING_TO_SERVERS: {
                    groupPlanBuilder = groupPlanBuilder.rollingToServers();
                    continue block7;
                }
                case TO_SERVER_GROUP: {
                    String serverGroup = this.chooseServerGroup(model, includedGroups);
                    if (serverGroup == null) continue block7;
                    groupPlanBuilder = groupPlanBuilder.toServerGroup(serverGroup);
                    continue block7;
                }
                case ROLL_TO_SERVER_GROUP: {
                    String serverGroup = this.chooseServerGroup(model, includedGroups);
                    if (serverGroup == null) continue block7;
                    groupPlanBuilder = groupPlanBuilder.rollingToServerGroup(serverGroup);
                    continue block7;
                }
                case EXECUTE: {
                    return groupPlanBuilder.build();
                }
                case CANCEL: {
                    return null;
                }
            }
            stdout.println("Command " + cmd.getCommand() + " is not supported");
        }
    }

    private void writeDeploymentPlanResult(DeploymentPlanResult deploymentPlanResult) {
        stdout.println("executed");
    }

    private File chooseFile() throws IOException {
        this.initializeSwing();
        JFileChooser chooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Archives", "jar", "war", "sar");
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(null);
        if (returnVal == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initializeSwing() {
        if (this.swingLAF != null) {
            return;
        }
        if (System.getProperty("swing.defaultlaf") != null) {
            return;
        }
        String sep = File.separator;
        String javaHome = System.getProperty("java.home");
        if (javaHome != null) {
            String clazz;
            Properties props = new Properties();
            File file = new File(javaHome + sep + "lib" + sep + "swing.properties");
            if (file.exists()) {
                FileInputStream ins = null;
                try {
                    ins = new FileInputStream(file);
                    props.load(ins);
                }
                catch (IOException ignored) {
                }
                finally {
                    if (ins != null) {
                        try {
                            ins.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            if ((clazz = props.getProperty("swing.defaultlaf")) != null) {
                try {
                    this.getClass().getClassLoader().loadClass(clazz);
                    this.swingLAF = clazz;
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
        }
        if (this.swingLAF == null) {
            this.swingLAF = MetalLookAndFeel.class.getName();
            System.setProperty("swing.defaultlaf", this.swingLAF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addJmsQueue() throws Exception {
        stdout.println("Enter the name for the new queue or [C] to cancel:");
        String queueName = this.readStdIn();
        if ("C".equals(queueName.toUpperCase())) {
            return this.continuePrompt();
        }
        ModelNode address = new ModelNode();
        address.add("profile", "default");
        address.add("subsystem", "messaging");
        address.add("hornetq-server", "default");
        address.add("jms-queue", queueName);
        ModelNode queueAddOperation = new ModelNode();
        queueAddOperation.get("operation").set("add");
        queueAddOperation.get("address").set(address);
        queueAddOperation.get("entries").add(queueName);
        DomainDeploymentUtils utils = null;
        boolean deployed = false;
        try {
            utils = new DomainDeploymentUtils((ModelControllerClient)this.client);
            utils.addDeployment("fakejndi.sar", FakeJndi.class.getPackage());
            utils.deploy();
            deployed = true;
            try {
                ModelNode result = this.executeForResult(queueAddOperation);
                Collection<String> serverGroups = this.resultToServerGroupIdentitySet(result);
                for (String serverGroup : serverGroups) {
                    System.out.println(serverGroup);
                }
            }
            catch (Exception e) {
                System.out.println("failed to execute operation " + queueAddOperation);
                e.printStackTrace();
            }
            boolean bl = this.continuePrompt();
            return bl;
        }
        finally {
            if (deployed && utils != null) {
                utils.undeploy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exerciseQueueOnServer(String queueName, ServerIdentity server) throws Exception {
        stdout.println("Exercising queue " + queueName + " on server " + server.getServerName());
        QueueConnection conn = null;
        QueueSession session = null;
        try {
            QueueConnectionFactory qcf = this.lookup(server, "RemoteConnectionFactory", QueueConnectionFactory.class);
            Queue queue = this.lookup(server, queueName, Queue.class);
            conn = qcf.createQueueConnection();
            conn.start();
            session = conn.createQueueSession(false, 1);
            QueueReceiver recv = session.createReceiver(queue);
            recv.setMessageListener(new MessageListener(){

                public void onMessage(Message message) {
                    TextMessage msg = (TextMessage)message;
                    try {
                        stdout.println("---->Received: " + msg.getText());
                    }
                    catch (JMSException e) {
                        e.printStackTrace();
                    }
                }
            });
            QueueSender sender = session.createSender(queue);
            for (int i = 0; i < 10; ++i) {
                String s = "Test" + i;
                stdout.println("----> Sending: " + s);
                TextMessage msg = session.createTextMessage(s);
                sender.send((Message)msg);
            }
        }
        finally {
            try {
                conn.stop();
            }
            catch (Exception ignore) {}
            try {
                session.close();
            }
            catch (Exception ignore) {}
            try {
                conn.close();
            }
            catch (Exception ignore) {}
        }
    }

    private String readStdIn() throws IOException {
        StringBuilder sb = new StringBuilder();
        do {
            char c;
            if ((c = (char)this.stdin.read()) == '\uffffffff') {
                return "Q";
            }
            sb.append(c);
        } while (this.stdin.ready());
        return sb.toString().trim();
    }

    private <T> T lookup(ServerIdentity server, String name, Class<T> expected) throws Exception {
        MBeanServerConnection mbeanServer = this.getMBeanServerConnection(server);
        ObjectName objectName = new ObjectName("jboss:name=test,type=fakejndi");
        Object o = mbeanServer.invoke(objectName, "lookup", new Object[]{name}, new String[]{"java.lang.String"});
        return expected.cast(o);
    }

    private MBeanServerConnection getMBeanServerConnection(ServerIdentity server) throws Exception {
        ModelNode address = new ModelNode();
        address.add("host", server.getHostName());
        address.add("server", server.getServerName());
        address.add("socket-binding-group", "standard-sockets");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("read-resource");
        operation.get("address").set(address);
        operation.get("recursive").set(true);
        ModelNode result = this.executeForResult(operation);
        int portOffset = result.get("port-offset").asInt(0);
        int port = result.get(new String[]{"socket-binding", "jmx-connector-registry", "port"}).asInt() + portOffset;
        String addr = "localhost";
        String url = String.format("service:jmx:rmi:///jndi/rmi://%s:%d/jmxrmi", "localhost", port);
        return JMXConnectorFactory.connect(new JMXServiceURL(url), new HashMap()).getMBeanServerConnection();
    }

    public static void main(String[] args) throws Exception {
        ExampleRunner runner = new ExampleRunner(InetAddress.getByName("localhost"), 9999);
        runner.run();
    }

    private ModelNode executeForResult(ModelNode op) throws Exception {
        return this.executeForResult(new OperationBuilder(op).build());
    }

    private ModelNode executeForResult(Operation op) {
        try {
            ModelNode result = this.client.execute(op);
            if (result.hasDefined("outcome") && "success".equals(result.get("outcome").asString())) {
                return result.get("result");
            }
            if (result.hasDefined("failure-description")) {
                throw new RuntimeException(result.get("failure-description").toString());
            }
            if (result.hasDefined("domain-failure-description")) {
                throw new RuntimeException(result.get("domain-failure-description").toString());
            }
            if (result.hasDefined("host-failure-descriptions")) {
                throw new RuntimeException(result.get("host-failure-descriptions").toString());
            }
            throw new RuntimeException("Operation outcome is " + result);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Collection<String> resultToServerGroupIdentitySet(ModelNode result) {
        ArrayList<String> servers = new ArrayList<String>();
        for (Property serverGroup : result.get("server-groups").asPropertyList()) {
            servers.add(serverGroup.getName());
        }
        return servers;
    }

    static {
        mainMenuByCmd = new HashMap<String, MainMenu>();
        deploymentActionMenuByCmd = new HashMap<String, DeploymentActionsMenu>();
        deploymentPlanMenuByCmd = new HashMap<String, DeploymentPlanMenu>();
        for (Enum cmd : MainMenu.ALL) {
            mainMenuByCmd.put(((MainMenu)cmd).getCommand(), (MainMenu)cmd);
        }
        for (Enum cmd : DeploymentActionsMenu.ALL) {
            deploymentActionMenuByCmd.put(((DeploymentActionsMenu)cmd).getCommand(), (DeploymentActionsMenu)cmd);
        }
        for (Enum cmd : DeploymentPlanMenu.ALL) {
            deploymentPlanMenuByCmd.put(((DeploymentPlanMenu)cmd).getCommand(), (DeploymentPlanMenu)cmd);
        }
    }

    private static enum DeploymentPlanMenu implements MenuItem
    {
        ROLLING_TO_SERVERS("1", "Roll out changes to servers in the group one at a time"),
        TO_SERVER_GROUP("2", "Concurrently apply changes to another server group"),
        ROLL_TO_SERVER_GROUP("3", "Roll out changes to another server group once the current group completes"),
        EXECUTE("4", "Execute the deployment plan"),
        CANCEL("C", "Cancel the entire deployment plan");

        private static final EnumSet<DeploymentPlanMenu> ALL;
        private final String cmd;
        private final String prompt;

        private DeploymentPlanMenu(String cmd, String message) {
            this.cmd = cmd;
            String spaces = cmd.length() == 1 ? "   " : "  ";
            this.prompt = "[" + cmd + "]" + spaces + message;
        }

        @Override
        public String getPrompt() {
            return this.prompt;
        }

        public String getCommand() {
            return this.cmd;
        }

        static {
            ALL = EnumSet.allOf(DeploymentPlanMenu.class);
        }
    }

    private static enum DeploymentActionsMenu implements MenuItem
    {
        ADD("1", "Add new deployment content to the domain"),
        ADD_AND_DEPLOY("2", "Add new deployment content to the domain and deploy it"),
        ADD_AND_REPLACE("3", "Add new content to the domain and use it to replace existing content of the same name"),
        DEPLOY("4", "Deploy previously added content"),
        REPLACE("5", "Deploy previously added content as a replacement for another deployment"),
        UNDEPLOY("6", "Undeploy content"),
        UNDEPLOY_AND_REMOVE("7", "Undeploy content and remove from the domain"),
        REMOVE("8", "Remove previously undeployed content from the domain"),
        APPLY("9", "Apply deployment actions to a server group"),
        CANCEL("C", "Cancel");

        private static final EnumSet<DeploymentActionsMenu> ALL;
        private static final EnumSet<DeploymentActionsMenu> INITIAL;
        private final String cmd;
        private final String prompt;

        private DeploymentActionsMenu(String cmd, String message) {
            this.cmd = cmd;
            String spaces = cmd.length() == 1 ? "   " : "  ";
            this.prompt = "[" + cmd + "]" + spaces + message;
        }

        @Override
        public String getPrompt() {
            return this.prompt;
        }

        public String getCommand() {
            return this.cmd;
        }

        static {
            ALL = EnumSet.allOf(DeploymentActionsMenu.class);
            INITIAL = EnumSet.complementOf(EnumSet.of(APPLY));
        }
    }

    private static enum MainMenu implements MenuItem
    {
        DOMAIN_CFG("1", "Dump Domain Configuration"),
        LIST_HCS("2", "List Host Controllers"),
        HC_CFG("3", "Dump Host Controller Configuration"),
        LIST_SERVERS("4", "List Servers"),
        SERVER_CFG("5", "Dump a Server's Current Runtime Configuration"),
        SERVER_STOP("6", "Stop a Server"),
        SERVER_START("7", "Start a Server"),
        SERVER_RESTART("8", "Restart a Server"),
        ADD_SERVER("9", "Add a Server"),
        REMOVE_SERVER("10", "Remove a Server"),
        ADD_JMS_QUEUE("11", "Add a JMS Queue"),
        DEPLOYMENTS("12", "Create and Execute a Deployment Plan"),
        QUIT("Q", "Quit");

        private static final EnumSet<MainMenu> ALL;
        private final String cmd;
        private final String prompt;

        private MainMenu(String cmd, String message) {
            this.cmd = cmd;
            String spaces = cmd.length() == 1 ? "   " : "  ";
            this.prompt = "[" + cmd + "]" + spaces + message;
        }

        @Override
        public String getPrompt() {
            return this.prompt;
        }

        public String getCommand() {
            return this.cmd;
        }

        static {
            ALL = EnumSet.allOf(MainMenu.class);
        }
    }

    private static interface MenuItem {
        public String getPrompt();
    }
}

