/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.demos.sar.archive;

import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.demos.sar.archive.ConfigServiceMBean;
import org.jboss.as.demos.sar.archive.ProcessMonitorServiceMBean;
import org.jboss.logging.Logger;

public class ProcessMonitorService
implements ProcessMonitorServiceMBean {
    Logger log = Logger.getLogger(ProcessMonitorService.class);
    private ConfigServiceMBean config;
    AtomicBoolean stop = new AtomicBoolean();

    public void setConfig(ConfigServiceMBean config) {
        this.config = config;
    }

    @Override
    public void start() {
        this.log.info((Object)("Starting " + this.config.getExampleName()));
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                long starttime = System.currentTimeMillis();
                while (!ProcessMonitorService.this.stop.get()) {
                    double totalmemory = ProcessMonitorService.bytesToMb(Runtime.getRuntime().totalMemory());
                    double usedmemory = totalmemory - ProcessMonitorService.bytesToMb(Runtime.getRuntime().freeMemory());
                    long seconds = (System.currentTimeMillis() - starttime) / 1000L;
                    ProcessMonitorService.this.log.info((Object)(ProcessMonitorService.this.config.getExampleName() + "-Montitor: System using " + usedmemory + " Mb of " + totalmemory + " Mb after " + seconds + " seconds"));
                    try {
                        Thread.sleep(ProcessMonitorService.this.config.getIntervalSeconds() * 1000);
                    }
                    catch (InterruptedException e) {
                        ProcessMonitorService.this.stop.set(true);
                    }
                }
            }
        });
        t.start();
    }

    @Override
    public void stop() {
        this.stop.set(true);
        this.log.info((Object)("Stopping " + this.config.getExampleName()));
    }

    static double bytesToMb(double d) {
        d /= 1048576.0;
        d = Math.round(d * 100.0);
        return d / 100.0;
    }
}

