/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.demos.webapp.runner;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.jboss.as.demos.DeploymentUtils;
import org.jboss.as.demos.fakejndi.FakeJndi;
import org.jboss.as.demos.webapp.archive.SimpleServlet;
import org.jboss.as.protocol.StreamUtils;

public class ExampleRunner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        DeploymentUtils utils = null;
        QueueConnection conn = null;
        QueueSession session = null;
        try {
            utils = new DeploymentUtils("fakejndi.sar", FakeJndi.class.getPackage());
            utils.addWarDeployment("webapp-example.war", SimpleServlet.class.getPackage());
            utils.deploy();
            QueueConnectionFactory qcf = ExampleRunner.lookup(utils, "RemoteConnectionFactory", QueueConnectionFactory.class);
            Queue queue = ExampleRunner.lookup(utils, "queue/test", Queue.class);
            conn = qcf.createQueueConnection();
            conn.start();
            session = conn.createQueueSession(false, 1);
            QueueReceiver recv = session.createReceiver(queue);
            recv.setMessageListener(new MessageListener(){

                public void onMessage(Message message) {
                    TextMessage msg = (TextMessage)message;
                    try {
                        System.out.println("---->Received from queue: " + msg.getText());
                    }
                    catch (JMSException e) {
                        e.printStackTrace();
                    }
                }
            });
            ExampleRunner.connect("other?value=One");
            ExampleRunner.connect("simple?value=Two");
            ExampleRunner.connect("other?value=Three");
        }
        finally {
            utils.undeploy();
            StreamUtils.safeClose((Closeable)utils);
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void connect(String urlPart) throws Exception {
        URLConnection conn = null;
        BufferedInputStream in = null;
        URL url = new URL("http://localhost:8080/webapp-example/" + urlPart);
        System.out.println("Reading response from " + url + ":");
        conn = url.openConnection();
        conn.setDoInput(true);
        try {
            in = new BufferedInputStream(conn.getInputStream());
        }
        catch (Exception e) {
            ExampleRunner.usage(e);
            StreamUtils.safeClose((Closeable)in);
            return;
        }
        try {
            int i = ((InputStream)in).read();
            StringBuilder sb = new StringBuilder();
            while (i != -1) {
                sb.append((char)i);
                i = ((InputStream)in).read();
            }
            System.out.println(sb.toString());
        }
        catch (Throwable throwable) {
            StreamUtils.safeClose(in);
            throw throwable;
        }
        StreamUtils.safeClose((Closeable)in);
    }

    private static <T> T lookup(DeploymentUtils utils, String name, Class<T> expected) throws Exception {
        MBeanServerConnection mbeanServer = utils.getConnection();
        ObjectName objectName = new ObjectName("jboss:name=test,type=fakejndi");
        Object o = mbeanServer.invoke(objectName, "lookup", new Object[]{name}, new String[]{"java.lang.String"});
        return expected.cast(o);
    }

    private static void usage(Throwable t) throws Exception {
        System.out.println("Caught " + t.toString());
        System.out.println("This is most likely due to the following:");
        System.out.println("Please make sure your standalone.xml includes the H2DS datasource in its <profile> element.");
        System.out.println("An example configuration is as follows:\n");
        System.out.println("<subsystem xmlns=\"urn:jboss:domain:datasources:1.0\">");
        System.out.println("    <datasources>");
        System.out.println("        <datasource jndi-name=\"java:jboss/datasources/ExampleDS\" enabled=\"true\" use-java-context=\"true\" pool-name=\"H2DS\">");
        System.out.println("            <connection-url>jdbc:h2:mem:test;DB_CLOSE_DELAY=-1</connection-url>");
        System.out.println("            <driver-class>org.h2.Driver</driver-class>");
        System.out.println("            <module>com.h2database.h2</module>");
        System.out.println("            <pool></pool>");
        System.out.println("            <security>");
        System.out.println("                <user-name>sa</user-name>");
        System.out.println("                <password>sa</password>");
        System.out.println("            </security>");
        System.out.println("            <validation></validation>");
        System.out.println("            <time-out></time-out>");
        System.out.println("            <statement></statement>");
        System.out.println("        </datasource>");
        System.out.println("    </datasources>");
        System.out.println("</subsystem>");
        System.out.println("\nIf your profile already includes other datasource configurations, just add the nested <datasource> element above next to them.");
    }
}

