/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.demos.domain.servers.runner;

import java.io.Closeable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.demos.DemoAuthentication;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.dmr.ModelNode;

public class ExampleRunner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ModelControllerClient client = ModelControllerClient.Factory.create((String)"localhost", (int)9999, (CallbackHandler)DemoAuthentication.getCallbackHandler());
        try {
            ModelNode address;
            String hostName;
            ModelNode hostNamesOp = new ModelNode();
            hostNamesOp.get("operation").set("read-children-names");
            hostNamesOp.get("address").setEmptyList();
            hostNamesOp.get("child-type").set("host");
            ModelNode hostNames = client.execute(hostNamesOp);
            HashMap hosts = new HashMap();
            for (ModelNode modelNode : hostNames.get("result").asList()) {
                hostName = modelNode.asString();
                HashSet<String> serverNames = new HashSet<String>();
                hosts.put(modelNode.asString(), serverNames);
                ModelNode serverOp = new ModelNode();
                serverOp.get("operation").set("read-children-names");
                serverOp.get("address").setEmptyList().add("host", modelNode.asString());
                serverOp.get("child-type").set("server-config");
                ModelNode serversResult = client.execute(serverOp);
                for (ModelNode server : serversResult.get("result").asList()) {
                    String serverName = server.asString();
                    serverNames.add(serverName);
                    ModelNode serverAddress = new ModelNode();
                    serverAddress.add("host", hostName);
                    serverAddress.add("server-config", serverName);
                    ModelNode serverConfigOp = new ModelNode();
                    serverConfigOp.get("operation").set("read-resource");
                    serverConfigOp.get("address").set(serverAddress);
                    serverConfigOp.get("include-runtime").set(true);
                    ModelNode serverConfig = client.execute(serverConfigOp);
                    System.out.println("\nServer:\n");
                    System.out.println("server name:          " + serverName);
                    System.out.println("host controller name: " + hostName);
                    System.out.println("server group name:    " + serverConfig.get(new String[]{"result", "group"}).asString());
                    System.out.println("status:               " + serverConfig.get(new String[]{"result", "status"}));
                    if (!"STARTED".equals(serverConfig.get(new String[]{"result", "status"}).asString())) continue;
                    serverNames.add(serverName);
                }
            }
            for (Map.Entry entry : hosts.entrySet()) {
                hostName = (String)entry.getKey();
                for (String serverName : (Set)entry.getValue()) {
                    address = new ModelNode();
                    address.add("host", hostName);
                    address.add("server-config", serverName);
                    ExampleRunner.runServerOperation(client, address, "stop");
                }
            }
            Thread.sleep(2000L);
            for (Map.Entry entry : hosts.entrySet()) {
                hostName = (String)entry.getKey();
                for (String serverName : (Set)entry.getValue()) {
                    address = new ModelNode();
                    address.add("host", hostName);
                    address.add("server-config", serverName);
                    ExampleRunner.runServerOperation(client, address, "start");
                }
            }
            Thread.sleep(10000L);
            for (Map.Entry entry : hosts.entrySet()) {
                hostName = (String)entry.getKey();
                for (String serverName : (Set)entry.getValue()) {
                    address = new ModelNode();
                    address.add("host", hostName);
                    address.add("server-config", serverName);
                    ExampleRunner.runServerOperation(client, address, "restart");
                }
            }
            Thread.sleep(2000L);
        }
        finally {
            StreamUtils.safeClose((Closeable)client);
        }
    }

    static ModelNode runServerOperation(ModelControllerClient client, ModelNode address, String opName) throws Exception {
        ModelNode stopOperation = new ModelNode();
        stopOperation.get("operation").set(opName);
        stopOperation.get("address").set(address);
        ModelNode result = client.execute(stopOperation);
        ExampleRunner.checkSuccess(result);
        return result.get("result");
    }

    static void checkSuccess(ModelNode operationResult) throws OperationFailedException {
        if (!"success".equals(operationResult.get("outcome").asString())) {
            throw new OperationFailedException(operationResult.get("failure-description"));
        }
    }
}

