/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.demos.ejb3.rar;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.Connector;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.TransactionSupport;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.XAResource;
import org.jboss.as.demos.ejb3.rar.PostmanPat;
import org.jboss.logging.Logger;

@Connector(reauthenticationSupport=false, transactionSupport=TransactionSupport.TransactionSupportLevel.NoTransaction)
public class SimpleQueueResourceAdapter
implements ResourceAdapter {
    private static final Logger log = Logger.getLogger(SimpleQueueResourceAdapter.class);
    private static final BlockingQueue<String> queue = new LinkedBlockingDeque<String>();
    private static WorkManager workManager;
    private static List<MessageEndpointFactory> endpointFactories;

    public void start(BootstrapContext ctx) throws ResourceAdapterInternalException {
        if (workManager != null) {
            throw new ResourceAdapterInternalException("Can only start once");
        }
        workManager = ctx.getWorkManager();
    }

    public void stop() {
        workManager = null;
    }

    public static void deliver(String message) throws WorkException {
        queue.add(message);
        workManager.doWork(new Work(){

            public void release() {
                Thread.currentThread().interrupt();
            }

            public void run() {
                try {
                    SimpleQueueResourceAdapter.process();
                }
                catch (UnavailableException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public void endpointActivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) throws ResourceException {
        endpointFactories.add(endpointFactory);
    }

    public void endpointDeactivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) {
        endpointFactories.remove(endpointFactory);
    }

    public XAResource[] getXAResources(ActivationSpec[] specs) throws ResourceException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void process() throws UnavailableException {
        if (endpointFactories.size() == 0) {
            return;
        }
        MessageEndpoint endpoint = endpointFactories.get(0).createEndpoint(null);
        block7: while (true) {
            while (!queue.isEmpty()) {
                try {
                    String message = queue.poll(30L, TimeUnit.SECONDS);
                    try {
                        ((PostmanPat)endpoint).deliver(message);
                        continue block7;
                    }
                    catch (Throwable t) {
                        log.error((Object)("Failed to deliver message " + message), t);
                    }
                }
                catch (InterruptedException e) {
                    endpoint.release();
                    return;
                }
            }
        }
        finally {
            endpoint.release();
        }
    }

    static {
        endpointFactories = new LinkedList<MessageEndpointFactory>();
    }
}

