/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.demos.jpa.runner;

import java.io.Closeable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.jboss.as.demos.DeploymentUtils;
import org.jboss.as.demos.jpa.archive.SimpleStatelessSessionBean;
import org.jboss.as.demos.jpa.archive.SimpleStatelessSessionLocal;
import org.jboss.as.demos.jpa.mbean.ExerciseStateful;
import org.jboss.as.demos.jpa.mbean.Test;
import org.jboss.as.demos.jpa.runner.TestMBeanInvocationHandler;
import org.jboss.as.protocol.StreamUtils;

public class ExampleRunner {
    private static <T> T createProxy(MBeanServerConnection mbeanServer, String lookupName, Class<T> intf) {
        TestMBeanInvocationHandler handler = new TestMBeanInvocationHandler(mbeanServer, lookupName);
        Class[] interfaces = new Class[]{intf};
        return intf.cast(Proxy.newProxyInstance(intf.getClassLoader(), interfaces, (InvocationHandler)handler));
    }

    private static void doStatefulMagic(MBeanServerConnection server) throws Exception {
        String msg = (String)server.invoke(new ObjectName("jboss:name=jpa-test,type=service"), "exec", new Object[]{ExerciseStateful.class}, new String[]{Class.class.getName()});
        System.out.println(msg);
        msg = (String)server.invoke(new ObjectName("jboss:name=jpa-test,type=service"), "exec", new Object[]{ExerciseStateful.class}, new String[]{Class.class.getName()});
        System.out.println(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ExampleRunner.showInfo();
        DeploymentUtils utils = new DeploymentUtils("jpa-example.jar", SimpleStatelessSessionBean.class.getPackage());
        try {
            utils.addDeployment("jpa-mbean.sar", Test.class.getPackage());
            utils.deploy();
            MBeanServerConnection mbeanServer = utils.getConnection();
            SimpleStatelessSessionLocal bean = ExampleRunner.createProxy(mbeanServer, "java:global/jpa-example/SimpleStatelessSessionBean!" + SimpleStatelessSessionLocal.class.getName(), SimpleStatelessSessionLocal.class);
            String msg = bean.echo("Hello world");
            System.out.println(msg);
            ExampleRunner.doStatefulMagic(mbeanServer);
        }
        finally {
            utils.undeploy();
            StreamUtils.safeClose((Closeable)utils);
        }
    }

    private static void showInfo() {
        System.out.println("Thanks for running the JPA demo and helping to test the bits out on your system.  By the way, its normal to see a 'RejectedExecutionException' at the end of the demo but other errors probably mean a problem occurred.");
    }
}

