/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.demos.client;

import java.io.Closeable;
import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.concurrent.Future;
import org.jboss.as.model.PathElementUpdate;
import org.jboss.as.model.ServerModel;
import org.jboss.as.model.ServerPathAdd;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.standalone.client.api.StandaloneClient;
import org.jboss.as.standalone.client.api.StandaloneUpdateResult;
import org.jboss.as.standalone.client.api.deployment.ServerDeploymentManager;

public class __TestStandaloneClient {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        System.out.println("Creating client");
        StandaloneClient client = null;
        try {
            client = StandaloneClient.Factory.create((InetAddress)InetAddress.getByName("localhost"), (int)9999);
            System.out.println("Created client, getting model...");
            ServerModel model = client.getServerModel();
            System.out.println("Got model " + model);
            ArrayList<ServerPathAdd> updates = new ArrayList<ServerPathAdd>();
            updates.add(new ServerPathAdd(new PathElementUpdate("org.jboss.test", "/home/emuckenh/Downloads", null)));
            for (StandaloneUpdateResult result : client.applyUpdates(updates)) {
                if (result.isSuccess()) {
                    System.out.println(result.getResult());
                    continue;
                }
                result.getFailure().printStackTrace(System.out);
            }
            System.out.println("Created client, getting dm...");
            ServerDeploymentManager manager = client.getDeploymentManager();
            System.out.println("Got manager " + manager);
            File file = new File("sar-example.sar");
            if (!file.exists()) {
                throw new IllegalStateException("No file sar-example.sar");
            }
            String deployment = manager.addDeploymentContent(file.toURL());
            System.out.println("Added deployment " + deployment);
            Future deploymentResult = manager.execute(manager.newDeploymentPlan().add(deployment, file).deploy(deployment).build());
            System.out.println("Deployment result:" + deploymentResult);
            System.out.println("Contained deployment result:" + deploymentResult.get());
            Thread.sleep(3000L);
            manager.execute(manager.newDeploymentPlan().undeploy(deployment).remove(deployment).build());
        }
        catch (Throwable throwable) {
            StreamUtils.safeClose(client);
            throw throwable;
        }
        StreamUtils.safeClose((Closeable)client);
    }
}

