/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.demos.client.messaging.runner;

import java.net.InetAddress;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.resource.spi.IllegalStateException;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientConsumer;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientProducer;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.HornetQClient;
import org.hornetq.core.remoting.impl.netty.NettyConnectorFactory;
import org.jboss.as.messaging.QueueAdd;
import org.jboss.as.messaging.QueueRemove;
import org.jboss.as.model.AbstractServerModelUpdate;
import org.jboss.as.model.AbstractSubsystemUpdate;
import org.jboss.as.model.ServerSubsystemUpdate;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.standalone.client.api.StandaloneClient;
import org.jboss.as.standalone.client.api.StandaloneUpdateResult;

public class ExampleRunner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String queueName = "queue.standalone";
        ClientSessionFactory sf = ExampleRunner.createClientSessionFactory("localhost", 5445);
        StandaloneClient client = StandaloneClient.Factory.create((InetAddress)InetAddress.getByName("localhost"), (int)9999);
        try {
            if (ExampleRunner.queueExists("queue.standalone", sf)) {
                throw new IllegalStateException();
            }
            QueueAdd add = new QueueAdd("queue.standalone");
            add.setAddress("queue.standalone");
            ExampleRunner.applyUpdates(Collections.singletonList(ServerSubsystemUpdate.create((AbstractSubsystemUpdate)add)), client);
            if (!ExampleRunner.queueExists("queue.standalone", sf)) {
                throw new IllegalStateException();
            }
            ClientSession session = null;
            try {
                session = sf.createSession();
                ClientProducer producer = session.createProducer("queue.standalone");
                ClientMessage message = session.createMessage(false);
                String propName = "myprop";
                message.putStringProperty("myprop", "Hello sent at " + new Date());
                System.out.println("Sending the message.");
                producer.send((Message)message);
                ClientConsumer messageConsumer = session.createConsumer("queue.standalone");
                session.start();
                ClientMessage messageReceived = messageConsumer.receive(1000L);
                System.out.println("Received TextMessage:" + messageReceived.getStringProperty("myprop"));
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
            QueueRemove remove = new QueueRemove("queue.standalone");
            ExampleRunner.applyUpdates(Collections.singletonList(ServerSubsystemUpdate.create((AbstractSubsystemUpdate)remove)), client);
            if (ExampleRunner.queueExists("queue.standalone", sf)) {
                throw new IllegalStateException();
            }
        }
        finally {
            client.close();
        }
    }

    static void applyUpdates(List<AbstractServerModelUpdate<?>> updates, StandaloneClient client) throws UpdateFailedException {
        for (StandaloneUpdateResult result : client.applyUpdates(updates)) {
            if (result.isSuccess()) continue;
            throw result.getFailure();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean queueExists(String queueName, ClientSessionFactory sf) throws HornetQException {
        ClientSession session = sf.createSession(false, false, false);
        try {
            ClientSession.QueueQuery query = session.queueQuery(new SimpleString(queueName));
            boolean bl = query.isExists();
            return bl;
        }
        finally {
            session.close();
        }
    }

    static ClientSessionFactory createClientSessionFactory(String host, int port) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("host", host);
        properties.put("port", port);
        TransportConfiguration configuration = new TransportConfiguration(NettyConnectorFactory.class.getName(), properties);
        return HornetQClient.createClientSessionFactory((TransportConfiguration)configuration);
    }
}

