/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.demos.jpa.runner;

import java.io.Closeable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.jboss.as.demos.DeploymentUtils;
import org.jboss.as.demos.jpa.archive.SimpleStatelessSessionBean;
import org.jboss.as.demos.jpa.archive.SimpleStatelessSessionLocal;
import org.jboss.as.demos.jpa.mbean.ExerciseStateful;
import org.jboss.as.demos.jpa.mbean.Test;
import org.jboss.as.demos.jpa.runner.TestMBeanInvocationHandler;
import org.jboss.as.protocol.StreamUtils;

public class ExampleRunner {
    private static <T> T createProxy(MBeanServerConnection mbeanServer, String lookupName, Class<T> intf) {
        TestMBeanInvocationHandler handler = new TestMBeanInvocationHandler(mbeanServer, lookupName);
        Class[] interfaces = new Class[]{intf};
        return intf.cast(Proxy.newProxyInstance(intf.getClassLoader(), interfaces, (InvocationHandler)handler));
    }

    private static void doStatefulMagic(MBeanServerConnection server) throws Exception {
        String msg = (String)server.invoke(new ObjectName("jboss:name=jpa-test,type=service"), "exec", new Object[]{ExerciseStateful.class}, new String[]{Class.class.getName()});
        System.out.println(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ExampleRunner.showInfo();
        DeploymentUtils utils = new DeploymentUtils("jpa-example.jar", SimpleStatelessSessionBean.class.getPackage());
        try {
            utils.addDeployment("jpa-mbean.sar", Test.class.getPackage());
            utils.deploy();
            MBeanServerConnection mbeanServer = utils.getConnection();
            SimpleStatelessSessionLocal bean = ExampleRunner.createProxy(mbeanServer, "java:global/jpa-example/SimpleStatelessSessionBean!" + SimpleStatelessSessionLocal.class.getName(), SimpleStatelessSessionLocal.class);
            String msg = bean.echo("Hello world");
            System.out.println(msg);
            ExampleRunner.doStatefulMagic(mbeanServer);
        }
        finally {
            utils.undeploy();
            StreamUtils.safeClose((Closeable)utils);
        }
    }

    private static void showInfo() {
        System.out.println("Thanks for running the JPA demo and helping to test the bits out on your system.  Here are a few brief preparation steps for running the demo, in case you need them.  By the way, its normal to see a 'RejectedExecutionException' at the end of the demo but other errors probably mean a problem occurred.");
        System.out.println("1.  Enable the \"java:/H2DS\" datasource in standalone.xml (find \"java:/H2DS\" and change enabled=\"true\") \n2.  Disable osgi in standalone.xml (so that JDBC datasources works).  Find \"<subsystem xmlns=\"urn:jboss:domain:osgi\" and delete up to the matching \"</subsystem>\" \n3.  cp as7/build/target/jboss-7.0.0.Alpha2/modules/com/h2database/h2/main/h2-1.2.144.jar as7/build/target/jboss-7.0.0.Alpha2/standalone/deployments/ \n4.  touch  as7/build/target/jboss-7.0.0.Alpha2/standalone/deployments/h2-1.2.144.jar.dodeploy \n5.  cd as7/build/target/jboss-7.0.0.Alpha2/ \n6.  ./startup.sh \n7.  cd as7/demos \n8.  mvn package -Dexample=jpa\n\n");
    }
}

