/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.scanner;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.server.deployment.scanner.DeploymentOperations;
import org.jboss.dmr.ModelNode;

final class DefaultDeploymentOperations
implements DeploymentOperations {
    private final ModelControllerClient controllerClient;

    DefaultDeploymentOperations(ModelControllerClient controllerClient) {
        this.controllerClient = controllerClient;
    }

    @Override
    public Future<ModelNode> deploy(final ModelNode operation, ScheduledExecutorService scheduledExecutor) {
        return scheduledExecutor.submit(new Callable<ModelNode>(){

            @Override
            public ModelNode call() throws Exception {
                return DefaultDeploymentOperations.this.controllerClient.execute(operation);
            }
        });
    }

    @Override
    public Set<String> getDeploymentNames() {
        ModelNode response;
        ModelNode op = Util.getEmptyOperation((String)"read-children-names", (ModelNode)new ModelNode());
        op.get("child-type").set("deployment");
        try {
            response = this.controllerClient.execute(op);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ModelNode result = response.get("result");
        HashSet<String> deploymentNames = new HashSet<String>();
        if (result.isDefined()) {
            List deploymentNodes = result.asList();
            for (ModelNode node : deploymentNodes) {
                deploymentNames.add(node.asString());
            }
        }
        return deploymentNames;
    }

    @Override
    public void close() throws IOException {
        this.controllerClient.close();
    }
}

