/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.logging.Logger;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.StartException;

public final class FutureServiceValue<T>
implements Future<T> {
    private static final Logger log = Logger.getLogger(FutureServiceValue.class);
    private ServiceController<T> controller;

    public FutureServiceValue(ServiceController<T> controller) {
        if (controller == null) {
            throw new IllegalArgumentException("Null controller");
        }
        this.controller = controller;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.controller.getState() == ServiceController.State.UP;
    }

    @Override
    public T get() throws ExecutionException {
        try {
            return this.get(5L, TimeUnit.SECONDS);
        }
        catch (TimeoutException ex) {
            throw new ExecutionException(ex);
        }
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws ExecutionException, TimeoutException {
        return this.getValue(timeout, unit);
    }

    private T getValue(long timeout, TimeUnit unit) throws ExecutionException, TimeoutException {
        if (this.controller.getState() == ServiceController.State.UP) {
            return (T)this.controller.getValue();
        }
        final CountDownLatch latch = new CountDownLatch(1);
        final FutureServiceValue futureServiceValue = this;
        final String serviceName = this.controller.getName().getCanonicalName();
        AbstractServiceListener listener = new AbstractServiceListener<T>(){

            public void listenerAdded(ServiceController<? extends T> controller) {
                ServiceController.State state = controller.getState();
                if (state == ServiceController.State.UP || state == ServiceController.State.START_FAILED) {
                    this.listenerDone(controller);
                }
            }

            public void transition(ServiceController<? extends T> controller, ServiceController.Transition transition) {
                log.tracef("transition %s %s => %s", (Object)futureServiceValue, (Object)serviceName, (Object)transition);
                switch (transition) {
                    case STARTING_to_UP: 
                    case STARTING_to_START_FAILED: {
                        this.listenerDone(controller);
                    }
                }
            }

            private void listenerDone(ServiceController<? extends T> controller) {
                controller.removeListener((ServiceListener)this);
                latch.countDown();
            }
        };
        this.controller.addListener((ServiceListener)listener);
        try {
            if (!latch.await(timeout, unit)) {
                TimeoutException ex = new TimeoutException("Timeout getting " + serviceName);
                this.processTimeoutException(ex);
                throw ex;
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (this.controller.getState() == ServiceController.State.UP) {
            return (T)this.controller.getValue();
        }
        StartException startException = this.controller.getStartException();
        throw new ExecutionException("Cannot get service value for: " + serviceName, (Throwable)startException);
    }

    private void processTimeoutException(TimeoutException exception) {
        ThreadInfo[] infos;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(baos);
        this.controller.getServiceContainer().dumpServices(out);
        String serviceName = this.controller.getName().getCanonicalName();
        log.errorf("Cannot get service value for: %s\n%s", (Object)serviceName, (Object)new String(baos.toByteArray()));
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo info : infos = bean.dumpAllThreads(true, true)) {
            if (!info.getThreadName().contains("MSC")) continue;
            StringBuffer buffer = new StringBuffer();
            buffer.append("ThreadInfo: " + info);
            log.errorf("%s", (Object)buffer);
        }
    }
}

