/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.io.IOException;
import java.io.InputStream;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.server.deployment.repository.api.ContentRepository;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public abstract class AbstractDeploymentUploadHandler
implements OperationStepHandler {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.server");
    private static final String[] EMPTY = new String[0];
    private final ContentRepository contentRepository;
    private final ParametersValidator validator = new ParametersValidator();

    protected AbstractDeploymentUploadHandler(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        try {
            this.validator.validate(operation);
            InputStream is = this.getContentInputStream(context, operation);
            try {
                byte[] hash = this.contentRepository.addContent(is);
                context.getResult().set(hash);
            }
            finally {
                AbstractDeploymentUploadHandler.safeClose(is);
            }
        }
        catch (IOException e) {
            throw new OperationFailedException(new ModelNode().set(e.toString()));
        }
        context.completeStep();
    }

    protected abstract InputStream getContentInputStream(OperationContext var1, ModelNode var2) throws IOException, OperationFailedException;

    private static void safeClose(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception e) {
                log.warn((Object)"Caught exception closing input stream", (Throwable)e);
            }
        }
    }
}

