/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.deployment.jsf;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.as.web.deployment.WebAttachments;
import org.jboss.as.web.deployment.component.WebComponentDescription;
import org.jboss.as.web.deployment.component.WebComponentInstantiator;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.parser.util.NoopXmlResolver;
import org.jboss.metadata.web.spec.WebMetaData;
import org.jboss.modules.Module;
import org.jboss.vfs.VirtualFile;

public class JsfManagedBeanProcessor
implements DeploymentUnitProcessor {
    public static final DotName MANAGED_BEAN_ANNOTATION = DotName.createSimple((String)"javax.faces.bean.ManagedBean");
    private static final String WEB_INF_FACES_CONFIG = "WEB-INF/faces-config.xml";
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.web.jsf");
    private static final String MANAGED_BEAN = "managed-bean";
    private static final String MANAGED_BEAN_CLASS = "managed-bean-class";
    private static final String CONFIG_FILES = "javax.faces.CONFIG_FILES";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPOSITE_ANNOTATION_INDEX);
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        if (index == null) {
            return;
        }
        if (module == null) {
            return;
        }
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        HashSet<String> managedBeanClasses = new HashSet<String>();
        this.handleAnnotations(index, managedBeanClasses);
        this.processXmlManagedBeans(deploymentUnit, managedBeanClasses);
        for (String managedBean : managedBeanClasses) {
            try {
                Class componentClass = module.getClassLoader().loadClass(managedBean);
                componentClass.getConstructor(new Class[0]);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)("Could not load JSF managed bean class " + managedBean));
                continue;
            }
            catch (NoSuchMethodException e) {
                log.error((Object)("JSF managed bean class " + managedBean + " has no default constructor"));
                continue;
            }
            this.installManagedBeanComponent(managedBean, moduleDescription, deploymentUnit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processXmlManagedBeans(DeploymentUnit deploymentUnit, Set<String> managedBeanClasses) {
        block11: for (VirtualFile facesConfig : this.getConfigurationFiles(deploymentUnit)) {
            InputStream is = null;
            try {
                is = facesConfig.openStream();
                XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                inputFactory.setXMLResolver(NoopXmlResolver.create());
                XMLStreamReader parser = inputFactory.createXMLStreamReader(is);
                StringBuilder className = null;
                int indent = 0;
                boolean managedBean = false;
                boolean managedBeanClass = false;
                while (true) {
                    int event;
                    if ((event = parser.next()) == 8) {
                        parser.close();
                        continue block11;
                    }
                    if (event == 1) {
                        if (++indent == 2) {
                            if (!parser.getLocalName().equals(MANAGED_BEAN)) continue;
                            managedBean = true;
                            continue;
                        }
                        if (indent != 3 || !managedBean || !parser.getLocalName().equals(MANAGED_BEAN_CLASS)) continue;
                        managedBeanClass = true;
                        className = new StringBuilder();
                        continue;
                    }
                    if (event == 2) {
                        managedBeanClass = false;
                        if (--indent == 1) {
                            managedBean = false;
                        }
                        if (className == null) continue;
                        managedBeanClasses.add(className.toString().trim());
                        className = null;
                        continue;
                    }
                    if (!managedBeanClass || event != 4) continue;
                    className.append(parser.getText());
                }
            }
            catch (Exception e) {
                log.error((Object)("Failed to parse " + facesConfig + " injection into manage beans defined in this file will not be available"));
            }
            finally {
                try {
                    if (is == null) continue;
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public Set<VirtualFile> getConfigurationFiles(DeploymentUnit deploymentUnit) {
        List contextParams;
        WebMetaData webMetaData;
        HashSet<VirtualFile> ret = new HashSet<VirtualFile>();
        List resourceRoots = DeploymentUtils.allResourceRoots((DeploymentUnit)deploymentUnit);
        for (ResourceRoot resourceRoot : resourceRoots) {
            VirtualFile metaInf;
            VirtualFile webInfFacesConfig = resourceRoot.getRoot().getChild(WEB_INF_FACES_CONFIG);
            if (webInfFacesConfig.exists()) {
                ret.add(webInfFacesConfig);
            }
            if (!(metaInf = resourceRoot.getRoot().getChild("META-INF")).exists() || !metaInf.isDirectory()) continue;
            for (VirtualFile file : metaInf.getChildren()) {
                if (!file.getName().equals("faces-config.xml") && !file.getName().endsWith(".faces-config.xml")) continue;
                ret.add(file);
            }
        }
        String configFiles = null;
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData != null && (webMetaData = warMetaData.getWebMetaData()) != null && (contextParams = webMetaData.getContextParams()) != null) {
            for (ParamValueMetaData param : contextParams) {
                if (!param.getParamName().equals(CONFIG_FILES)) continue;
                configFiles = param.getParamValue();
                break;
            }
        }
        if (configFiles != null) {
            String[] files = configFiles.split(",");
            ResourceRoot deploymentRoot = (ResourceRoot)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_ROOT);
            if (deploymentRoot != null) {
                for (String file : files) {
                    VirtualFile configFile = deploymentRoot.getRoot().getChild(file);
                    if (!configFile.exists()) continue;
                    ret.add(configFile);
                }
            }
        }
        return ret;
    }

    private void handleAnnotations(CompositeIndex index, Set<String> managedBeanClasses) throws DeploymentUnitProcessingException {
        List annotations = index.getAnnotations(MANAGED_BEAN_ANNOTATION);
        if (annotations != null) {
            for (AnnotationInstance annotation : annotations) {
                AnnotationTarget target = annotation.target();
                if (target instanceof ClassInfo) {
                    String className = ((ClassInfo)target).name().toString();
                    managedBeanClasses.add(className);
                    continue;
                }
                throw new DeploymentUnitProcessingException("@ManagedBean can only be placed on a class");
            }
        }
    }

    private void installManagedBeanComponent(String className, EEModuleDescription moduleDescription, DeploymentUnit deploymentUnit) {
        WebComponentDescription componentDescription = new WebComponentDescription(MANAGED_BEAN.toString() + "." + className, className, moduleDescription, deploymentUnit.getServiceName());
        moduleDescription.addComponent((ComponentDescription)componentDescription);
        ((Map)deploymentUnit.getAttachment(WebAttachments.WEB_COMPONENT_INSTANTIATORS)).put(componentDescription.getComponentClassName(), new WebComponentInstantiator(deploymentUnit, componentDescription));
    }

    public void undeploy(DeploymentUnit context) {
    }
}

