/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import org.infinispan.CacheException;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.ReadCommittedEntry;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class RepeatableReadEntry
extends ReadCommittedEntry {
    private static final Log log = LogFactory.getLog(RepeatableReadEntry.class);

    public RepeatableReadEntry(Object key, Object value, long lifespan) {
        super(key, value, lifespan);
    }

    @Override
    public void copyForUpdate(DataContainer container, boolean writeSkewCheck) {
        if (this.isChanged()) {
            return;
        }
        this.setChanged();
        if (writeSkewCheck) {
            Object actualValue;
            InternalCacheEntry ice = container.get(this.key);
            Object object = actualValue = ice == null ? null : ice.getValue();
            if (actualValue != null && actualValue != this.value) {
                log.unableToCopyEntryForUpdate(this.getKey());
                throw new CacheException("Detected write skew");
            }
        }
        this.oldValue = this.value;
    }
}

