/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.control.RehashControlCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.config.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.context.impl.NonTxInvocationContext;
import org.infinispan.distribution.DistributionManagerImpl;
import org.infinispan.distribution.RehashTask;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashHelper;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheStore;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.Immutables;
import org.infinispan.util.ReadOnlyDataContainerBackedKeySet;
import org.infinispan.util.Util;
import org.infinispan.util.concurrent.AggregatingNotifyingFutureImpl;

public class RebalanceTask
extends RehashTask {
    private final InvocationContextContainer icc;
    private final CacheNotifier notifier;
    private final InterceptorChain interceptorChain;
    private int newViewId;

    public RebalanceTask(RpcManager rpcManager, CommandsFactory commandsFactory, Configuration conf, DataContainer dataContainer, DistributionManagerImpl dmi, InvocationContextContainer icc, CacheNotifier notifier, InterceptorChain interceptorChain, int newViewId) {
        super(dmi, rpcManager, conf, commandsFactory, dataContainer);
        this.icc = icc;
        this.notifier = notifier;
        this.interceptorChain = interceptorChain;
        this.newViewId = newViewId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void performRehash() throws Exception {
        long start = System.currentTimeMillis();
        if (this.log.isDebugEnabled()) {
            this.log.debugf("Commencing rehash on node: %s. Before start, distributionManager.joinComplete = %s", this.getMyAddress(), this.distributionManager.isJoinComplete());
        }
        try {
            block26: {
                this.distributionManager.getTransactionLogger().blockNewTransactions();
                boolean needToUnblockTransactions = true;
                try {
                    ConsistentHash chOld = this.distributionManager.getConsistentHash();
                    List<Address> newMembers = this.rpcManager.getTransport().getMembers();
                    ConsistentHash chNew = ConsistentHashHelper.createConsistentHash(this.configuration, newMembers);
                    this.notifier.notifyTopologyChanged(chOld, chNew, true);
                    this.distributionManager.setConsistentHash(chNew);
                    this.notifier.notifyTopologyChanged(chOld, chNew, false);
                    if (this.log.isTraceEnabled()) {
                        this.log.tracef("Rebalancing\nchOld = %s\nchNew = %s", chOld, chNew);
                    }
                    if (this.configuration.isRehashEnabled()) {
                        Collection<Address> oldCacheSet = Immutables.immutableCollectionWrap(chOld.getCaches());
                        Collection<Address> newCacheSet = Immutables.immutableCollectionWrap(chNew.getCaches());
                        this.notifier.notifyDataRehashed(oldCacheSet, newCacheSet, this.newViewId, true);
                        ArrayList<Object> keysToRemove = new ArrayList<Object>();
                        AggregatingNotifyingFutureImpl stateTransferFuture = new AggregatingNotifyingFutureImpl(null, newMembers.size());
                        int numOwners = this.configuration.getNumOwners();
                        HashMap<Address, Map<Object, InternalCacheValue>> states = new HashMap<Address, Map<Object, InternalCacheValue>>();
                        for (InternalCacheEntry ice : this.dataContainer) {
                            this.rebalance(ice.getKey(), ice, numOwners, chOld, chNew, null, states, keysToRemove);
                        }
                        CacheStore cacheStore = this.distributionManager.getCacheStoreForRehashing();
                        if (cacheStore != null) {
                            for (Object object : cacheStore.loadAllKeys(new ReadOnlyDataContainerBackedKeySet(this.dataContainer))) {
                                this.rebalance(object, null, numOwners, chOld, chNew, cacheStore, states, keysToRemove);
                            }
                        } else if (this.trace) {
                            this.log.trace("Shared cache store or fetching of persistent state disabled");
                        }
                        for (Map.Entry entry : states.entrySet()) {
                            Address target = (Address)entry.getKey();
                            Map state = (Map)entry.getValue();
                            if (this.trace) {
                                this.log.tracef("%s pushing to %s keys %s", this.self, target, state.keySet());
                            }
                            RehashControlCommand cmd = this.cf.buildRehashControlCommand(RehashControlCommand.Type.APPLY_STATE, this.self, this.newViewId, state, chOld, chNew);
                            this.rpcManager.invokeRemotelyInFuture(Collections.singleton(target), cmd, false, stateTransferFuture, this.configuration.getRehashRpcTimeout());
                        }
                        needToUnblockTransactions = false;
                        this.distributionManager.getTransactionLogger().unblockNewTransactions();
                        try {
                            stateTransferFuture.get();
                        }
                        catch (ExecutionException e) {
                            this.log.errorTransferringState(e);
                        }
                        this.notifier.notifyDataRehashed(oldCacheSet, newCacheSet, this.newViewId, false);
                        try {
                            InvalidateCommand invalidateCmd = this.cf.buildInvalidateFromL1Command(true, keysToRemove);
                            NonTxInvocationContext nonTxInvocationContext = this.icc.createNonTxInvocationContext();
                            nonTxInvocationContext.setFlags(Flag.SKIP_LOCKING);
                            this.interceptorChain.invoke(nonTxInvocationContext, invalidateCmd);
                        }
                        catch (Throwable t) {
                            this.log.failedToInvalidateKeys(t);
                        }
                        if (this.trace) {
                            if (keysToRemove.size() > 0) {
                                this.log.tracef("%s removed keys %s", this.self, keysToRemove);
                            }
                            this.log.tracef("data container has now %d keys", this.dataContainer.size());
                        }
                        break block26;
                    }
                    if (this.trace) {
                        this.log.trace("Rehash not enabled, so not pushing state");
                    }
                }
                finally {
                    if (needToUnblockTransactions) {
                        this.distributionManager.getTransactionLogger().unblockNewTransactions();
                    }
                }
            }
            Transport t = this.rpcManager.getTransport();
            if (t.isCoordinator()) {
                this.distributionManager.markNodePushCompleted(this.newViewId, t.getAddress());
            } else {
                RehashControlCommand cmd = this.cf.buildRehashControlCommand(RehashControlCommand.Type.NODE_PUSH_COMPLETED, this.self, this.newViewId);
                this.rpcManager.invokeRemotely(Collections.singleton(t.getCoordinator()), (ReplicableCommand)cmd, ResponseMode.SYNCHRONOUS, this.configuration.getRehashRpcTimeout());
            }
        }
        finally {
            this.log.debugf("Node %s completed join rehash in %s!", this.self, Util.prettyPrintTime(System.currentTimeMillis() - start));
        }
    }

    protected void rebalance(Object key, InternalCacheEntry value, int numOwners, ConsistentHash chOld, ConsistentHash chNew, CacheStore cacheStore, Map<Address, Map<Object, InternalCacheValue>> states, List<Object> keysToRemove) {
        List<Address> newOwners;
        List<Address> oldOwners = chOld.locate(key, numOwners);
        if (((Object)oldOwners).equals(newOwners = chNew.locate(key, numOwners))) {
            return;
        }
        if (this.trace) {
            this.log.tracef("Rebalancing key %s from %s to %s", key, oldOwners, newOwners);
        }
        Address pushingOwner = null;
        for (int i = oldOwners.size() - 1; i >= 0; --i) {
            Address server = oldOwners.get(i);
            if (!newOwners.contains(server)) continue;
            pushingOwner = server;
            break;
        }
        if (this.self.equals(pushingOwner)) {
            if (value == null) {
                try {
                    value = cacheStore.load(key);
                }
                catch (CacheLoaderException e) {
                    this.log.failedLoadingValueFromCacheStore(key);
                }
            }
            for (Address server : newOwners) {
                if (oldOwners.contains(server)) continue;
                Map<Object, InternalCacheValue> map = states.get(server);
                if (map == null) {
                    map = new HashMap<Object, InternalCacheValue>();
                    states.put(server, map);
                }
                if (value == null) continue;
                map.put(key, value.toInternalCacheValue());
            }
        }
        if (oldOwners.contains(this.self) && !newOwners.contains(this.self)) {
            keysToRemove.add(key);
        }
    }

    public Address getMyAddress() {
        return this.rpcManager != null && this.rpcManager.getTransport() != null ? this.rpcManager.getTransport().getAddress() : null;
    }
}

