/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.TransactionLogger;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TransactionLoggerImpl
implements TransactionLogger {
    private static final Log log = LogFactory.getLog(TransactionLoggerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final int DRAIN_LOCK_THRESHOLD = 25;
    private static final int GROWTH_COUNT_THRESHOLD = 3;
    private int previousSize;
    private int growthCount;
    private volatile boolean loggingEnabled;
    private ReentrantReadWriteLock txLock = new ReentrantReadWriteLock();
    final BlockingQueue<WriteCommand> commandQueue = new LinkedBlockingQueue<WriteCommand>();
    final Map<GlobalTransaction, PrepareCommand> uncommittedPrepares = new ConcurrentHashMap<GlobalTransaction, PrepareCommand>();
    private final CommandsFactory cf;

    public TransactionLoggerImpl(CommandsFactory cf) {
        this.cf = cf;
    }

    @Override
    public void enable() {
        this.loggingEnabled = true;
    }

    @Override
    public List<WriteCommand> drain() {
        LinkedList<WriteCommand> list = new LinkedList<WriteCommand>();
        this.commandQueue.drainTo(list);
        return list;
    }

    @Override
    public List<WriteCommand> drainAndLock() throws InterruptedException {
        this.blockNewTransactions();
        return this.drain();
    }

    @Override
    public void unlockAndDisable() {
        this.loggingEnabled = false;
        this.uncommittedPrepares.clear();
        this.unblockNewTransactions();
    }

    @Override
    public void afterCommand(WriteCommand command) throws InterruptedException {
        this.txLock.readLock().unlock();
        if (this.loggingEnabled && command.isSuccessful()) {
            this.commandQueue.put(command);
        }
    }

    @Override
    public void afterCommand(PrepareCommand command) throws InterruptedException {
        this.txLock.readLock().unlock();
        if (this.loggingEnabled) {
            if (command.isOnePhaseCommit()) {
                this.logModificationsInTransaction(command);
            } else {
                this.uncommittedPrepares.put(command.getGlobalTransaction(), command);
            }
        }
    }

    @Override
    public void afterCommand(CommitCommand command, TxInvocationContext context) throws InterruptedException {
        this.txLock.readLock().unlock();
        if (this.loggingEnabled) {
            PrepareCommand pc = this.uncommittedPrepares.remove(command.getGlobalTransaction());
            if (pc == null) {
                this.logModifications(context.getModifications());
            } else {
                this.logModificationsInTransaction(pc);
            }
        }
    }

    @Override
    public void afterCommand(RollbackCommand command) {
        this.txLock.readLock().unlock();
        if (this.loggingEnabled) {
            this.uncommittedPrepares.remove(command.getGlobalTransaction());
        }
    }

    private void logModificationsInTransaction(PrepareCommand command) throws InterruptedException {
        this.logModifications(Arrays.asList(command.getModifications()));
    }

    private void logModifications(Collection<WriteCommand> mods) throws InterruptedException {
        for (WriteCommand wc : mods) {
            this.commandQueue.put(wc);
        }
    }

    @Override
    public void beforeCommand(WriteCommand command) throws InterruptedException {
        this.txLock.readLock().lock();
    }

    @Override
    public void beforeCommand(PrepareCommand command) throws InterruptedException {
        this.txLock.readLock().lock();
    }

    @Override
    public void beforeCommand(CommitCommand command, TxInvocationContext context) throws InterruptedException {
        GlobalTransaction gtx;
        this.txLock.readLock().lock();
        if (this.loggingEnabled && !this.uncommittedPrepares.containsKey(gtx = context.getGlobalTransaction())) {
            this.uncommittedPrepares.put(gtx, this.cf.buildPrepareCommand(gtx, context.getModifications(), false));
        }
    }

    @Override
    public void beforeCommand(RollbackCommand command) throws InterruptedException {
        this.txLock.readLock().lock();
    }

    private int size() {
        return this.loggingEnabled ? this.commandQueue.size() : 0;
    }

    @Override
    public boolean isEnabled() {
        return this.loggingEnabled;
    }

    @Override
    public boolean shouldDrainWithoutLock() {
        if (this.loggingEnabled) {
            boolean shouldLock;
            int sz = this.size();
            boolean bl = shouldLock = this.previousSize > 0 && this.growthCount > 3 || sz < 25;
            if (!shouldLock) {
                if (sz > this.previousSize && this.previousSize > 0) {
                    ++this.growthCount;
                }
                this.previousSize = sz;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public Collection<PrepareCommand> getPendingPrepares() {
        HashSet<PrepareCommand> commands = new HashSet<PrepareCommand>(this.uncommittedPrepares.values());
        this.uncommittedPrepares.clear();
        return commands;
    }

    @Override
    public void blockNewTransactions() throws InterruptedException {
        if (trace) {
            log.debug("Blocking new transactions");
        }
        this.txLock.writeLock().lockInterruptibly();
    }

    @Override
    public void unblockNewTransactions() {
        if (trace) {
            log.debug("Unblocking new transactions");
        }
        this.txLock.writeLock().unlock();
    }

    public String toString() {
        return "TransactionLoggerImpl{commandQueue=" + this.commandQueue + ", uncommittedPrepares=" + this.uncommittedPrepares + '}';
    }
}

