/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.config.ConfigurationException;
import org.infinispan.io.ExposedByteArrayOutputStream;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderMetadata;
import org.infinispan.loaders.bucket.Bucket;
import org.infinispan.loaders.bucket.BucketBasedCacheStore;
import org.infinispan.loaders.file.FileCacheStoreConfig;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@CacheLoaderMetadata(configurationClass=FileCacheStoreConfig.class)
public class FileCacheStore
extends BucketBasedCacheStore {
    static final Log log = LogFactory.getLog(FileCacheStore.class);
    private static final boolean trace = log.isTraceEnabled();
    private int streamBufferSize;
    FileCacheStoreConfig config;
    File root;
    FileSync fileSync;

    public File getRoot() {
        return this.root;
    }

    @Override
    public void init(CacheLoaderConfig config, Cache<?, ?> cache, StreamingMarshaller m) throws CacheLoaderException {
        super.init(config, cache, m);
        this.config = (FileCacheStoreConfig)config;
    }

    @Override
    protected void loopOverBuckets(BucketBasedCacheStore.BucketHandler handler) throws CacheLoaderException {
        try {
            File[] listFiles;
            if (this.root != null && (listFiles = this.root.listFiles()) != null) {
                File bucketFile;
                Bucket bucket;
                File[] arr$ = listFiles;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && !handler.handle(bucket = this.loadBucket(bucketFile = arr$[i$])); ++i$) {
                }
            }
        }
        catch (InterruptedException ie) {
            if (log.isDebugEnabled()) {
                log.debug("Interrupted, so stop looping over buckets.");
            }
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fromStreamLockSafe(ObjectInput objectInput) throws CacheLoaderException {
        try {
            int numFiles = objectInput.readInt();
            byte[] buffer = new byte[this.streamBufferSize];
            int totalBytesRead = 0;
            for (int i = 0; i < numFiles; ++i) {
                String fName = (String)objectInput.readObject();
                int numBytes = objectInput.readInt();
                FileOutputStream fos = new FileOutputStream(this.root.getAbsolutePath() + File.separator + fName);
                BufferedOutputStream bos = new BufferedOutputStream(fos, this.streamBufferSize);
                try {
                    int bytesRead;
                    while (numBytes > totalBytesRead && (bytesRead = numBytes - totalBytesRead > this.streamBufferSize ? objectInput.read(buffer, 0, this.streamBufferSize) : objectInput.read(buffer, 0, numBytes - totalBytesRead)) != -1) {
                        totalBytesRead += bytesRead;
                        bos.write(buffer, 0, bytesRead);
                    }
                    bos.flush();
                    fos.flush();
                    totalBytesRead = 0;
                    continue;
                }
                finally {
                    this.safeClose(bos);
                    this.safeClose(fos);
                }
            }
        }
        catch (IOException e) {
            throw new CacheLoaderException("I/O error", e);
        }
        catch (ClassNotFoundException e) {
            throw new CacheLoaderException("Unexpected exception", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void toStreamLockSafe(ObjectOutput objectOutput) throws CacheLoaderException {
        try {
            File[] files = this.root.listFiles();
            if (files == null) {
                throw new CacheLoaderException("Root not directory or IO error occurred");
            }
            objectOutput.writeInt(files.length);
            byte[] buffer = new byte[this.streamBufferSize];
            for (File file : files) {
                int totalBytesRead = 0;
                BufferedInputStream bis = null;
                FileInputStream fileInStream = null;
                try {
                    int bytesRead;
                    if (trace) {
                        log.tracef("Opening file in %s", file);
                    }
                    fileInStream = new FileInputStream(file);
                    int sz = fileInStream.available();
                    bis = new BufferedInputStream(fileInStream);
                    objectOutput.writeObject(file.getName());
                    objectOutput.writeInt(sz);
                    while (sz > totalBytesRead && (bytesRead = bis.read(buffer, 0, this.streamBufferSize)) != -1) {
                        totalBytesRead += bytesRead;
                        objectOutput.write(buffer, 0, bytesRead);
                    }
                }
                catch (Throwable throwable) {
                    Util.close(bis);
                    Util.close(fileInStream);
                    throw throwable;
                }
                Util.close((Closeable)bis);
                Util.close((Closeable)fileInStream);
            }
        }
        catch (IOException e) {
            throw new CacheLoaderException("I/O exception while generating stream", e);
        }
    }

    @Override
    protected void clearLockSafe() throws CacheLoaderException {
        File[] toDelete = this.root.listFiles();
        if (toDelete == null) {
            return;
        }
        for (File f : toDelete) {
            if (this.deleteFile(f)) continue;
            log.problemsRemovingFile(f);
        }
    }

    @Override
    protected boolean supportsMultiThreadedPurge() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void purgeInternal() throws CacheLoaderException {
        if (trace) {
            log.trace("purgeInternal()");
        }
        if (this.acquireGlobalLock(false)) {
            try {
                File[] files = this.root.listFiles();
                if (files == null) {
                    throw new CacheLoaderException("Root not directory or IO error occurred");
                }
                for (final File bucketFile : files) {
                    if (this.multiThreadedPurge) {
                        this.purgerService.execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    Bucket bucket = FileCacheStore.this.loadBucket(bucketFile);
                                    if (bucket != null && bucket.removeExpiredEntries()) {
                                        FileCacheStore.this.updateBucket(bucket);
                                    }
                                }
                                catch (InterruptedException ie) {
                                    if (log.isDebugEnabled()) {
                                        log.debug("Interrupted, so finish work.");
                                    }
                                }
                                catch (CacheLoaderException e) {
                                    log.problemsPurgingFile(bucketFile, e);
                                }
                            }
                        });
                        continue;
                    }
                    Bucket bucket = this.loadBucket(bucketFile);
                    if (bucket == null || !bucket.removeExpiredEntries()) continue;
                    this.updateBucket(bucket);
                }
            }
            catch (InterruptedException ie) {
                if (log.isDebugEnabled()) {
                    log.debug("Interrupted, so stop loading and finish with purging.");
                }
                Thread.currentThread().interrupt();
            }
            finally {
                this.releaseGlobalLock(false);
                if (trace) {
                    log.trace("Exit purgeInternal()");
                }
            }
        } else {
            log.unableToAcquireLockToPurgeStore();
        }
    }

    @Override
    protected Bucket loadBucket(Integer hash) throws CacheLoaderException {
        try {
            return this.loadBucket(new File(this.root, String.valueOf(hash)));
        }
        catch (InterruptedException ie) {
            if (log.isDebugEnabled()) {
                log.debug("Interrupted, so stop loading bucket and return null.");
            }
            Thread.currentThread().interrupt();
            return null;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Bucket loadBucket(File bucketFile) throws CacheLoaderException, InterruptedException {
        Bucket bucket = null;
        if (bucketFile.exists()) {
            if (trace) {
                log.trace("Found bucket file: '" + bucketFile + "'");
            }
            FileInputStream is = null;
            try {
                this.fileSync.flush(bucketFile);
                is = new FileInputStream(bucketFile);
                bucket = (Bucket)this.objectFromInputStreamInReentrantMode(is);
            }
            catch (InterruptedException ie) {
                try {
                    throw ie;
                    catch (Exception e) {
                        log.errorReadingFromFile(bucketFile.getAbsoluteFile(), e);
                        throw new CacheLoaderException("Error while reading from file", e);
                    }
                }
                catch (Throwable throwable) {
                    this.safeClose(is);
                    throw throwable;
                }
            }
            this.safeClose(is);
        }
        if (bucket != null) {
            bucket.setBucketId(bucketFile.getName());
        }
        return bucket;
    }

    @Override
    public void updateBucket(Bucket b) throws CacheLoaderException {
        File f = new File(this.root, b.getBucketIdAsString());
        if (f.exists()) {
            if (!this.purgeFile(f)) {
                log.problemsRemovingFile(f);
            }
        } else if (trace) {
            log.tracef("Successfully deleted file: '%s'", f.getName());
        }
        if (!b.getEntries().isEmpty()) {
            try {
                byte[] bytes = this.marshaller.objectToByteBuffer(b);
                this.fileSync.write(bytes, f);
            }
            catch (IOException ex) {
                log.errorSavingBucket(b, ex);
                throw new CacheLoaderException(ex);
            }
            catch (InterruptedException ie) {
                if (trace) {
                    log.trace("Interrupted while marshalling a bucket");
                }
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public Class<? extends CacheLoaderConfig> getConfigurationClass() {
        return FileCacheStoreConfig.class;
    }

    @Override
    public void start() throws CacheLoaderException {
        super.start();
        String location = this.config.getLocation();
        if (location == null || location.trim().length() == 0) {
            location = "Infinispan-FileCacheStore";
        }
        location = location + File.separator + this.cache.getName();
        this.root = new File(location);
        if (!this.root.exists() && !this.root.mkdirs()) {
            log.problemsCreatingDirectory(this.root);
        }
        if (!this.root.exists()) {
            throw new ConfigurationException("Directory " + this.root.getAbsolutePath() + " does not exist and cannot be created!");
        }
        this.streamBufferSize = this.config.getStreamBufferSize();
        switch (this.config.getFsyncMode()) {
            case DEFAULT: {
                this.fileSync = new BufferedFileSync();
                break;
            }
            case PER_WRITE: {
                this.fileSync = new PerWriteFileSync();
                break;
            }
            case PERIODIC: {
                this.fileSync = new PeriodicFileSync(this.config.getFsyncInterval());
            }
        }
    }

    @Override
    public void stop() throws CacheLoaderException {
        super.stop();
        this.fileSync.stop();
    }

    public Bucket loadBucketContainingKey(String key) throws CacheLoaderException {
        return this.loadBucket(key.hashCode());
    }

    private boolean deleteFile(File f) {
        if (trace) {
            log.tracef("Really delete file %s", f);
        }
        return f.delete();
    }

    private boolean purgeFile(File f) {
        if (trace) {
            log.tracef("Really clear file %s", f);
        }
        try {
            this.fileSync.purge(f);
            return true;
        }
        catch (IOException e) {
            if (trace) {
                log.trace("Error encountered while clearing file: " + f, e);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object objectFromInputStreamInReentrantMode(InputStream is) throws IOException, ClassNotFoundException, InterruptedException {
        int len = is.available();
        Object o = null;
        if (len != 0) {
            int bytesRead;
            ExposedByteArrayOutputStream bytes = new ExposedByteArrayOutputStream(len);
            byte[] buf = new byte[Math.min(len, 1024)];
            while ((bytesRead = is.read(buf, 0, buf.length)) != -1) {
                bytes.write(buf, 0, bytesRead);
            }
            is = new ByteArrayInputStream(bytes.getRawBuffer(), 0, bytes.size());
            ObjectInput unmarshaller = this.marshaller.startObjectInput(is, true);
            try {
                o = this.marshaller.objectFromObjectStream(unmarshaller);
            }
            finally {
                this.marshaller.finishObjectInput(unmarshaller);
            }
        }
        return o;
    }

    private class PerWriteFileSync
    implements FileSync {
        private PerWriteFileSync() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] bytes, File f) throws IOException {
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(f);
                fos.write(bytes);
                fos.flush();
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
            }
        }

        @Override
        public void flush(File f) throws IOException {
        }

        @Override
        public void purge(File f) throws IOException {
            f.delete();
        }

        @Override
        public void stop() {
        }
    }

    private class PeriodicFileSync
    extends BufferedFileSync {
        private final ScheduledExecutorService executor;
        protected final ConcurrentMap<String, IOException> flushErrors;

        private PeriodicFileSync(long interval) {
            this.executor = Executors.newSingleThreadScheduledExecutor();
            this.flushErrors = new ConcurrentHashMap<String, IOException>();
            this.executor.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    for (Map.Entry entry : PeriodicFileSync.this.streams.entrySet()) {
                        if (trace) {
                            log.tracef("Flushing channel in %s", entry.getKey());
                        }
                        FileChannel channel = (FileChannel)entry.getValue();
                        try {
                            channel.force(true);
                        }
                        catch (IOException e) {
                            if (trace) {
                                log.tracef(e, "Error flushing output stream for %s", entry.getKey());
                            }
                            PeriodicFileSync.this.flushErrors.putIfAbsent((String)entry.getKey(), e);
                            Util.close((Closeable)channel);
                        }
                    }
                }
            }, interval, interval, TimeUnit.MILLISECONDS);
        }

        @Override
        public void write(byte[] bytes, File f) throws IOException {
            String path = f.getPath();
            IOException error = (IOException)this.flushErrors.get(path);
            if (error != null) {
                throw new IOException(String.format("Periodic flush of channel for %s failed", path), error);
            }
            super.write(bytes, f);
        }

        @Override
        public void stop() {
            this.executor.shutdown();
            super.stop();
        }
    }

    private class BufferedFileSync
    implements FileSync {
        protected final ConcurrentMap<String, FileChannel> streams = new ConcurrentHashMap<String, FileChannel>();

        private BufferedFileSync() {
        }

        @Override
        public void write(byte[] bytes, File f) throws IOException {
            String path = f.getPath();
            FileChannel channel = (FileChannel)this.streams.get(path);
            if (channel == null) {
                channel = this.createChannel(f);
                this.streams.putIfAbsent(path, channel);
            } else if (!f.exists()) {
                f.createNewFile();
                FileChannel oldChannel = channel;
                channel = this.createChannel(f);
                this.streams.replace(path, oldChannel, channel);
            }
            channel.write(ByteBuffer.wrap(bytes));
        }

        private FileChannel createChannel(File f) throws FileNotFoundException {
            return new RandomAccessFile(f, "rw").getChannel();
        }

        @Override
        public void flush(File f) throws IOException {
            FileChannel channel = (FileChannel)this.streams.get(f.getPath());
            if (channel != null) {
                channel.force(true);
            }
        }

        @Override
        public void purge(File f) throws IOException {
            FileChannel channel = (FileChannel)this.streams.get(f.getPath());
            channel.truncate(0L);
            channel.position(0L);
        }

        @Override
        public void stop() {
            for (FileChannel channel : this.streams.values()) {
                Util.close((Closeable)channel);
            }
            this.streams.clear();
        }
    }

    private static interface FileSync {
        public void write(byte[] var1, File var2) throws IOException;

        public void flush(File var1) throws IOException;

        public void purge(File var1) throws IOException;

        public void stop();
    }
}

