/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionSynchronizationRegistry;
import org.infinispan.CacheException;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.config.Configuration;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.infinispan.remoting.MembershipArithmetic;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.transaction.RemoteTransaction;
import org.infinispan.transaction.TransactionCoordinator;
import org.infinispan.transaction.synchronization.SyncLocalTransaction;
import org.infinispan.transaction.synchronization.SynchronizationAdapter;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.TransactionFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TransactionTable {
    private static final Log log = LogFactory.getLog(TransactionTable.class);
    private static boolean trace = log.isTraceEnabled();
    protected final ConcurrentMap<Transaction, LocalTransaction> localTransactions = new ConcurrentHashMap<Transaction, LocalTransaction>();
    protected final ConcurrentMap<GlobalTransaction, RemoteTransaction> remoteTransactions = new ConcurrentHashMap<GlobalTransaction, RemoteTransaction>();
    private final Object listener = new StaleTransactionCleanup();
    protected Configuration configuration;
    protected InvocationContextContainer icc;
    protected TransactionCoordinator txCoordinator;
    protected TransactionFactory txFactory;
    private InterceptorChain invoker;
    private CacheNotifier notifier;
    private RpcManager rpcManager;
    private ExecutorService lockBreakingService;
    private EmbeddedCacheManager cm;
    private TransactionSynchronizationRegistry transactionSynchronizationRegistry;

    @Inject
    public void initialize(RpcManager rpcManager, Configuration configuration, InvocationContextContainer icc, InterceptorChain invoker, CacheNotifier notifier, TransactionFactory gtf, EmbeddedCacheManager cm, TransactionCoordinator txCoordinator, TransactionSynchronizationRegistry transactionSynchronizationRegistry) {
        this.rpcManager = rpcManager;
        this.configuration = configuration;
        this.icc = icc;
        this.invoker = invoker;
        this.notifier = notifier;
        this.txFactory = gtf;
        this.cm = cm;
        this.txCoordinator = txCoordinator;
        this.transactionSynchronizationRegistry = transactionSynchronizationRegistry;
    }

    @Start
    private void start() {
        this.lockBreakingService = Executors.newFixedThreadPool(1);
        this.cm.addListener(this.listener);
        this.notifier.addListener(this.listener);
    }

    @Stop
    private void stop() {
        this.notifier.removeListener(this.listener);
        this.cm.removeListener(this.listener);
        this.lockBreakingService.shutdownNow();
        if (trace) {
            log.tracef("Wait for on-going transactions to finish for %d seconds.", TimeUnit.MILLISECONDS.toSeconds(this.configuration.getCacheStopTimeout()));
        }
        long failTime = System.currentTimeMillis() + (long)this.configuration.getCacheStopTimeout();
        boolean txsOnGoing = this.areTxsOnGoing();
        while (txsOnGoing && System.currentTimeMillis() < failTime) {
            try {
                Thread.sleep(100L);
                txsOnGoing = this.areTxsOnGoing();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                if (!trace) continue;
                log.tracef("Interrupted waiting for on-going transactions to finish. localTransactions=%s, remoteTransactions%s", this.localTransactions, this.remoteTransactions);
            }
        }
        if (txsOnGoing) {
            log.unfinishedTransactionsRemain(this.localTransactions, this.remoteTransactions);
        } else if (trace) {
            log.trace("All transactions terminated");
        }
    }

    private boolean areTxsOnGoing() {
        return !this.localTransactions.isEmpty() || !this.remoteTransactions.isEmpty();
    }

    public Set<Object> getLockedKeysForRemoteTransaction(GlobalTransaction gtx) {
        RemoteTransaction transaction = (RemoteTransaction)this.remoteTransactions.get(gtx);
        if (transaction == null) {
            return Collections.emptySet();
        }
        return transaction.getLockedKeys();
    }

    public void remoteTransactionPrepared(GlobalTransaction gtx) {
    }

    public void localTransactionPrepared(LocalTransaction localTransaction) {
    }

    public void enlist(Transaction transaction, LocalTransaction localTransaction) {
        if (!localTransaction.isEnlisted()) {
            SynchronizationAdapter sync = new SynchronizationAdapter(localTransaction, this.txCoordinator);
            if (this.transactionSynchronizationRegistry != null) {
                try {
                    this.transactionSynchronizationRegistry.registerInterposedSynchronization((Synchronization)sync);
                }
                catch (Exception e) {
                    log.failedSynchronizationRegistration(e);
                    throw new CacheException(e);
                }
            }
            try {
                transaction.registerSynchronization((Synchronization)sync);
            }
            catch (Exception e) {
                log.failedSynchronizationRegistration(e);
                throw new CacheException(e);
            }
            ((SyncLocalTransaction)localTransaction).setEnlisted(true);
        }
    }

    public void failureCompletingTransaction(Transaction tx) {
        this.removeLocalTransaction((LocalTransaction)this.localTransactions.get(tx));
    }

    public boolean containsLocalTx(Transaction tx) {
        return tx != null && this.localTransactions.containsKey(tx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateStateOnNodesLeaving(Collection<Address> leavers) {
        HashSet<GlobalTransaction> toKill = new HashSet<GlobalTransaction>();
        for (GlobalTransaction gt : this.remoteTransactions.keySet()) {
            if (!leavers.contains(gt.getAddress())) continue;
            toKill.add(gt);
        }
        if (trace) {
            if (toKill.isEmpty()) {
                log.tracef("No global transactions pertain to originator(s) %s who have left the cluster.", leavers);
            } else {
                log.tracef("%s global transactions pertain to leavers list %s and need to be killed", toKill.size(), leavers);
            }
        }
        for (GlobalTransaction gtx : toKill) {
            if (trace) {
                log.tracef("Killing %s", gtx);
            }
            RollbackCommand rc = new RollbackCommand(gtx);
            rc.init(this.invoker, this.icc, this);
            try {
                rc.perform(null);
                if (!trace) continue;
                log.tracef("Rollback of %s complete.", gtx);
            }
            catch (Throwable e) {
                log.unableToRollbackGlobalTx(gtx, e);
            }
            finally {
                this.removeRemoteTransaction(gtx);
            }
        }
        if (trace) {
            log.trace("Completed cleaning stale locks.");
        }
    }

    public RemoteTransaction getRemoteTransaction(GlobalTransaction txId) {
        return (RemoteTransaction)this.remoteTransactions.get(txId);
    }

    public RemoteTransaction createRemoteTransaction(GlobalTransaction globalTx, WriteCommand[] modifications) {
        RemoteTransaction remoteTransaction = this.txFactory.newRemoteTransaction(modifications, globalTx);
        this.registerRemoteTransaction(globalTx, remoteTransaction);
        return remoteTransaction;
    }

    public RemoteTransaction createRemoteTransaction(GlobalTransaction globalTx) {
        RemoteTransaction remoteTransaction = this.txFactory.newRemoteTransaction(globalTx);
        this.registerRemoteTransaction(globalTx, remoteTransaction);
        return remoteTransaction;
    }

    private void registerRemoteTransaction(GlobalTransaction gtx, RemoteTransaction rtx) {
        RemoteTransaction transaction = this.remoteTransactions.put(gtx, rtx);
        if (transaction != null) {
            log.remoteTxAlreadyRegistered();
            throw new IllegalStateException("A remote transaction with the given id was already registered!!!");
        }
        if (trace) {
            log.trace("Created and registered remote transaction " + rtx);
        }
    }

    public LocalTransaction getOrCreateLocalTransaction(Transaction transaction, InvocationContext ctx) {
        LocalTransaction current = (LocalTransaction)this.localTransactions.get(transaction);
        if (current == null) {
            Address localAddress = this.rpcManager != null ? this.rpcManager.getTransport().getAddress() : null;
            GlobalTransaction tx = this.txFactory.newGlobalTransaction(localAddress, false);
            if (trace) {
                log.tracef("Created a new GlobalTransaction %s", tx);
            }
            current = this.txFactory.newLocalTransaction(transaction, tx);
            this.localTransactions.put(transaction, current);
            this.notifier.notifyTransactionRegistered(tx, ctx);
        }
        return current;
    }

    public boolean removeLocalTransaction(LocalTransaction localTransaction) {
        return localTransaction != null && this.localTransactions.remove(localTransaction.getTransaction()) != null;
    }

    public void remoteTransactionCompleted(GlobalTransaction gtx, boolean committed) {
        RemoteTransaction remove = (RemoteTransaction)this.remoteTransactions.remove(gtx);
        if (log.isTraceEnabled()) {
            log.tracef("Removing remote transaction as it is completed: %s", remove);
        }
    }

    private boolean removeRemoteTransaction(GlobalTransaction txId) {
        boolean existed;
        boolean bl = existed = this.remoteTransactions.remove(txId) != null;
        if (trace) {
            log.tracef("Removed %s from transaction table. Transaction existed? %b", txId, existed);
        }
        return existed;
    }

    public int getRemoteTxCount() {
        return this.remoteTransactions.size();
    }

    public int getLocalTxCount() {
        return this.localTransactions.size();
    }

    public LocalTransaction getLocalTransaction(Transaction tx) {
        return (LocalTransaction)this.localTransactions.get(tx);
    }

    public boolean containRemoteTx(GlobalTransaction globalTransaction) {
        return this.remoteTransactions.containsKey(globalTransaction);
    }

    public Collection<RemoteTransaction> getRemoteTransactions() {
        return this.remoteTransactions.values();
    }

    @Listener
    public class StaleTransactionCleanup {
        @ViewChanged
        public void onViewChange(ViewChangedEvent vce) {
            List<Address> leavers = MembershipArithmetic.getMembersLeft(vce.getOldMembers(), vce.getNewMembers());
            if (!leavers.isEmpty()) {
                if (trace) {
                    log.tracef("Saw %d leavers - kicking off a lock breaking task", leavers.size());
                }
                this.cleanTxForWhichTheOwnerLeft(leavers);
            }
        }

        @TopologyChanged
        public void onTopologyChange(TopologyChangedEvent tce) {
            Set<Address> joiners;
            Set<Address> newMembers;
            if (tce.isPre()) {
                return;
            }
            ConsistentHash chNew = tce.getConsistentHashAtEnd();
            Set<Address> oldMembers = tce.getConsistentHashAtStart().getCaches();
            Set<Address> leavers = MembershipArithmetic.getMembersLeft(oldMembers, newMembers = tce.getConsistentHashAtEnd().getCaches());
            if (!leavers.isEmpty() && TransactionTable.this.configuration.isEagerLockingSingleNodeInUse()) {
                for (LocalTransaction localTx : TransactionTable.this.localTransactions.values()) {
                    if (!localTx.hasRemoteLocksAcquired(leavers)) continue;
                    localTx.markForRollback(true);
                    if (!trace) continue;
                    log.tracef("Marked local transaction for rollback, as it had acquired locks on a node that has left the cluster: %s", localTx);
                }
            }
            if (!(joiners = MembershipArithmetic.getMembersJoined(oldMembers, newMembers)).isEmpty() && TransactionTable.this.configuration.isEagerLockingSingleNodeInUse()) {
                block1: for (LocalTransaction localTx : TransactionTable.this.localTransactions.values()) {
                    for (Object k : localTx.getAffectedKeys()) {
                        Address newMainOwner = chNew.locate(k, 1).get(0);
                        if (!joiners.contains(newMainOwner)) continue;
                        localTx.markForRollback(true);
                        if (!trace) continue block1;
                        log.tracef("Marked local transaction for rollback, as the main data owner has changed %s", localTx);
                        continue block1;
                    }
                }
            }
        }

        private void cleanTxForWhichTheOwnerLeft(final Collection<Address> leavers) {
            try {
                TransactionTable.this.lockBreakingService.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            TransactionTable.this.updateStateOnNodesLeaving(leavers);
                        }
                        catch (Exception e) {
                            log.error("Exception whilst updating state", e);
                        }
                    }
                });
            }
            catch (RejectedExecutionException ree) {
                log.debug("Unable to submit task to executor", ree);
            }
        }
    }
}

