/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.pool.threadlocal;

import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.ejb3.pool.AbstractPool;
import org.jboss.ejb3.pool.Pool;
import org.jboss.ejb3.pool.StatelessObjectFactory;
import org.jboss.ejb3.pool.infinite.InfinitePool;
import org.jboss.ejb3.pool.threadlocal.WeakThreadLocal;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadLocalPool<T>
extends AbstractPool<T>
implements Pool<T> {
    private static final Logger log = Logger.getLogger(ThreadLocalPool.class);
    protected final Pool<T> delegate;
    protected WeakThreadLocal<T> pool = new WeakThreadLocal();
    private AtomicInteger inUse = new AtomicInteger();

    public ThreadLocalPool(StatelessObjectFactory<T> factory) {
        super(factory);
        this.delegate = new InfinitePool<T>(factory);
    }

    @Override
    protected T create() {
        return this.delegate.get();
    }

    @Override
    public void discard(T obj) {
        this.delegate.discard(obj);
        this.inUse.decrementAndGet();
    }

    @Override
    public T get() {
        T obj = this.pool.get();
        if (obj != null) {
            this.pool.set(null);
        } else {
            obj = this.delegate.get();
        }
        this.inUse.incrementAndGet();
        return obj;
    }

    @Override
    public void release(T obj) {
        if (this.pool.get() == null) {
            this.pool.set(obj);
        } else {
            this.delegate.release(obj);
        }
        this.inUse.decrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCurrentSize() {
        int size;
        Pool<T> pool = this.delegate;
        synchronized (pool) {
            size = this.delegate.getCreateCount() - this.delegate.getRemoveCount();
        }
        return size;
    }

    @Override
    public int getAvailableCount() {
        return this.getMaxSize() - this.inUse.get();
    }

    @Override
    public int getCreateCount() {
        return this.delegate.getCreateCount();
    }

    @Override
    public int getMaxSize() {
        return this.getCurrentSize();
    }

    @Override
    public int getRemoveCount() {
        return this.delegate.getRemoveCount();
    }

    @Override
    public void setMaxSize(int maxSize) {
        log.warn((Object)"EJBTHREE-1703: setting a max size on ThreadlocalPool is bogus");
    }

    @Override
    public void start() {
        this.delegate.start();
    }

    @Override
    public void stop() {
        log.trace((Object)"destroying pool");
        this.delegate.stop();
        this.pool.remove();
        this.inUse.getAndSet(0);
    }
}

