/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.internal.bridge;

import org.hibernate.cache.CacheException;
import org.hibernate.cache.internal.bridge.BaseTransactionalDataRegionAdapter;
import org.hibernate.cache.internal.bridge.CollectionAccessStrategyAdapter;
import org.hibernate.cache.internal.bridge.OptimisticCacheSourceAdapter;
import org.hibernate.cache.spi.Cache;
import org.hibernate.cache.spi.CacheConcurrencyStrategy;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.NonstrictReadWriteCache;
import org.hibernate.cache.spi.OptimisticCache;
import org.hibernate.cache.spi.ReadOnlyCache;
import org.hibernate.cache.spi.ReadWriteCache;
import org.hibernate.cache.spi.TransactionalCache;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.CollectionRegionAccessStrategy;
import org.hibernate.cfg.Settings;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public class CollectionRegionAdapter
extends BaseTransactionalDataRegionAdapter
implements CollectionRegion {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)CollectionRegionAdapter.class.getName());

    public CollectionRegionAdapter(Cache underlyingCache, Settings settings, CacheDataDescription metadata) {
        super(underlyingCache, settings, metadata);
        if (underlyingCache instanceof OptimisticCache) {
            ((OptimisticCache)underlyingCache).setSource(new OptimisticCacheSourceAdapter(metadata));
        }
    }

    @Override
    public CollectionRegionAccessStrategy buildAccessStrategy(AccessType accessType) throws CacheException {
        CacheConcurrencyStrategy ccs;
        if (AccessType.READ_ONLY.equals((Object)accessType)) {
            if (this.metadata.isMutable()) {
                LOG.readOnlyCacheConfiguredForMutableCollection(this.getName());
            }
            ccs = new ReadOnlyCache();
        } else if (AccessType.READ_WRITE.equals((Object)accessType)) {
            ccs = new ReadWriteCache();
        } else if (AccessType.NONSTRICT_READ_WRITE.equals((Object)accessType)) {
            ccs = new NonstrictReadWriteCache();
        } else if (AccessType.TRANSACTIONAL.equals((Object)accessType)) {
            ccs = new TransactionalCache();
        } else {
            throw new IllegalArgumentException("unrecognized access strategy type [" + (Object)((Object)accessType) + "]");
        }
        ccs.setCache(this.underlyingCache);
        return new CollectionAccessStrategyAdapter(this, ccs, this.settings);
    }
}

