/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.entity;

import com.fasterxml.classmate.ResolvedTypeWithMembers;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.AccessType;
import javax.persistence.InheritanceType;
import org.hibernate.AnnotationException;
import org.hibernate.metamodel.source.annotations.JPADotNames;
import org.hibernate.metamodel.source.annotations.entity.ConfiguredClass;
import org.hibernate.metamodel.source.annotations.util.JandexHelper;
import org.hibernate.metamodel.source.annotations.util.ReflectionHelper;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;

public class ConfiguredClassHierarchy
implements Iterable<ConfiguredClass> {
    private final AccessType defaultAccessType;
    private final org.hibernate.metamodel.binding.InheritanceType inheritanceType;
    private final List<ConfiguredClass> configuredClasses;

    public static ConfiguredClassHierarchy create(List<ClassInfo> classes, ServiceRegistry serviceRegistry) {
        return new ConfiguredClassHierarchy(classes, serviceRegistry);
    }

    private ConfiguredClassHierarchy(List<ClassInfo> classes, ServiceRegistry serviceRegistry) {
        this.defaultAccessType = this.determineDefaultAccessType(classes);
        this.inheritanceType = this.determineInheritanceType(classes);
        ClassLoaderService classLoaderService = serviceRegistry.getService(ClassLoaderService.class);
        Class clazz = classLoaderService.classForName(classes.get(classes.size() - 1).name().toString());
        ResolvedTypeWithMembers resolvedMembers = ReflectionHelper.resolveMemberTypes(clazz);
        this.configuredClasses = new ArrayList<ConfiguredClass>();
        ConfiguredClass parent = null;
        for (ClassInfo info : classes) {
            ConfiguredClass configuredClass = new ConfiguredClass(info, parent, this.defaultAccessType, this.inheritanceType, serviceRegistry, resolvedMembers);
            this.configuredClasses.add(configuredClass);
            parent = configuredClass;
        }
    }

    public AccessType getDefaultAccessType() {
        return this.defaultAccessType;
    }

    public org.hibernate.metamodel.binding.InheritanceType getInheritanceType() {
        return this.inheritanceType;
    }

    @Override
    public Iterator<ConfiguredClass> iterator() {
        return this.configuredClasses.iterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ConfiguredClassHierarchy");
        sb.append("{defaultAccessType=").append(this.defaultAccessType);
        sb.append(", configuredClasses=").append(this.configuredClasses);
        sb.append('}');
        return sb.toString();
    }

    private AccessType determineDefaultAccessType(List<ClassInfo> classes) {
        AccessType accessType = null;
        for (ClassInfo info : classes) {
            List idAnnotations = (List)info.annotations().get(JPADotNames.ID);
            if (idAnnotations == null || idAnnotations.size() == 0) continue;
            accessType = this.processIdAnnotations(idAnnotations);
        }
        if (accessType == null) {
            return this.throwIdNotFoundAnnotationException(classes);
        }
        return accessType;
    }

    private AccessType processIdAnnotations(List<AnnotationInstance> idAnnotations) {
        AccessType accessType = null;
        for (AnnotationInstance annotation : idAnnotations) {
            AccessType tmpAccessType;
            if (annotation.target() instanceof FieldInfo) {
                tmpAccessType = AccessType.FIELD;
            } else if (annotation.target() instanceof MethodInfo) {
                tmpAccessType = AccessType.PROPERTY;
            } else {
                throw new AnnotationException("Invalid placement of @Id annotation");
            }
            if (accessType == null) {
                accessType = tmpAccessType;
                continue;
            }
            if (accessType.equals((Object)tmpAccessType)) continue;
            throw new AnnotationException("Inconsistent placement of @Id annotation within hierarchy ");
        }
        return accessType;
    }

    private org.hibernate.metamodel.binding.InheritanceType determineInheritanceType(List<ClassInfo> classes) {
        if (classes.size() == 1) {
            return org.hibernate.metamodel.binding.InheritanceType.NO_INHERITANCE;
        }
        org.hibernate.metamodel.binding.InheritanceType inheritanceType = null;
        for (ClassInfo info : classes) {
            AnnotationInstance inheritanceAnnotation = JandexHelper.getSingleAnnotation(info, JPADotNames.INHERITANCE);
            if (inheritanceAnnotation == null) continue;
            InheritanceType jpaInheritanceType = Enum.valueOf(InheritanceType.class, inheritanceAnnotation.value("strategy").asEnum());
            org.hibernate.metamodel.binding.InheritanceType tmpInheritanceType = org.hibernate.metamodel.binding.InheritanceType.get(jpaInheritanceType);
            if (tmpInheritanceType == null) {
                inheritanceType = org.hibernate.metamodel.binding.InheritanceType.SINGLE_TABLE;
            }
            if (inheritanceType == null) {
                inheritanceType = tmpInheritanceType;
                continue;
            }
            if (inheritanceType.equals((Object)tmpInheritanceType)) continue;
            throw new AnnotationException("Multiple incompatible instances of @Inheritance specified within classes " + this.hierarchyListString(classes));
        }
        if (inheritanceType == null) {
            inheritanceType = org.hibernate.metamodel.binding.InheritanceType.SINGLE_TABLE;
        }
        return inheritanceType;
    }

    private AccessType throwIdNotFoundAnnotationException(List<ClassInfo> classes) {
        StringBuilder builder = new StringBuilder();
        builder.append("Unable to determine identifier attribute for class hierarchy consisting of the classe(s) ");
        builder.append(this.hierarchyListString(classes));
        throw new AnnotationException(builder.toString());
    }

    private String hierarchyListString(List<ClassInfo> classes) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        int count = 0;
        for (ClassInfo info : classes) {
            builder.append(info.name().toString());
            if (count < classes.size() - 1) {
                builder.append(", ");
            }
            ++count;
        }
        builder.append("]");
        return builder.toString();
    }
}

