/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.xml.mocker;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.metamodel.source.annotation.xml.XMLAccessType;
import org.hibernate.metamodel.source.annotation.xml.XMLEmbeddable;
import org.hibernate.metamodel.source.annotation.xml.XMLEntity;
import org.hibernate.metamodel.source.annotation.xml.XMLEntityMappings;
import org.hibernate.metamodel.source.annotation.xml.XMLMappedSuperclass;
import org.hibernate.metamodel.source.annotation.xml.XMLPersistenceUnitDefaults;
import org.hibernate.metamodel.source.annotation.xml.XMLPersistenceUnitMetadata;
import org.hibernate.metamodel.source.annotations.xml.mocker.AbstractEntityObjectMocker;
import org.hibernate.metamodel.source.annotations.xml.mocker.EmbeddableMocker;
import org.hibernate.metamodel.source.annotations.xml.mocker.EntityMocker;
import org.hibernate.metamodel.source.annotations.xml.mocker.GlobalAnnotationMocker;
import org.hibernate.metamodel.source.annotations.xml.mocker.GlobalAnnotations;
import org.hibernate.metamodel.source.annotations.xml.mocker.IndexBuilder;
import org.hibernate.metamodel.source.annotations.xml.mocker.MappedSuperclassMocker;
import org.hibernate.metamodel.source.annotations.xml.mocker.PersistenceMetadataMocker;
import org.hibernate.service.ServiceRegistry;
import org.jboss.jandex.Index;
import org.jboss.logging.Logger;

public class EntityMappingsMocker {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)EntityMappingsMocker.class.getName());
    private final List<XMLEntityMappings> entityMappingsList;
    private Default globalDefaults;
    private final IndexBuilder indexBuilder;
    private final GlobalAnnotations globalAnnotations;

    public EntityMappingsMocker(List<XMLEntityMappings> entityMappingsList, Index index, ServiceRegistry serviceRegistry) {
        this.entityMappingsList = entityMappingsList;
        this.indexBuilder = new IndexBuilder(index, serviceRegistry);
        this.globalAnnotations = new GlobalAnnotations();
    }

    public Index mockNewIndex() {
        this.processPersistenceUnitMetadata(this.entityMappingsList);
        this.processEntityMappings(this.entityMappingsList);
        this.processGlobalAnnotations();
        return this.indexBuilder.build(this.globalDefaults);
    }

    private void processPersistenceUnitMetadata(List<XMLEntityMappings> entityMappingsList) {
        for (XMLEntityMappings entityMappings : entityMappingsList) {
            XMLPersistenceUnitDefaults pud;
            XMLPersistenceUnitMetadata pum = entityMappings.getPersistenceUnitMetadata();
            if (this.globalDefaults != null) {
                LOG.duplicateMetadata();
                return;
            }
            if (pum == null) continue;
            this.globalDefaults = new Default();
            if (pum.getXmlMappingMetadataComplete() != null) {
                this.globalDefaults.setMetadataComplete(true);
                this.indexBuilder.mappingMetadataComplete();
            }
            if ((pud = pum.getPersistenceUnitDefaults()) == null) {
                return;
            }
            this.globalDefaults.setSchema(pud.getSchema());
            this.globalDefaults.setCatalog(pud.getCatalog());
            this.globalDefaults.setCascadePersist(pud.getCascadePersist() != null);
            new PersistenceMetadataMocker(this.indexBuilder, pud).process();
        }
    }

    private void processEntityMappings(List<XMLEntityMappings> entityMappingsList) {
        ArrayList<AbstractEntityObjectMocker> mockerList = new ArrayList<AbstractEntityObjectMocker>();
        for (XMLEntityMappings entityMappings : entityMappingsList) {
            AbstractEntityObjectMocker mocker;
            Default defaults = this.getEntityMappingsDefaults(entityMappings);
            this.globalAnnotations.collectGlobalMappings(entityMappings, defaults);
            for (XMLMappedSuperclass mappedSuperclass : entityMappings.getMappedSuperclass()) {
                mocker = new MappedSuperclassMocker(this.indexBuilder, mappedSuperclass, defaults);
                mockerList.add(mocker);
                mocker.preProcess();
            }
            for (XMLEmbeddable embeddable : entityMappings.getEmbeddable()) {
                mocker = new EmbeddableMocker(this.indexBuilder, embeddable, defaults);
                mockerList.add(mocker);
                mocker.preProcess();
            }
            for (XMLEntity entity : entityMappings.getEntity()) {
                this.globalAnnotations.collectGlobalMappings(entity, defaults);
                mocker = new EntityMocker(this.indexBuilder, entity, defaults);
                mockerList.add(mocker);
                mocker.preProcess();
            }
        }
        for (AbstractEntityObjectMocker mocker : mockerList) {
            mocker.process();
        }
    }

    private void processGlobalAnnotations() {
        if (this.globalAnnotations.hasGlobalConfiguration()) {
            this.indexBuilder.collectGlobalConfigurationFromIndex(this.globalAnnotations);
            new GlobalAnnotationMocker(this.indexBuilder, this.globalAnnotations).process();
        }
    }

    private Default getEntityMappingsDefaults(XMLEntityMappings entityMappings) {
        Default entityMappingDefault = new Default();
        entityMappingDefault.setPackageName(entityMappings.getPackage());
        entityMappingDefault.setSchema(entityMappings.getSchema());
        entityMappingDefault.setCatalog(entityMappings.getCatalog());
        entityMappingDefault.setAccess(entityMappings.getAccess());
        Default defaults = new Default();
        defaults.override(this.globalDefaults);
        defaults.override(entityMappingDefault);
        return defaults;
    }

    public static class Default
    implements Serializable {
        private XMLAccessType access;
        private String packageName;
        private String schema;
        private String catalog;
        private Boolean metadataComplete;
        private Boolean cascadePersist;

        public XMLAccessType getAccess() {
            return this.access;
        }

        void setAccess(XMLAccessType access) {
            this.access = access;
        }

        public String getCatalog() {
            return this.catalog;
        }

        void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        public String getPackageName() {
            return this.packageName;
        }

        void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public String getSchema() {
            return this.schema;
        }

        void setSchema(String schema) {
            this.schema = schema;
        }

        public Boolean isMetadataComplete() {
            return this.metadataComplete;
        }

        void setMetadataComplete(Boolean metadataComplete) {
            this.metadataComplete = metadataComplete;
        }

        public Boolean isCascadePersist() {
            return this.cascadePersist;
        }

        void setCascadePersist(Boolean cascadePersist) {
            this.cascadePersist = cascadePersist;
        }

        void override(Default globalDefault) {
            if (globalDefault != null) {
                if (globalDefault.getAccess() != null) {
                    this.access = globalDefault.getAccess();
                }
                if (globalDefault.getPackageName() != null) {
                    this.packageName = globalDefault.getPackageName();
                }
                if (globalDefault.getSchema() != null) {
                    this.schema = globalDefault.getSchema();
                }
                if (globalDefault.getCatalog() != null) {
                    this.catalog = globalDefault.getCatalog();
                }
                if (globalDefault.isCascadePersist() != null) {
                    this.cascadePersist = globalDefault.isCascadePersist();
                }
                if (globalDefault.isMetadataComplete() != null) {
                    this.metadataComplete = globalDefault.isMetadataComplete();
                }
            }
        }
    }
}

