/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm.state.binding;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.MappingException;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.mapping.PropertyGeneration;
import org.hibernate.metamodel.binding.CascadeType;
import org.hibernate.metamodel.binding.state.AttributeBindingState;
import org.hibernate.metamodel.source.hbm.util.MappingHelper;
import org.hibernate.metamodel.source.spi.BindingContext;
import org.hibernate.metamodel.source.spi.MappingDefaults;
import org.hibernate.metamodel.source.spi.MetaAttributeContext;

public abstract class AbstractHbmAttributeBindingState
implements AttributeBindingState {
    private final String ownerClassName;
    private final String attributeName;
    private final BindingContext bindingContext;
    private final String nodeName;
    private final String accessorName;
    private final boolean isOptimisticLockable;
    private final MetaAttributeContext metaAttributeContext;

    public AbstractHbmAttributeBindingState(String ownerClassName, String attributeName, BindingContext bindingContext, String nodeName, MetaAttributeContext metaAttributeContext, String accessorName, boolean isOptimisticLockable) {
        if (attributeName == null) {
            throw new MappingException("Attribute name cannot be null.");
        }
        this.ownerClassName = ownerClassName;
        this.attributeName = attributeName;
        this.bindingContext = bindingContext;
        this.nodeName = nodeName;
        this.metaAttributeContext = metaAttributeContext;
        this.accessorName = accessorName;
        this.isOptimisticLockable = isOptimisticLockable;
    }

    protected String getOwnerClassName() {
        return this.ownerClassName;
    }

    protected Set<CascadeType> determineCascadeTypes(String cascade) {
        String commaSeparatedCascades = MappingHelper.getStringValue(cascade, this.getBindingContext().getMappingDefaults().getCascadeStyle());
        Set<String> cascades = MappingHelper.getStringValueTokens(commaSeparatedCascades, ",");
        HashSet<CascadeType> cascadeTypes = new HashSet<CascadeType>(cascades.size());
        for (String s : cascades) {
            CascadeType cascadeType = CascadeType.getCascadeType(s);
            if (cascadeType == null) {
                throw new MappingException("Invalid cascading option " + s);
            }
            cascadeTypes.add(cascadeType);
        }
        return cascadeTypes;
    }

    protected final String getTypeNameByReflection() {
        Class ownerClass = MappingHelper.classForName(this.ownerClassName, this.bindingContext.getServiceRegistry());
        return ReflectHelper.reflectedPropertyClass(ownerClass, this.attributeName).getName();
    }

    @Override
    public String getAttributeName() {
        return this.attributeName;
    }

    public BindingContext getBindingContext() {
        return this.bindingContext;
    }

    @Deprecated
    protected final MappingDefaults getDefaults() {
        return this.getBindingContext().getMappingDefaults();
    }

    @Override
    public final String getPropertyAccessorName() {
        return this.accessorName;
    }

    @Override
    public final boolean isAlternateUniqueKey() {
        return false;
    }

    @Override
    public final boolean isOptimisticLockable() {
        return this.isOptimisticLockable;
    }

    @Override
    public final String getNodeName() {
        return this.nodeName == null ? this.getAttributeName() : this.nodeName;
    }

    @Override
    public MetaAttributeContext getMetaAttributeContext() {
        return this.metaAttributeContext;
    }

    public PropertyGeneration getPropertyGeneration() {
        return PropertyGeneration.NEVER;
    }

    public boolean isKeyCascadeDeleteEnabled() {
        return false;
    }

    public String getUnsavedValue() {
        return null;
    }

    @Override
    public Map<String, String> getTypeParameters() {
        return null;
    }
}

