/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm.state.binding;

import java.util.Set;
import org.hibernate.FetchMode;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.metamodel.binding.CascadeType;
import org.hibernate.metamodel.binding.state.ManyToOneAttributeBindingState;
import org.hibernate.metamodel.source.hbm.HbmHelper;
import org.hibernate.metamodel.source.hbm.state.binding.AbstractHbmAttributeBindingState;
import org.hibernate.metamodel.source.hbm.util.MappingHelper;
import org.hibernate.metamodel.source.hbm.xml.mapping.XMLManyToOneElement;
import org.hibernate.metamodel.source.spi.BindingContext;
import org.hibernate.metamodel.source.spi.MetaAttributeContext;

public class HbmManyToOneAttributeBindingState
extends AbstractHbmAttributeBindingState
implements ManyToOneAttributeBindingState {
    private final FetchMode fetchMode;
    private final boolean isUnwrapProxy;
    private final boolean isLazy;
    private final Set<CascadeType> cascadeTypes;
    private final boolean isEmbedded;
    private final String referencedPropertyName;
    private final String referencedEntityName;
    private final boolean ignoreNotFound;
    private final boolean isInsertable;
    private final boolean isUpdateable;

    public HbmManyToOneAttributeBindingState(String ownerClassName, BindingContext bindingContext, MetaAttributeContext parentMetaAttributeContext, XMLManyToOneElement manyToOne) {
        super(ownerClassName, manyToOne.getName(), bindingContext, manyToOne.getNode(), HbmHelper.extractMetaAttributeContext(manyToOne.getMeta(), parentMetaAttributeContext), HbmHelper.getPropertyAccessorName(manyToOne.getAccess(), manyToOne.isEmbedXml(), bindingContext.getMappingDefaults().getPropertyAccessorName()), manyToOne.isOptimisticLock());
        this.fetchMode = HbmManyToOneAttributeBindingState.getFetchMode(manyToOne);
        this.isUnwrapProxy = manyToOne.getLazy() != null && "no-proxy".equals(manyToOne.getLazy().value());
        this.isLazy = manyToOne.getLazy() == null || this.isUnwrapProxy || "proxy".equals(manyToOne.getLazy().value());
        this.cascadeTypes = this.determineCascadeTypes(manyToOne.getCascade());
        this.isEmbedded = manyToOne.isEmbedXml();
        this.referencedEntityName = HbmManyToOneAttributeBindingState.getReferencedEntityName(ownerClassName, manyToOne, bindingContext);
        this.referencedPropertyName = manyToOne.getPropertyRef();
        this.ignoreNotFound = "ignore".equals(manyToOne.getNotFound().value());
        this.isInsertable = manyToOne.isInsert();
        this.isUpdateable = manyToOne.isUpdate();
    }

    protected boolean isEmbedded() {
        return this.isEmbedded;
    }

    private static String getReferencedEntityName(String ownerClassName, XMLManyToOneElement manyToOne, BindingContext bindingContext) {
        String referencedEntityName;
        if (manyToOne.getEntityName() != null) {
            referencedEntityName = manyToOne.getEntityName();
        } else if (manyToOne.getClazz() != null) {
            referencedEntityName = HbmHelper.getClassName(manyToOne.getClazz(), bindingContext.getMappingDefaults().getPackageName());
        } else {
            Class ownerClazz = MappingHelper.classForName(ownerClassName, bindingContext.getServiceRegistry());
            referencedEntityName = ReflectHelper.reflectedPropertyClass(ownerClazz, manyToOne.getName()).getName();
        }
        return referencedEntityName;
    }

    private static FetchMode getFetchMode(XMLManyToOneElement manyToOne) {
        FetchMode fetchMode;
        if (manyToOne.getFetch() != null) {
            fetchMode = "join".equals(manyToOne.getFetch().value()) ? FetchMode.JOIN : FetchMode.SELECT;
        } else {
            String jfNodeValue;
            String string = jfNodeValue = manyToOne.getOuterJoin() == null ? "auto" : manyToOne.getOuterJoin().value();
            fetchMode = "auto".equals(jfNodeValue) ? FetchMode.DEFAULT : ("true".equals(jfNodeValue) ? FetchMode.JOIN : FetchMode.SELECT);
        }
        return fetchMode;
    }

    @Override
    public String getTypeName() {
        return this.referencedEntityName;
    }

    public FetchMode getFetchMode() {
        return this.fetchMode;
    }

    @Override
    public boolean isLazy() {
        return this.isLazy;
    }

    @Override
    public boolean isUnwrapProxy() {
        return this.isUnwrapProxy;
    }

    @Override
    public String getReferencedAttributeName() {
        return this.referencedPropertyName;
    }

    @Override
    public String getReferencedEntityName() {
        return this.referencedEntityName;
    }

    @Override
    public Set<CascadeType> getCascadeTypes() {
        return this.cascadeTypes;
    }

    @Override
    public boolean ignoreNotFound() {
        return this.ignoreNotFound;
    }

    @Override
    public boolean isInsertable() {
        return this.isInsertable;
    }

    @Override
    public boolean isUpdatable() {
        return this.isUpdateable;
    }

    @Override
    public boolean isKeyCascadeDeleteEnabled() {
        return false;
    }

    @Override
    public String getUnsavedValue() {
        return null;
    }
}

