/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.dom4j.Node;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.compare.EqualsHelper;
import org.hibernate.metamodel.relational.Size;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.type.AbstractType;
import org.hibernate.type.Type;

public class DiscriminatorType
extends AbstractType {
    private final Type underlyingType;
    private final Loadable persister;

    public DiscriminatorType(Type underlyingType, Loadable persister) {
        this.underlyingType = underlyingType;
        this.persister = persister;
    }

    @Override
    public Class getReturnedClass() {
        return Class.class;
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.nullSafeGet(rs, names[0], session, owner);
    }

    @Override
    public Object nullSafeGet(ResultSet rs, String name, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        Object discriminatorValue = this.underlyingType.nullSafeGet(rs, name, session, owner);
        String entityName = this.persister.getSubclassForDiscriminatorValue(discriminatorValue);
        if (entityName == null) {
            throw new HibernateException("Unable to resolve discriminator value [" + discriminatorValue + "] to entity name");
        }
        if (EntityMode.POJO.equals((Object)session.getEntityMode())) {
            return session.getEntityPersister(entityName, null).getMappedClass(session.getEntityMode());
        }
        return entityName;
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index, boolean[] settable, SessionImplementor session) throws HibernateException, SQLException {
        this.nullSafeSet(st, value, index, session);
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        throw new UnsupportedOperationException("At the moment this type is not the one actually used to map the discriminator.");
    }

    @Override
    public String toLoggableString(Object value, SessionFactoryImplementor factory) throws HibernateException {
        return value == null ? "[null]" : value.toString();
    }

    @Override
    public Object deepCopy(Object value, EntityMode entityMode, SessionFactoryImplementor factory) throws HibernateException {
        return value;
    }

    @Override
    public Object replace(Object original, Object target, SessionImplementor session, Object owner, Map copyCache) throws HibernateException {
        return original;
    }

    @Override
    public boolean[] toColumnNullness(Object value, Mapping mapping) {
        return value == null ? ArrayHelper.FALSE : ArrayHelper.TRUE;
    }

    @Override
    public boolean isDirty(Object old, Object current, boolean[] checkable, SessionImplementor session) throws HibernateException {
        return EqualsHelper.equals(old, current);
    }

    @Override
    public int[] sqlTypes(Mapping mapping) throws MappingException {
        return this.underlyingType.sqlTypes(mapping);
    }

    @Override
    public Size[] dictatedSizes(Mapping mapping) throws MappingException {
        return this.underlyingType.dictatedSizes(mapping);
    }

    @Override
    public Size[] defaultSizes(Mapping mapping) throws MappingException {
        return this.underlyingType.defaultSizes(mapping);
    }

    @Override
    public int getColumnSpan(Mapping mapping) throws MappingException {
        return this.underlyingType.getColumnSpan(mapping);
    }

    @Override
    public void setToXMLNode(Node node, Object value, SessionFactoryImplementor factory) throws HibernateException {
    }

    @Override
    public Object fromXMLNode(Node xml, Mapping factory) throws HibernateException {
        return null;
    }
}

