/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message.token;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.WSUsernameTokenPrincipal;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.DOM2Writer;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.ws.security.util.XmlSchemaDateFormat;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class UsernameToken {
    public static final String BASE64_ENCODING = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary";
    public static final String PASSWORD_TYPE = "passwordType";
    public static final int DEFAULT_ITERATION = 1000;
    public static final QName TOKEN = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "UsernameToken");
    private static final Log LOG = LogFactory.getLog(UsernameToken.class);
    private static final boolean DO_DEBUG = LOG.isDebugEnabled();
    protected Element element = null;
    protected Element elementUsername = null;
    protected Element elementPassword = null;
    protected Element elementNonce = null;
    protected Element elementCreated = null;
    protected Element elementSalt = null;
    protected Element elementIteration = null;
    protected String passwordType = null;
    protected boolean hashed = true;
    private String rawPassword;
    private boolean passwordsAreEncoded = false;
    private boolean bspCompliantDerivedKey = true;

    public UsernameToken(Element elem) throws WSSecurityException {
        this(elem, false, true);
    }

    public UsernameToken(Element elem, boolean allowNamespaceQualifiedPasswordTypes, boolean bspCompliant) throws WSSecurityException {
        this.element = elem;
        QName el = new QName(this.element.getNamespaceURI(), this.element.getLocalName());
        if (!el.equals(TOKEN)) {
            throw new WSSecurityException(4, "badUsernameToken");
        }
        this.elementUsername = WSSecurityUtil.getDirectChildElement(this.element, "Username", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        this.elementPassword = WSSecurityUtil.getDirectChildElement(this.element, "Password", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        this.elementNonce = WSSecurityUtil.getDirectChildElement(this.element, "Nonce", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        this.elementCreated = WSSecurityUtil.getDirectChildElement(this.element, "Created", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        this.elementSalt = WSSecurityUtil.getDirectChildElement(this.element, "Salt", "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd");
        this.elementIteration = WSSecurityUtil.getDirectChildElement(this.element, "Iteration", "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd");
        if (this.elementUsername == null) {
            throw new WSSecurityException(4, "badUsernameToken");
        }
        if (bspCompliant) {
            this.checkBSPCompliance();
        }
        this.hashed = false;
        if (this.elementSalt != null) {
            if (this.elementPassword != null || this.elementIteration == null) {
                throw new WSSecurityException(4, "badUsernameToken");
            }
            return;
        }
        if (this.elementPassword != null) {
            if (this.elementPassword.hasAttribute("Type")) {
                this.passwordType = this.elementPassword.getAttribute("Type");
            } else if (this.elementPassword.hasAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Type")) {
                if (allowNamespaceQualifiedPasswordTypes) {
                    this.passwordType = this.elementPassword.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Type");
                } else {
                    throw new WSSecurityException(4, "badUsernameToken");
                }
            }
        }
        if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest".equals(this.passwordType)) {
            this.hashed = true;
            if (this.elementNonce == null || this.elementCreated == null) {
                throw new WSSecurityException(4, "badUsernameToken");
            }
        }
    }

    public UsernameToken(boolean milliseconds, Document doc) {
        this(milliseconds, doc, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest");
    }

    public UsernameToken(boolean milliseconds, Document doc, String pwType) {
        this.element = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:UsernameToken");
        this.elementUsername = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Username");
        this.elementUsername.appendChild(doc.createTextNode(""));
        this.element.appendChild(this.elementUsername);
        if (pwType != null) {
            this.elementPassword = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Password");
            this.elementPassword.appendChild(doc.createTextNode(""));
            this.element.appendChild(this.elementPassword);
            this.passwordType = pwType;
            if (this.passwordType.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest")) {
                this.addNonce(doc);
                this.addCreated(milliseconds, doc);
            } else {
                this.hashed = false;
            }
        }
    }

    public void addWSSENamespace() {
        WSSecurityUtil.setNamespace(this.element, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse");
    }

    public void addWSUNamespace() {
        WSSecurityUtil.setNamespace(this.element, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
    }

    public void addNonce(Document doc) {
        if (this.elementNonce != null) {
            return;
        }
        byte[] nonceValue = null;
        try {
            nonceValue = WSSecurityUtil.generateNonce(16);
        }
        catch (WSSecurityException ex) {
            LOG.debug((Object)ex.getMessage(), (Throwable)ex);
            return;
        }
        this.elementNonce = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:Nonce");
        this.elementNonce.appendChild(doc.createTextNode(Base64.encode(nonceValue)));
        this.elementNonce.setAttributeNS(null, "EncodingType", BASE64_ENCODING);
        this.element.appendChild(this.elementNonce);
    }

    public void addCreated(boolean milliseconds, Document doc) {
        if (this.elementCreated != null) {
            return;
        }
        DateFormat zulu = null;
        if (milliseconds) {
            zulu = new XmlSchemaDateFormat();
        } else {
            zulu = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            zulu.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        this.elementCreated = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Created");
        Date currentTime = new Date();
        this.elementCreated.appendChild(doc.createTextNode(zulu.format(currentTime)));
        this.element.appendChild(this.elementCreated);
    }

    public byte[] addSalt(Document doc, byte[] saltValue, boolean mac) {
        if (saltValue == null) {
            saltValue = UsernameToken.generateSalt(mac);
        }
        this.elementSalt = doc.createElementNS("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "wsse11:Salt");
        WSSecurityUtil.setNamespace(this.element, "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "wsse11");
        this.elementSalt.appendChild(doc.createTextNode(Base64.encode(saltValue)));
        this.element.appendChild(this.elementSalt);
        return saltValue;
    }

    public void addIteration(Document doc, int iteration) {
        String text = "" + iteration;
        this.elementIteration = doc.createElementNS("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "wsse11:Iteration");
        WSSecurityUtil.setNamespace(this.element, "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "wsse11");
        this.elementIteration.appendChild(doc.createTextNode(text));
        this.element.appendChild(this.elementIteration);
    }

    public String getName() {
        return this.nodeString(this.elementUsername);
    }

    public void setName(String name) {
        Text node = this.getFirstNode(this.elementUsername);
        node.setData(name);
    }

    public String getNonce() {
        return this.nodeString(this.elementNonce);
    }

    public String getCreated() {
        return this.nodeString(this.elementCreated);
    }

    public String getPassword() {
        String password = this.nodeString(this.elementPassword);
        if (password == null && this.elementPassword != null) {
            return "";
        }
        return password;
    }

    public byte[] getSalt() throws WSSecurityException {
        String salt = this.nodeString(this.elementSalt);
        if (salt != null) {
            return Base64.decode(salt);
        }
        return null;
    }

    public int getIteration() {
        String iter = this.nodeString(this.elementIteration);
        if (iter != null) {
            return Integer.parseInt(iter);
        }
        return 1000;
    }

    public boolean isHashed() {
        return this.hashed;
    }

    public String getPasswordType() {
        return this.passwordType;
    }

    public void setPassword(String pwd) {
        block9: {
            if (pwd == null) {
                if (this.passwordType != null) {
                    throw new IllegalArgumentException("pwd == null but a password is needed");
                }
                return;
            }
            this.rawPassword = pwd;
            Text node = this.getFirstNode(this.elementPassword);
            try {
                if (this.hashed) {
                    if (this.passwordsAreEncoded) {
                        node.setData(UsernameToken.doPasswordDigest(this.getNonce(), this.getCreated(), Base64.decode(pwd)));
                    } else {
                        node.setData(UsernameToken.doPasswordDigest(this.getNonce(), this.getCreated(), pwd));
                    }
                } else {
                    node.setData(pwd);
                }
                if (this.passwordType != null) {
                    this.elementPassword.setAttributeNS(null, "Type", this.passwordType);
                }
            }
            catch (Exception e) {
                if (!DO_DEBUG) break block9;
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void setRawPassword(RequestData data) throws WSSecurityException {
        WSPasswordCallback pwCb = new WSPasswordCallback(this.getName(), this.getPassword(), this.getPasswordType(), 2, data);
        try {
            data.getCallbackHandler().handle(new Callback[]{pwCb});
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e);
            }
            throw new WSSecurityException(5, null, null, e);
        }
        catch (UnsupportedCallbackException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e);
            }
            throw new WSSecurityException(5, null, null, e);
        }
        this.rawPassword = pwCb.getPassword();
    }

    public void setPasswordsAreEncoded(boolean passwordsAreEncoded) {
        this.passwordsAreEncoded = passwordsAreEncoded;
    }

    public boolean getPasswordsAreEncoded() {
        return this.passwordsAreEncoded;
    }

    public static String doPasswordDigest(String nonce, String created, byte[] password) {
        String passwdDigest;
        block2: {
            passwdDigest = null;
            try {
                byte[] b1 = nonce != null ? Base64.decode(nonce) : new byte[]{};
                byte[] b2 = created != null ? created.getBytes("UTF-8") : new byte[]{};
                byte[] b3 = password;
                byte[] b4 = new byte[b1.length + b2.length + b3.length];
                int offset = 0;
                System.arraycopy(b1, 0, b4, offset, b1.length);
                System.arraycopy(b2, 0, b4, offset += b1.length, b2.length);
                System.arraycopy(b3, 0, b4, offset += b2.length, b3.length);
                byte[] digestBytes = WSSecurityUtil.generateDigest(b4);
                passwdDigest = Base64.encode(digestBytes);
            }
            catch (Exception e) {
                if (!DO_DEBUG) break block2;
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        return passwdDigest;
    }

    public static String doPasswordDigest(String nonce, String created, String password) {
        String passwdDigest;
        block2: {
            passwdDigest = null;
            try {
                passwdDigest = UsernameToken.doPasswordDigest(nonce, created, password.getBytes("UTF-8"));
            }
            catch (Exception e) {
                if (!DO_DEBUG) break block2;
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        return passwdDigest;
    }

    private Text getFirstNode(Element e) {
        Node node = e.getFirstChild();
        return node != null && 3 == node.getNodeType() ? (Text)node : null;
    }

    private String nodeString(Element e) {
        Text node;
        if (e != null && (node = this.getFirstNode(e)) != null) {
            return node.getData();
        }
        return null;
    }

    public Element getElement() {
        return this.element;
    }

    public String toString() {
        return DOM2Writer.nodeToString(this.element);
    }

    public String getID() {
        return this.element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
    }

    public void setID(String id) {
        this.element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", id);
    }

    public byte[] getSecretKey() {
        return this.getSecretKey(16, "WS-Security");
    }

    public byte[] getSecretKey(int keylen) {
        return this.getSecretKey(keylen, "WS-Security");
    }

    public byte[] getSecretKey(int keylen, String labelString) {
        byte[] key = null;
        try {
            Mac mac = Mac.getInstance("HMACSHA1");
            byte[] password = this.passwordsAreEncoded ? Base64.decode(this.rawPassword) : this.rawPassword.getBytes("UTF-8");
            byte[] label = labelString.getBytes("UTF-8");
            byte[] nonce = Base64.decode(this.getNonce());
            byte[] created = this.getCreated().getBytes("UTF-8");
            byte[] seed = new byte[label.length + nonce.length + created.length];
            int offset = 0;
            System.arraycopy(label, 0, seed, offset, label.length);
            System.arraycopy(nonce, 0, seed, offset += label.length, nonce.length);
            System.arraycopy(created, 0, seed, offset += nonce.length, created.length);
            key = UsernameToken.P_hash(password, seed, mac, keylen);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("label      :" + Base64.encode(label)));
                LOG.debug((Object)("nonce      :" + Base64.encode(nonce)));
                LOG.debug((Object)("created    :" + Base64.encode(created)));
                LOG.debug((Object)("seed       :" + Base64.encode(seed)));
                LOG.debug((Object)("Key        :" + Base64.encode(key)));
            }
        }
        catch (Exception e) {
            if (DO_DEBUG) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            }
            return null;
        }
        return key;
    }

    public static byte[] generateDerivedKey(byte[] password, byte[] salt, int iteration) throws WSSecurityException {
        if (iteration == 0) {
            iteration = 1000;
        }
        byte[] pwSalt = new byte[salt.length + password.length];
        System.arraycopy(password, 0, pwSalt, 0, password.length);
        System.arraycopy(salt, 0, pwSalt, password.length, salt.length);
        MessageDigest sha = null;
        try {
            sha = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            if (DO_DEBUG) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            }
            throw new WSSecurityException(0, "noSHA1availabe", null, e);
        }
        byte[] K = sha.digest(pwSalt);
        for (int i = 1; i < iteration; ++i) {
            K = sha.digest(K);
        }
        return K;
    }

    public static byte[] generateDerivedKey(String password, byte[] salt, int iteration) throws WSSecurityException {
        try {
            return UsernameToken.generateDerivedKey(password.getBytes("UTF-8"), salt, iteration);
        }
        catch (UnsupportedEncodingException e) {
            if (DO_DEBUG) {
                LOG.debug((Object)e.getMessage(), (Throwable)e);
            }
            throw new WSSecurityException("Unable to convert password to UTF-8", e);
        }
    }

    public byte[] getDerivedKey() throws WSSecurityException {
        if (this.rawPassword == null || !this.bspCompliantDerivedKey) {
            LOG.debug((Object)"The raw password was null or the Username Token is not BSP compliant");
            throw new WSSecurityException(5);
        }
        int iteration = this.getIteration();
        byte[] salt = this.getSalt();
        if (this.passwordsAreEncoded) {
            return UsernameToken.generateDerivedKey(Base64.decode(this.rawPassword), salt, iteration);
        }
        return UsernameToken.generateDerivedKey(this.rawPassword, salt, iteration);
    }

    public boolean isDerivedKey() throws WSSecurityException {
        return this.elementSalt != null && this.elementIteration != null;
    }

    public Principal createPrincipal() {
        WSUsernameTokenPrincipal principal = new WSUsernameTokenPrincipal(this.getName(), this.isHashed());
        principal.setNonce(this.getNonce());
        principal.setPassword(this.getPassword());
        principal.setCreatedTime(this.getCreated());
        return principal;
    }

    public static byte[] generateSalt(boolean useForMac) {
        byte[] saltValue = null;
        try {
            saltValue = WSSecurityUtil.generateNonce(16);
        }
        catch (WSSecurityException ex) {
            LOG.debug((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
        saltValue[15] = useForMac ? 1 : 2;
        return saltValue;
    }

    public int hashCode() {
        int result;
        block8: {
            String created;
            String nonce;
            String passwordType;
            String password;
            result = 17;
            String username = this.getName();
            if (username != null) {
                result = 31 * result + username.hashCode();
            }
            if ((password = this.getPassword()) != null) {
                result = 31 * result + password.hashCode();
            }
            if ((passwordType = this.getPasswordType()) != null) {
                result = 31 * result + passwordType.hashCode();
            }
            if ((nonce = this.getNonce()) != null) {
                result = 31 * result + nonce.hashCode();
            }
            if ((created = this.getCreated()) != null) {
                result = 31 * result + created.hashCode();
            }
            try {
                byte[] salt = this.getSalt();
                if (salt != null) {
                    result = 31 * result + Arrays.hashCode(salt);
                }
            }
            catch (WSSecurityException ex) {
                if (!LOG.isDebugEnabled()) break block8;
                LOG.debug((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        result = 31 * result + Integer.valueOf(this.getIteration()).hashCode();
        return result;
    }

    public boolean equals(Object object) {
        int iteration;
        UsernameToken usernameToken;
        block9: {
            if (!(object instanceof UsernameToken)) {
                return false;
            }
            usernameToken = (UsernameToken)object;
            if (!this.compare(usernameToken.getName(), this.getName())) {
                return false;
            }
            if (!this.compare(usernameToken.getPassword(), this.getPassword())) {
                return false;
            }
            if (!this.compare(usernameToken.getPasswordType(), this.getPasswordType())) {
                return false;
            }
            if (!this.compare(usernameToken.getNonce(), this.getNonce())) {
                return false;
            }
            if (!this.compare(usernameToken.getCreated(), this.getCreated())) {
                return false;
            }
            try {
                byte[] salt = usernameToken.getSalt();
                if (!Arrays.equals(salt, this.getSalt())) {
                    return false;
                }
            }
            catch (WSSecurityException ex) {
                if (!LOG.isDebugEnabled()) break block9;
                LOG.debug((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return (iteration = usernameToken.getIteration()) == this.getIteration();
    }

    private boolean compare(String item1, String item2) {
        if (item1 == null && item2 != null) {
            return false;
        }
        return item1 == null || item1.equals(item2);
    }

    private static byte[] P_hash(byte[] secret, byte[] seed, Mac mac, int required) throws Exception {
        byte[] out = new byte[required];
        int offset = 0;
        byte[] A = seed;
        SecretKeySpec key = new SecretKeySpec(secret, "HMACSHA1");
        mac.init(key);
        while (required > 0) {
            mac.update(A);
            A = mac.doFinal();
            mac.update(A);
            mac.update(seed);
            byte[] tmp = mac.doFinal();
            int tocpy = UsernameToken.min(required, tmp.length);
            System.arraycopy(tmp, 0, out, offset, tocpy);
            offset += tocpy;
            required -= tocpy;
        }
        return out;
    }

    private static int min(int a, int b) {
        return a > b ? b : a;
    }

    private void checkBSPCompliance() throws WSSecurityException {
        Element nonce;
        String encodingType;
        Element passwordChild;
        String type;
        List<Element> passwordElements = WSSecurityUtil.getDirectChildElements(this.element, "Password", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        if (passwordElements.size() > 1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"The Username Token had more than one password element");
            }
            throw new WSSecurityException(4, "badUsernameToken");
        }
        if (passwordElements.size() == 1 && ((type = (passwordChild = passwordElements.get(0)).getAttributeNS(null, "Type")) == null || "".equals(type))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"The Username Token password does not have a Type attribute");
            }
            throw new WSSecurityException(4, "badUsernameToken");
        }
        if (this.elementSalt == null) {
            this.bspCompliantDerivedKey = false;
        }
        if (this.elementIteration == null) {
            this.bspCompliantDerivedKey = false;
        } else {
            String iter = this.nodeString(this.elementIteration);
            if (iter == null || Integer.parseInt(iter) < 1000) {
                this.bspCompliantDerivedKey = false;
            }
        }
        List<Element> createdElements = WSSecurityUtil.getDirectChildElements(this.element, "Created", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        if (createdElements.size() > 1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"The Username Token has more than one created element");
            }
            throw new WSSecurityException(4, "badUsernameToken");
        }
        List<Element> nonceElements = WSSecurityUtil.getDirectChildElements(this.element, "Nonce", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd");
        if (nonceElements.size() > 1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"The Username Token has more than one nonce element");
            }
            throw new WSSecurityException(4, "badUsernameToken");
        }
        if (nonceElements.size() == 1 && ((encodingType = (nonce = nonceElements.get(0)).getAttribute("EncodingType")) == null || "".equals(encodingType) || !BASE64_ENCODING.equals(encodingType))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"The Username Token's nonce element has a bad encoding type");
            }
            throw new WSSecurityException(4, "badUsernameToken");
        }
    }
}

