/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.jsfsession;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIViewRoot;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import org.jboss.jsfunit.framework.FacesContextBridge;
import org.jboss.jsfunit.jsfsession.ComponentIDNotFoundException;
import org.jboss.jsfunit.jsfsession.DuplicateClientIDException;
import org.jboss.jsfunit.jsfsession.UIDataValueManager;

public class ClientIDs {
    private List<String> allClientIDs = new ArrayList<String>();
    private Map<String, UIComponent> allComponents = new HashMap<String, UIComponent>();
    private Map<String, Set> ancestors = new HashMap<String, Set>();
    private Map<String, UIDataValueManager> uiDataMap = new HashMap<String, UIDataValueManager>();

    ClientIDs() {
        FacesContext facesContext = FacesContextBridge.getCurrentInstance();
        UIViewRoot component = facesContext.getViewRoot();
        this.addAllIDs((UIComponent)component, facesContext);
    }

    private void addAllIDs(UIComponent component, FacesContext facesContext) {
        if (component == null) {
            return;
        }
        this.addClientID(component, facesContext);
        this.newAncestorEntry(component, facesContext);
        if (component instanceof UIData) {
            this.addUIData((UIData)component, facesContext);
            return;
        }
        Iterator facetsAndChildren = component.getFacetsAndChildren();
        while (facetsAndChildren.hasNext()) {
            UIComponent facetOrChild = (UIComponent)facetsAndChildren.next();
            this.addAncestors(component, facetOrChild, facesContext);
            this.addAllIDs(facetOrChild, facesContext);
        }
    }

    private void newAncestorEntry(UIComponent component, FacesContext facesContext) {
        String clientID = component.getClientId(facesContext);
        if (this.ancestors.get(clientID) == null) {
            HashSet<String> myAncestors = new HashSet<String>();
            myAncestors.add(clientID);
            this.ancestors.put(clientID, myAncestors);
        }
    }

    private void addAncestors(UIComponent parent, UIComponent child, FacesContext facesContext) {
        if (child == null) {
            return;
        }
        this.addAncestors(parent.getClientId(facesContext), child.getClientId(facesContext));
    }

    private void addAncestors(String parentClientID, String childClientID) {
        HashSet<String> myAncestors = new HashSet<String>(this.ancestors.get(parentClientID));
        myAncestors.add(childClientID);
        this.ancestors.put(childClientID, myAncestors);
    }

    private void addUIData(UIData component, FacesContext facesContext) {
        String parentClientID = component.getClientId(facesContext);
        int rowsToDisplay = component.getRows();
        try {
            if (rowsToDisplay == 0) {
                rowsToDisplay = component.getRowCount();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        for (int i = 0; i < rowsToDisplay; ++i) {
            component.setRowIndex(i);
            this.addAncestors(parentClientID, component.getClientId(facesContext));
            Iterator facetsAndChildren = component.getFacetsAndChildren();
            while (facetsAndChildren.hasNext()) {
                UIComponent facetOrChild = (UIComponent)facetsAndChildren.next();
                this.fillUIDataMap(component, facetOrChild, facesContext);
                this.addAncestors((UIComponent)component, facetOrChild, facesContext);
                this.addAllIDs(facetOrChild, facesContext);
            }
        }
        try {
            component.setRowIndex(-1);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void fillUIDataMap(UIData uiData, UIComponent component, FacesContext facesContext) {
        this.updateUIDataMap(uiData, component, facesContext);
        Iterator facetsAndChildren = component.getFacetsAndChildren();
        while (facetsAndChildren.hasNext()) {
            UIComponent facetOrChild = (UIComponent)facetsAndChildren.next();
            this.fillUIDataMap(uiData, facetOrChild, facesContext);
        }
    }

    private void updateUIDataMap(UIData uiData, UIComponent facetOrChild, FacesContext facesContext) {
        if (!(facetOrChild instanceof ValueHolder)) {
            return;
        }
        String clientID = facetOrChild.getClientId(facesContext);
        if (this.uiDataMap.containsKey(clientID)) {
            return;
        }
        ValueHolder valueHolder = (ValueHolder)facetOrChild;
        this.uiDataMap.put(clientID, new UIDataValueManager(uiData, valueHolder));
    }

    private void addClientID(UIComponent component, FacesContext facesContext) {
        if (component instanceof UIViewRoot) {
            return;
        }
        String clientId = component.getClientId(facesContext);
        if (clientId == null) {
            return;
        }
        if (this.allClientIDs.contains(clientId)) {
            return;
        }
        this.allClientIDs.add(clientId);
        this.allComponents.put(clientId, component);
    }

    public String findClientID(String suffix) {
        if (suffix == null) {
            throw new NullPointerException();
        }
        ArrayList<String> matches = new ArrayList<String>();
        for (String id : this.allClientIDs) {
            if (!id.endsWith(suffix)) continue;
            matches.add(id);
        }
        if (matches.size() == 1) {
            return (String)matches.get(0);
        }
        if (matches.isEmpty()) {
            throw new ComponentIDNotFoundException(suffix);
        }
        throw new DuplicateClientIDException(suffix, matches);
    }

    public UIComponent findComponent(String suffix) {
        return this.allComponents.get(this.findClientID(suffix));
    }

    public Object getComponentValue(String componentID) {
        UIComponent component = this.findComponent(componentID);
        if (!(component instanceof ValueHolder)) {
            throw new ClassCastException(componentID + " must be an instance of ValueHolder.");
        }
        String clientId = this.findClientID(componentID);
        if (this.uiDataMap.containsKey(clientId)) {
            return this.uiDataMap.get(clientId).getValue();
        }
        return ((ValueHolder)component).getValue();
    }

    public boolean isAncestor(String clientID, String ancestorClientID) {
        Set ancestorSet = this.ancestors.get(clientID);
        if (ancestorSet == null) {
            return false;
        }
        return ancestorSet.contains(ancestorClientID);
    }

    public void dumpAllIDs() {
        Iterator<String> i = this.allClientIDs.iterator();
        while (i.hasNext()) {
            System.out.println(i.next());
        }
    }
}

