/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.util.Arrays;
import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.index.PageBtree;
import org.h2.index.PageBtreeCursor;
import org.h2.index.PageBtreeIndex;
import org.h2.index.PageBtreeNode;
import org.h2.message.DbException;
import org.h2.result.SearchRow;
import org.h2.store.Data;
import org.h2.store.Page;
import org.h2.store.PageStore;

public class PageBtreeLeaf
extends PageBtree {
    private static final int OFFSET_LENGTH = 2;
    private final boolean optimizeUpdate;
    private boolean writtenData;

    private PageBtreeLeaf(PageBtreeIndex pageBtreeIndex, int n, Data data) {
        super(pageBtreeIndex, n, data);
        this.optimizeUpdate = pageBtreeIndex.getDatabase().getSettings().optimizeUpdate;
    }

    public static Page read(PageBtreeIndex pageBtreeIndex, Data data, int n) {
        PageBtreeLeaf pageBtreeLeaf = new PageBtreeLeaf(pageBtreeIndex, n, data);
        pageBtreeLeaf.read();
        return pageBtreeLeaf;
    }

    static PageBtreeLeaf create(PageBtreeIndex pageBtreeIndex, int n, int n2) {
        PageBtreeLeaf pageBtreeLeaf = new PageBtreeLeaf(pageBtreeIndex, n, pageBtreeIndex.getPageStore().createData());
        pageBtreeIndex.getPageStore().logUndo(pageBtreeLeaf, null);
        pageBtreeLeaf.rows = SearchRow.EMPTY_ARRAY;
        pageBtreeLeaf.parentPageId = n2;
        pageBtreeLeaf.writeHead();
        pageBtreeLeaf.start = pageBtreeLeaf.data.length();
        return pageBtreeLeaf;
    }

    private void read() {
        this.data.reset();
        byte by = this.data.readByte();
        this.data.readShortInt();
        this.parentPageId = this.data.readInt();
        this.onlyPosition = (by & 0x10) == 0;
        int n = this.data.readVarInt();
        if (n != this.index.getId()) {
            throw DbException.get(90030, "page:" + this.getPos() + " expected index:" + this.index.getId() + "got:" + n);
        }
        this.entryCount = this.data.readShortInt();
        this.offsets = new int[this.entryCount];
        this.rows = new SearchRow[this.entryCount];
        for (int i = 0; i < this.entryCount; ++i) {
            this.offsets[i] = this.data.readShortInt();
        }
        this.start = this.data.length();
        this.written = true;
        this.writtenData = true;
    }

    int addRowTry(SearchRow searchRow) {
        return this.addRow(searchRow, true);
    }

    private int addRow(SearchRow searchRow, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = this.index.getRowSize(this.data, searchRow, this.onlyPosition);
        int n5 = this.index.getPageStore().getPageSize();
        int n6 = n3 = this.entryCount == 0 ? n5 : this.offsets[this.entryCount - 1];
        if (n3 - n4 < this.start + 2) {
            if (bl && this.entryCount > 1) {
                int n7 = this.find(searchRow, false, true, true);
                if (this.entryCount < 5) {
                    return this.entryCount / 2;
                }
                int n8 = this.entryCount / 3;
                return n7 < n8 ? n8 : (n7 >= 2 * n8 ? 2 * n8 : n7);
            }
            this.readAllRows();
            this.onlyPosition = true;
            n2 = n5;
            for (n = 0; n < this.entryCount; ++n) {
                this.offsets[n] = n2 -= this.index.getRowSize(this.data, this.getRow(n), true);
            }
            n3 = this.entryCount == 0 ? n5 : this.offsets[this.entryCount - 1];
            n4 = this.index.getRowSize(this.data, searchRow, true);
            if (SysProperties.CHECK && n3 - n4 < this.start + 2) {
                throw DbException.throwInternalError();
            }
        }
        this.index.getPageStore().logUndo(this, this.data);
        if (!this.optimizeUpdate) {
            this.readAllRows();
        }
        this.changeCount = this.index.getPageStore().getChangeCount();
        this.written = false;
        n2 = this.entryCount == 0 ? 0 : this.find(searchRow, false, true, true);
        this.start += 2;
        n = (n2 == 0 ? n5 : this.offsets[n2 - 1]) - n4;
        if (this.optimizeUpdate && this.writtenData) {
            if (this.entryCount > 0) {
                byte[] byArray = this.data.getBytes();
                int n9 = this.offsets[this.entryCount - 1];
                int n10 = n;
                System.arraycopy(byArray, n9, byArray, n9 - n4, n10 - n9 + n4);
            }
            this.index.writeRow(this.data, n, searchRow, this.onlyPosition);
        }
        this.offsets = PageBtreeLeaf.insert(this.offsets, this.entryCount, n2, n);
        PageBtreeLeaf.add(this.offsets, n2 + 1, this.entryCount + 1, -n4);
        this.rows = PageBtreeLeaf.insert(this.rows, this.entryCount, n2, searchRow);
        ++this.entryCount;
        this.index.getPageStore().update(this);
        this.memoryChange();
        return -1;
    }

    private void removeRow(int n) {
        if (!this.optimizeUpdate) {
            this.readAllRows();
        }
        this.index.getPageStore().logUndo(this, this.data);
        --this.entryCount;
        this.written = false;
        this.changeCount = this.index.getPageStore().getChangeCount();
        if (this.entryCount <= 0) {
            DbException.throwInternalError();
        }
        int n2 = n > 0 ? this.offsets[n - 1] : this.index.getPageStore().getPageSize();
        int n3 = n2 - this.offsets[n];
        this.start -= 2;
        if (this.optimizeUpdate && this.writtenData) {
            byte[] byArray = this.data.getBytes();
            int n4 = this.offsets[this.entryCount];
            System.arraycopy(byArray, n4, byArray, n4 + n3, this.offsets[n] - n4);
            Arrays.fill(byArray, n4, n4 + n3, (byte)0);
        }
        this.offsets = PageBtreeLeaf.remove(this.offsets, this.entryCount + 1, n);
        PageBtreeLeaf.add(this.offsets, n, this.entryCount, n3);
        this.rows = PageBtreeLeaf.remove(this.rows, this.entryCount + 1, n);
        this.memoryChange();
    }

    int getEntryCount() {
        return this.entryCount;
    }

    PageBtree split(int n) {
        int n2 = this.index.getPageStore().allocatePage();
        PageBtreeLeaf pageBtreeLeaf = PageBtreeLeaf.create(this.index, n2, this.parentPageId);
        int n3 = n;
        while (n3 < this.entryCount) {
            pageBtreeLeaf.addRow(this.getRow(n), false);
            this.removeRow(n);
        }
        return pageBtreeLeaf;
    }

    PageBtreeLeaf getFirstLeaf() {
        return this;
    }

    PageBtreeLeaf getLastLeaf() {
        return this;
    }

    SearchRow remove(SearchRow searchRow) {
        int n = this.find(searchRow, false, false, true);
        SearchRow searchRow2 = this.getRow(n);
        if (this.index.compareRows(searchRow, searchRow2) != 0 || searchRow2.getKey() != searchRow.getKey()) {
            throw DbException.get(90112, this.index.getSQL() + ": " + searchRow);
        }
        this.index.getPageStore().logUndo(this, this.data);
        if (this.entryCount == 1) {
            return searchRow;
        }
        this.removeRow(n);
        this.index.getPageStore().update(this);
        if (n == this.entryCount) {
            return this.getRow(n - 1);
        }
        return null;
    }

    void freeRecursive() {
        this.index.getPageStore().logUndo(this, this.data);
        this.index.getPageStore().free(this.getPos());
    }

    int getRowCount() {
        return this.entryCount;
    }

    void setRowCountStored(int n) {
    }

    public void write() {
        this.writeData();
        this.index.getPageStore().writePage(this.getPos(), this.data);
    }

    private void writeHead() {
        this.data.reset();
        this.data.writeByte((byte)(4 | (this.onlyPosition ? 0 : 16)));
        this.data.writeShortInt(0);
        this.data.writeInt(this.parentPageId);
        this.data.writeVarInt(this.index.getId());
        this.data.writeShortInt(this.entryCount);
    }

    private void writeData() {
        int n;
        if (this.written) {
            return;
        }
        if (!this.optimizeUpdate) {
            this.readAllRows();
        }
        this.writeHead();
        for (n = 0; n < this.entryCount; ++n) {
            this.data.writeShortInt(this.offsets[n]);
        }
        if (!this.writtenData || !this.optimizeUpdate) {
            for (n = 0; n < this.entryCount; ++n) {
                this.index.writeRow(this.data, this.offsets[n], this.rows[n], this.onlyPosition);
            }
            this.writtenData = true;
        }
        this.written = true;
        this.memoryChange();
    }

    void find(PageBtreeCursor pageBtreeCursor, SearchRow searchRow, boolean bl) {
        int n = this.find(searchRow, bl, false, false);
        if (n > this.entryCount) {
            if (this.parentPageId == 0) {
                return;
            }
            PageBtreeNode pageBtreeNode = (PageBtreeNode)this.index.getPage(this.parentPageId);
            pageBtreeNode.find(pageBtreeCursor, searchRow, bl);
            return;
        }
        pageBtreeCursor.setCurrent(this, n);
    }

    void last(PageBtreeCursor pageBtreeCursor) {
        pageBtreeCursor.setCurrent(this, this.entryCount - 1);
    }

    void remapChildren() {
    }

    void nextPage(PageBtreeCursor pageBtreeCursor) {
        if (this.parentPageId == 0) {
            pageBtreeCursor.setCurrent(null, 0);
            return;
        }
        PageBtreeNode pageBtreeNode = (PageBtreeNode)this.index.getPage(this.parentPageId);
        pageBtreeNode.nextPage(pageBtreeCursor, this.getPos());
    }

    void previousPage(PageBtreeCursor pageBtreeCursor) {
        if (this.parentPageId == 0) {
            pageBtreeCursor.setCurrent(null, 0);
            return;
        }
        PageBtreeNode pageBtreeNode = (PageBtreeNode)this.index.getPage(this.parentPageId);
        pageBtreeNode.previousPage(pageBtreeCursor, this.getPos());
    }

    public String toString() {
        return "page[" + this.getPos() + "] b-tree leaf table:" + this.index.getId() + " entries:" + this.entryCount;
    }

    public void moveTo(Session session, int n) {
        PageStore pageStore = this.index.getPageStore();
        this.readAllRows();
        PageBtreeLeaf pageBtreeLeaf = PageBtreeLeaf.create(this.index, n, this.parentPageId);
        pageStore.logUndo(this, this.data);
        pageStore.logUndo(pageBtreeLeaf, null);
        pageBtreeLeaf.rows = this.rows;
        pageBtreeLeaf.entryCount = this.entryCount;
        pageBtreeLeaf.offsets = this.offsets;
        pageBtreeLeaf.onlyPosition = this.onlyPosition;
        pageBtreeLeaf.parentPageId = this.parentPageId;
        pageBtreeLeaf.start = this.start;
        pageStore.update(pageBtreeLeaf);
        if (this.parentPageId == 0) {
            this.index.setRootPageId(session, n);
        } else {
            PageBtreeNode pageBtreeNode = (PageBtreeNode)pageStore.getPage(this.parentPageId);
            pageBtreeNode.moveChild(this.getPos(), n);
        }
        pageStore.free(this.getPos());
    }

    private void memoryChange() {
        int n = 184 + this.index.getPageStore().getPageSize();
        if (this.rows != null) {
            n += this.getEntryCount() * 12;
            for (int i = 0; i < this.entryCount; ++i) {
                SearchRow searchRow = this.rows[i];
                if (searchRow == null) continue;
                n += searchRow.getMemory();
            }
        }
        this.index.memoryChange(n >> 2);
    }
}

