/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.modules.Module;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;

public class WeldModuleResourceLoader
implements ResourceLoader {
    private final Module module;
    private final Map<String, Class<?>> classes;

    public WeldModuleResourceLoader(Module module) {
        this.module = module;
        this.classes = new ConcurrentHashMap();
    }

    public Class<?> classForName(String name) {
        try {
            Class clazz;
            if (this.classes.containsKey(name)) {
                return this.classes.get(name);
            }
            for (Class c = clazz = this.module.getClassLoader().loadClass(name); c != null && c != Object.class; c = c.getSuperclass()) {
                for (Method method : c.getDeclaredMethods()) {
                    method.getAnnotations();
                }
                for (AccessibleObject accessibleObject : c.getDeclaredFields()) {
                    accessibleObject.getAnnotations();
                }
                c.getDeclaredAnnotations();
            }
            this.classes.put(name, clazz);
            return clazz;
        }
        catch (NoClassDefFoundError e) {
            throw new ResourceLoadingException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new ResourceLoadingException((Throwable)e);
        }
        catch (LinkageError e) {
            throw new ResourceLoadingException((Throwable)e);
        }
    }

    public void addAdditionalClass(Class<?> clazz) {
        this.classes.put(clazz.getName(), clazz);
    }

    public URL getResource(String name) {
        try {
            return this.module.getClassLoader().getResource(name);
        }
        catch (Exception e) {
            throw new ResourceLoadingException((Throwable)e);
        }
    }

    public Collection<URL> getResources(String name) {
        try {
            HashSet<URL> resources = new HashSet<URL>();
            Enumeration urls = this.module.getClassLoader().getResources(name);
            while (urls.hasMoreElements()) {
                resources.add((URL)urls.nextElement());
            }
            return resources;
        }
        catch (Exception e) {
            throw new ResourceLoadingException((Throwable)e);
        }
    }

    public void cleanup() {
    }
}

