/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import java.util.HashSet;
import java.util.Set;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ee.component.EEApplicationDescription;
import org.jboss.as.ee.component.EEModuleClassConfiguration;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InterceptorDescription;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.weld.WeldContainer;
import org.jboss.as.weld.WeldDeploymentMarker;
import org.jboss.as.weld.injection.WeldInjectionInterceptor;
import org.jboss.as.weld.injection.WeldManagedReferenceFactory;
import org.jboss.as.weld.services.WeldService;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class WeldComponentIntegrationProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!WeldDeploymentMarker.isWeldDeployment(deploymentUnit)) {
            return;
        }
        DeploymentUnit topLevelDeployment = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        final ServiceName weldServiceName = topLevelDeployment.getServiceName().append(WeldService.SERVICE_NAME);
        for (ComponentDescription component : eeModuleDescription.getComponentDescriptions()) {
            final String beanName = component instanceof SessionBeanComponentDescription ? component.getComponentName() : null;
            component.getConfigurators().addFirst(new ComponentConfigurator(){

                public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
                    Class componentClass = configuration.getModuleClassConfiguration().getModuleClass();
                    DeploymentUnit deploymentUnit = context.getDeploymentUnit();
                    ModuleClassLoader classLoader = ((Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE)).getClassLoader();
                    EEApplicationDescription applicationDescription = (EEApplicationDescription)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_DESCRIPTION);
                    HashSet interceptorClasses = new HashSet();
                    for (InterceptorDescription interceptorDescription : description.getAllInterceptors()) {
                        EEModuleClassConfiguration clazz = applicationDescription.getClassConfiguration(interceptorDescription.getInterceptorClassName());
                        if (clazz == null) continue;
                        interceptorClasses.add(clazz.getModuleClass());
                    }
                    WeldComponentIntegrationProcessor.this.addWeldInstantiator(context.getServiceTarget(), configuration, componentClass, beanName, weldServiceName, interceptorClasses, (ClassLoader)classLoader, description.getBeanDeploymentArchiveId());
                    configuration.addPostConstructInterceptor((InterceptorFactory)new WeldInjectionInterceptor.Factory(configuration, interceptorClasses), 2304);
                }
            });
        }
    }

    private void addWeldInstantiator(ServiceTarget target, ComponentConfiguration configuration, Class<?> componentClass, String beanName, ServiceName weldServiceName, Set<Class<?>> interceptorClasses, ClassLoader classLoader, String beanDeploymentArchiveId) {
        final ServiceName serviceName = configuration.getComponentDescription().getServiceName().append(new String[]{"WeldInstantiator"});
        WeldManagedReferenceFactory factory = new WeldManagedReferenceFactory(componentClass, beanName, interceptorClasses, classLoader, beanDeploymentArchiveId);
        target.addService(serviceName, (Service)factory).addDependency(weldServiceName, WeldContainer.class, factory.getWeldContainer()).install();
        configuration.setInstanceFactory((ManagedReferenceFactory)factory);
        configuration.getStartDependencies().add(new DependencyConfigurator(){

            public void configureDependency(ServiceBuilder<?> serviceBuilder) throws DeploymentUnitProcessingException {
                serviceBuilder.addDependency(serviceName);
            }
        });
    }

    public void undeploy(DeploymentUnit context) {
    }
}

