/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import javax.interceptor.InvocationContext;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InterceptorDescription;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.weld.WeldDeploymentMarker;
import org.jboss.as.weld.ejb.Jsr299BindingsInterceptor;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.logging.Logger;

public class WeldEjbInterceptorIntegrationProcessor
implements DeploymentUnitProcessor {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.weld");
    private static final String CDI_INTERCEPTOR = Jsr299BindingsInterceptor.class.getName();

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!WeldDeploymentMarker.isWeldDeployment(deploymentUnit)) {
            return;
        }
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        EEModuleClassDescription cdiInterceptorClass = moduleDescription.getOrAddClassByName(CDI_INTERCEPTOR);
        cdiInterceptorClass.setPostConstructMethod(MethodIdentifier.getIdentifier(Void.TYPE, (String)"doPostConstruct", (Class[])new Class[]{InvocationContext.class}));
        cdiInterceptorClass.setPreDestroyMethod(MethodIdentifier.getIdentifier(Void.TYPE, (String)"doPreDestroy", (Class[])new Class[]{InvocationContext.class}));
        cdiInterceptorClass.setAroundInvokeMethod(MethodIdentifier.getIdentifier(Object.class, (String)"doAroundInvoke", (Class[])new Class[]{InvocationContext.class}));
        for (ComponentDescription component : moduleDescription.getComponentDescriptions()) {
            if (!(component instanceof SessionBeanComponentDescription)) continue;
            component.addClassInterceptor(new InterceptorDescription(CDI_INTERCEPTOR));
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

